/*
 * Decompiled with CFR 0.152.
 */
package de.jodamob.mockitoid;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Application;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.Editable;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewPropertyAnimator;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.TextView;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class AndroidMocks {
    public static Context mockContext() {
        return (Context)Mockito.mock(Context.class);
    }

    public static MenuItem mockMenuItem() {
        return (MenuItem)Mockito.mock(MenuItem.class);
    }

    public static MenuItem mockMenuItem(int itemId) {
        MenuItem item = AndroidMocks.mockMenuItem();
        Mockito.when((Object)item.getItemId()).thenReturn((Object)itemId);
        return item;
    }

    public static LayoutInflater mockLayoutInflater() {
        LayoutInflater mock = (LayoutInflater)Mockito.mock(LayoutInflater.class);
        Mockito.when((Object)mock.inflate(Matchers.anyInt(), (ViewGroup)Matchers.any(ViewGroup.class))).thenReturn((Object)AndroidMocks.mockView());
        Mockito.when((Object)mock.inflate(Matchers.anyInt(), (ViewGroup)Matchers.any(ViewGroup.class), Matchers.anyBoolean())).thenReturn((Object)AndroidMocks.mockView());
        return mock;
    }

    public static Intent mockIntent() {
        return (Intent)Mockito.mock(Intent.class);
    }

    public static Bundle mockBundle() {
        return (Bundle)Mockito.mock(Bundle.class);
    }

    public static View mockView(ViewPropertyAnimator animator) {
        View view = AndroidMocks.mockView();
        Mockito.when((Object)view.animate()).thenReturn((Object)animator);
        return view;
    }

    public static View mockView() {
        return (View)Mockito.mock(View.class);
    }

    @SuppressLint(value={"NewApi"})
    public static ViewPropertyAnimator mockViewPropertyAnimator() {
        ViewPropertyAnimator animator = (ViewPropertyAnimator)Mockito.mock(ViewPropertyAnimator.class);
        Mockito.when((Object)animator.alpha(Matchers.anyFloat())).thenReturn((Object)animator);
        Mockito.when((Object)animator.alphaBy(Matchers.anyFloat())).thenReturn((Object)animator);
        Mockito.when((Object)animator.rotation(Matchers.anyFloat())).thenReturn((Object)animator);
        Mockito.when((Object)animator.rotationBy(Matchers.anyFloat())).thenReturn((Object)animator);
        Mockito.when((Object)animator.rotationX(Matchers.anyFloat())).thenReturn((Object)animator);
        Mockito.when((Object)animator.rotationXBy(Matchers.anyFloat())).thenReturn((Object)animator);
        Mockito.when((Object)animator.rotationY(Matchers.anyFloat())).thenReturn((Object)animator);
        Mockito.when((Object)animator.rotationYBy(Matchers.anyFloat())).thenReturn((Object)animator);
        Mockito.when((Object)animator.translationX(Matchers.anyFloat())).thenReturn((Object)animator);
        Mockito.when((Object)animator.translationXBy(Matchers.anyFloat())).thenReturn((Object)animator);
        Mockito.when((Object)animator.translationY(Matchers.anyFloat())).thenReturn((Object)animator);
        Mockito.when((Object)animator.translationYBy(Matchers.anyFloat())).thenReturn((Object)animator);
        Mockito.when((Object)animator.translationZ(Matchers.anyFloat())).thenReturn((Object)animator);
        Mockito.when((Object)animator.translationZBy(Matchers.anyFloat())).thenReturn((Object)animator);
        Mockito.when((Object)animator.setDuration(Matchers.anyLong())).thenReturn((Object)animator);
        return animator;
    }

    public static TextView mockTextView() {
        return (TextView)Mockito.mock(TextView.class);
    }

    public static TextView mockTextView(Resources resources) {
        TextView view = (TextView)Mockito.mock(TextView.class);
        Mockito.when((Object)view.getResources()).thenReturn((Object)resources);
        return view;
    }

    public static Button mockButton() {
        return (Button)Mockito.mock(Button.class);
    }

    public static ImageButton mockImageButton() {
        return (ImageButton)Mockito.mock(ImageButton.class);
    }

    public static Fragment mockFragment() {
        return (Fragment)Mockito.mock(Fragment.class);
    }

    public static Activity mockActivity(Application application) {
        Activity activity = AndroidMocks.mockActivity();
        Mockito.when((Object)activity.getApplication()).thenReturn((Object)application);
        return activity;
    }

    public static Activity mockActivity() {
        return (Activity)Mockito.mock(Activity.class);
    }

    public static FragmentManager mockFragmentManager() {
        FragmentTransaction transaction = (FragmentTransaction)Mockito.mock(FragmentTransaction.class);
        return AndroidMocks.mockFragmentManager(transaction);
    }

    @TargetApi(value=11)
    @SuppressLint(value={"CommitTransaction"})
    public static FragmentManager mockFragmentManager(FragmentTransaction transaction) {
        FragmentManager fragmentManager = (FragmentManager)Mockito.mock(FragmentManager.class);
        Mockito.when((Object)fragmentManager.beginTransaction()).thenReturn((Object)transaction);
        Mockito.when((Object)transaction.replace(Matchers.anyInt(), (Fragment)Matchers.any(Fragment.class))).thenReturn((Object)transaction);
        Mockito.when((Object)transaction.replace(Matchers.anyInt(), (Fragment)Matchers.any(Fragment.class), Matchers.anyString())).thenReturn((Object)transaction);
        Mockito.when((Object)transaction.remove((Fragment)Matchers.any(Fragment.class))).thenReturn((Object)transaction);
        Mockito.when((Object)transaction.addToBackStack(Matchers.anyString())).thenReturn((Object)transaction);
        Mockito.when((Object)transaction.add(Matchers.anyInt(), (Fragment)Matchers.any(Fragment.class))).thenReturn((Object)transaction);
        Mockito.when((Object)transaction.add(Matchers.anyInt(), (Fragment)Matchers.any(Fragment.class), Matchers.anyString())).thenReturn((Object)transaction);
        Mockito.when((Object)transaction.setCustomAnimations(Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)transaction);
        Mockito.when((Object)transaction.setCustomAnimations(Matchers.anyInt(), Matchers.anyInt(), Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)transaction);
        return fragmentManager;
    }

    public static Editable mockEditable(String s) {
        Editable value = (Editable)Mockito.mock(Editable.class);
        Mockito.when((Object)value.toString()).thenReturn((Object)s);
        return value;
    }

    public static EditText mockEditField(Editable editable) {
        EditText field = (EditText)Mockito.mock(EditText.class);
        Mockito.when((Object)field.getText()).thenReturn((Object)editable);
        return field;
    }

    public static EditText mockEditText(String s) {
        return AndroidMocks.mockEditText(s);
    }

    @Deprecated
    public static EditText mockEditField(String s) {
        EditText field = (EditText)Mockito.mock(EditText.class);
        return AndroidMocks.prepare(s, field);
    }

    public static Resources mockResources() {
        Resources resources = (Resources)Mockito.mock(Resources.class);
        Mockito.when((Object)resources.getText(Matchers.anyInt())).thenReturn((Object)"");
        Mockito.when((Object)resources.getString(Matchers.anyInt())).thenReturn((Object)"");
        return resources;
    }

    public static EditText prepare(String s, EditText field) {
        Editable value = (Editable)Mockito.mock(Editable.class);
        Mockito.when((Object)field.getText()).thenReturn((Object)value);
        Mockito.when((Object)value.toString()).thenReturn((Object)s);
        Mockito.when((Object)value.length()).thenReturn((Object)s.length());
        return field;
    }

    public static TextView mockTextView(String s) {
        TextView field = (TextView)Mockito.mock(TextView.class);
        Mockito.when((Object)field.getText()).thenReturn((Object)s);
        return field;
    }

    public static AutoCompleteTextView mockAutoCompleteEditField(String s) {
        AutoCompleteTextView field = (AutoCompleteTextView)Mockito.mock(AutoCompleteTextView.class);
        return (AutoCompleteTextView)AndroidMocks.prepare(s, (EditText)field);
    }

    public static SharedPreferences.Editor mockEditor() {
        SharedPreferences.Editor editor = (SharedPreferences.Editor)Mockito.mock(SharedPreferences.Editor.class);
        Mockito.when((Object)editor.putBoolean(Matchers.anyString(), Matchers.anyBoolean())).thenReturn((Object)editor);
        Mockito.when((Object)editor.putInt(Matchers.anyString(), Matchers.anyInt())).thenReturn((Object)editor);
        Mockito.when((Object)editor.putLong(Matchers.anyString(), Matchers.anyLong())).thenReturn((Object)editor);
        Mockito.when((Object)editor.putString(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)editor);
        Mockito.when((Object)editor.putStringSet(Matchers.anyString(), Matchers.anySetOf(String.class))).thenReturn((Object)editor);
        return editor;
    }

    public static AlertDialog.Builder mockDialogBuilder() {
        AlertDialog.Builder builder = (AlertDialog.Builder)Mockito.mock(AlertDialog.Builder.class);
        Mockito.when((Object)builder.setTitle(Matchers.anyInt())).thenReturn((Object)builder);
        Mockito.when((Object)builder.setTitle((CharSequence)Matchers.anyString())).thenReturn((Object)builder);
        Mockito.when((Object)builder.setMessage(Matchers.anyInt())).thenReturn((Object)builder);
        Mockito.when((Object)builder.setMessage((CharSequence)Matchers.anyString())).thenReturn((Object)builder);
        Mockito.when((Object)builder.setPositiveButton(Matchers.anyInt(), (DialogInterface.OnClickListener)Matchers.any(DialogInterface.OnClickListener.class))).thenReturn((Object)builder);
        Mockito.when((Object)builder.setPositiveButton((CharSequence)Matchers.anyString(), (DialogInterface.OnClickListener)Matchers.any(DialogInterface.OnClickListener.class))).thenReturn((Object)builder);
        Mockito.when((Object)builder.setNegativeButton(Matchers.anyInt(), (DialogInterface.OnClickListener)Matchers.any(DialogInterface.OnClickListener.class))).thenReturn((Object)builder);
        Mockito.when((Object)builder.setNegativeButton((CharSequence)Matchers.anyString(), (DialogInterface.OnClickListener)Matchers.any(DialogInterface.OnClickListener.class))).thenReturn((Object)builder);
        return builder;
    }

    public static AlertDialog.Builder mockDialogBuilder(ArgumentCaptor<DialogInterface.OnClickListener> positive, ArgumentCaptor<DialogInterface.OnClickListener> negative) {
        AlertDialog.Builder builder = (AlertDialog.Builder)Mockito.mock(AlertDialog.Builder.class);
        Mockito.when((Object)builder.setTitle(Matchers.anyInt())).thenReturn((Object)builder);
        Mockito.when((Object)builder.setTitle((CharSequence)Matchers.anyString())).thenReturn((Object)builder);
        Mockito.when((Object)builder.setMessage(Matchers.anyInt())).thenReturn((Object)builder);
        Mockito.when((Object)builder.setMessage((CharSequence)Matchers.anyString())).thenReturn((Object)builder);
        Mockito.when((Object)builder.setPositiveButton(Matchers.anyInt(), (DialogInterface.OnClickListener)positive.capture())).thenReturn((Object)builder);
        Mockito.when((Object)builder.setNegativeButton(Matchers.anyInt(), (DialogInterface.OnClickListener)negative.capture())).thenReturn((Object)builder);
        return builder;
    }
}

