/*
 * Decompiled with CFR 0.152.
 */
package de.jodamob.android.logging;

import de.jodamob.android.logging.Logging;
import de.jodamob.android.logging.RedirectedLogging;

public class UncaughtExceptionLogger
extends RedirectedLogging {
    private final Logging redirectLog;

    public UncaughtExceptionLogger(Logging redirectLog) {
        super(redirectLog);
        this.redirectLog = redirectLog;
        this.registerAsExceptionHandler();
    }

    private void registerAsExceptionHandler() {
        Thread.UncaughtExceptionHandler hdl = Thread.getDefaultUncaughtExceptionHandler();
        if (!(hdl instanceof HandlerImplementation)) {
            Thread.setDefaultUncaughtExceptionHandler(new HandlerImplementation(hdl, this.redirectLog));
        }
    }

    private static class HandlerImplementation
    implements Thread.UncaughtExceptionHandler {
        private Thread.UncaughtExceptionHandler handler;
        private Logging log;

        public HandlerImplementation(Thread.UncaughtExceptionHandler hdl, Logging log) {
            this.handler = hdl;
            this.log = log;
        }

        @Override
        public void uncaughtException(Thread thread, Throwable ex) {
            this.log.e("unexpected error", ex);
            this.handler.uncaughtException(thread, ex);
        }
    }
}

