/*
 * Decompiled with CFR 0.152.
 */
package de.jodamob.android.logging;

import android.content.Context;
import de.jodamob.android.logging.Log;
import de.jodamob.android.logging.SimpleFileHandler;
import java.io.File;
import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

class FileLoggerPreparation {
    private final Context context;

    FileLoggerPreparation(Context context) {
        this.context = context;
    }

    final void prepare(Logger logger) {
        this.prepare(logger, this.getLogDir(), "applog", ".log");
    }

    private File getLogDir() {
        return new File(this.context.getExternalCacheDir(), "logs");
    }

    private void prepare(Logger logger, File logFolder, String logpattern, String logExtention) {
        this.removeExistingHandlers(logger);
        this.enableFileLogger(logger, logFolder, logpattern, logExtention);
    }

    private void enableFileLogger(Logger logger, File logFolder, String logpattern, String logExtention) {
        try {
            this.setLoggerToFile(logger, logFolder, logpattern, logExtention);
        }
        catch (IOException e) {
            Log.wtf("LOG", e);
        }
    }

    private void removeExistingHandlers(Logger logger) {
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
        }
    }

    private void setLoggerToFile(Logger logger, File logFolder, String logpattern, String logExtention) throws IOException {
        this.createLogFolder(logFolder);
        this.createLogHandler(logger, logFolder, logpattern, logExtention);
    }

    private void createLogHandler(Logger logger, File logFolder, String logpattern, String logExtention) throws IOException {
        logger.addHandler(new SimpleFileHandler(logFolder, logpattern, logExtention));
        logger.setLevel(Level.INFO);
    }

    private void createLogFolder(File logFolder) {
        logFolder.mkdirs();
    }
}

