/*
 * Decompiled with CFR 0.152.
 */
package de.jodamob.android.logging;

import android.content.Context;
import de.jodamob.android.logging.FileLoggerCollector;
import de.jodamob.android.logging.FileLoggerPreparation;
import de.jodamob.android.logging.Log;
import de.jodamob.android.logging.Logging;
import de.jodamob.android.logging.RedirectedLogging;
import de.jodamob.android.logging.SilentLogger;
import java.io.File;
import java.util.logging.Logger;

public class FileLogger
extends RedirectedLogging {
    static final String FOLDER_NAME = "logs";
    static final String FILE_PATTERN = "applog";
    static final String FILE_EXTENSION = ".log";
    private final FileLoggerPreparation fileCreator;
    private final Logger logger = Logger.getLogger("");

    public FileLogger(Context context) {
        this(context, new SilentLogger());
    }

    public static File getLogFileContent(Context context) {
        return new FileLoggerCollector(context).getAsSingleLogfile();
    }

    public FileLogger(Context context, Logging redirectLog) {
        super(redirectLog);
        this.fileCreator = new FileLoggerPreparation(context);
        this.prepareInBackground();
    }

    @Override
    public int i(String tag, String message) {
        this.logger.info(message);
        return super.i(tag, message);
    }

    @Override
    public int i(String tag, String message, Throwable tr) {
        this.logger.info(message + Log.getStackTraceString(tr));
        return super.i(tag, message, tr);
    }

    @Override
    public int w(String tag, String message) {
        this.logger.warning(message);
        return super.w(tag, message);
    }

    @Override
    public int w(String tag, String message, Throwable tr) {
        this.logger.warning(message + Log.getStackTraceString(tr));
        return super.w(tag, message, tr);
    }

    @Override
    public int w(String tag, Throwable tr) {
        this.logger.warning(tag + Log.getStackTraceString(tr));
        return super.w(tag, tr);
    }

    @Override
    public int e(String tag, String message) {
        this.logger.severe(message);
        return super.e(tag, message);
    }

    @Override
    public int e(String tag, String message, Throwable tr) {
        this.logger.severe(message + this.getStackTraceString(tr));
        return super.e(tag, message, tr);
    }

    @Override
    public int e(String message) {
        this.logger.severe(message);
        return super.e(message);
    }

    @Override
    public int e(String msg, Throwable tr) {
        this.logger.severe(msg + this.getStackTraceString(tr));
        return super.e(msg, tr);
    }

    @Override
    public int wtf(String tag, String message, Throwable tr) {
        this.logger.severe(message + this.getStackTraceString(tr));
        return super.wtf(tag, message, tr);
    }

    @Override
    public int wtf(String tag, Throwable tr) {
        this.logger.severe(tag + this.getStackTraceString(tr));
        return super.wtf(tag, tr);
    }

    @Override
    public int wtf(String tag, String message) {
        this.logger.severe(message);
        return super.wtf(tag, message);
    }

    @Override
    public int wtf(Throwable tr) {
        this.logger.severe(this.getStackTraceString(tr));
        return super.wtf(tr);
    }

    @Override
    public String getStackTraceString(Throwable tr) {
        return android.util.Log.getStackTraceString((Throwable)tr);
    }

    private void prepareInBackground() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                FileLogger.this.fileCreator.prepare(FileLogger.this.logger);
            }
        }).start();
    }
}

