/*
 * Decompiled with CFR 0.152.
 */
package de.jodamob.android.tracing;

import de.jodamob.android.logging.Log;
import de.jodamob.android.tracing.Tracer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import retrofit.client.Client;
import retrofit.client.Header;
import retrofit.client.Request;
import retrofit.client.Response;
import retrofit.mime.MimeUtil;
import retrofit.mime.TypedByteArray;
import retrofit.mime.TypedInput;

public class TracedRetrofitClient
implements Client {
    private static final int BUFFER_SIZE = 4096;
    private static final long MAX_BODY_TO_LOG_SIZE = 20000L;
    private final Client client;
    private final Tracer tracer;

    public TracedRetrofitClient(Client client, Tracer tracer) {
        this.client = client;
        this.tracer = tracer;
    }

    public Response execute(Request request) throws IOException {
        long startTime = this.getTime();
        try {
            return this.executeTraced(request, startTime);
        }
        catch (IOException e) {
            this.trace(request, e, startTime, this.getTime());
            throw e;
        }
    }

    private Response executeTraced(Request request, long startTime) throws IOException {
        Response response = this.client.execute(request);
        this.trace(request, response, startTime);
        return response;
    }

    private void trace(Request request, IOException e, long startTime, long endTime) {
        this.tracer.trace(request.getUrl(), startTime, endTime, e);
    }

    private void trace(Request request, Response response, long startTime) throws IOException {
        long bytesReceived = this.getBytesReceived(response);
        int status = this.getStatus(response);
        if (status >= 400) {
            this.tracer.trace(request.getUrl(), status, startTime, this.getTime(), 0L, bytesReceived, TracedRetrofitClient.getBodyString(response));
        } else {
            this.tracer.trace(request.getUrl(), status, startTime, this.getTime(), 0L, bytesReceived);
        }
    }

    private int getStatus(Response response) {
        return response != null ? response.getStatus() : -1;
    }

    private long getBytesReceived(Response response) {
        return response != null ? this.getResponseSize(response.getHeaders()) : 0L;
    }

    private long getResponseSize(List<Header> headers) {
        for (Header header : headers) {
            if (!this.isContentLength(header.getName())) continue;
            return Long.parseLong(header.getValue());
        }
        return 0L;
    }

    private boolean isContentLength(String name) {
        return "Content-Length".equalsIgnoreCase(name);
    }

    private long getTime() {
        return System.currentTimeMillis();
    }

    private static String getBodyString(Response response) throws IOException {
        try {
            TypedInput body = response.getBody();
            if (body != null && body.length() < 20000L) {
                return TracedRetrofitClient.convertToString(response, body);
            }
        }
        catch (Exception e) {
            Log.wtf((Throwable)e);
        }
        return "";
    }

    private static String convertToString(Response response, TypedInput body) throws IOException {
        if (!(body instanceof TypedByteArray)) {
            return TracedRetrofitClient.convertToString(TracedRetrofitClient.readBodyToBytesIfNecessary(response).getBody());
        }
        return TracedRetrofitClient.convertToString(body);
    }

    private static String convertToString(TypedInput body) throws UnsupportedEncodingException {
        byte[] bodyBytes = ((TypedByteArray)body).getBytes();
        return new String(bodyBytes, MimeUtil.parseCharset((String)body.mimeType()));
    }

    private static Response readBodyToBytesIfNecessary(Response response) throws IOException {
        TypedInput body = response.getBody();
        if (body == null || body instanceof TypedByteArray) {
            return response;
        }
        return TracedRetrofitClient.replaceResponseBody(response, (TypedInput)new TypedByteArray(body.mimeType(), TracedRetrofitClient.stream(body.in())));
    }

    private static Response replaceResponseBody(Response response, TypedInput body) {
        return new Response(response.getStatus(), response.getReason(), response.getHeaders(), body);
    }

    private static byte[] stream(InputStream stream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (stream != null) {
            TracedRetrofitClient.stream(stream, outputStream);
        }
        return outputStream.toByteArray();
    }

    private static void stream(InputStream stream, ByteArrayOutputStream outputStream) throws IOException {
        int r;
        byte[] buf = new byte[4096];
        while ((r = stream.read(buf)) != -1) {
            outputStream.write(buf, 0, r);
        }
    }
}

