/*
 * Decompiled with CFR 0.152.
 */
package de.jodamob.android.logging;

import com.newrelic.agent.android.NewRelic;
import de.jodamob.android.logging.Logging;
import de.jodamob.android.logging.RemoteReporter;
import de.jodamob.android.logging.RemoteToolLogger;
import de.jodamob.android.logging.SilentLogger;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;

public class NewRelicLogger
extends RemoteToolLogger {
    public NewRelicLogger() {
        this((Logging)new SilentLogger());
    }

    public NewRelicLogger(Logging redirectLogger) {
        super((RemoteReporter)new NewRelicReporter(), redirectLogger);
    }

    private static final class NewRelicReporter
    implements RemoteReporter {
        private NewRelicReporter() {
        }

        public void reportLoggedException(String message, Throwable tr) {
            long time = new Date().getTime();
            try {
                if (message.isEmpty()) {
                    message = "none";
                }
                NewRelic.noticeNetworkFailure((String)("http://" + URLEncoder.encode(message, "utf-8")), (long)time, (long)time, (Exception)new Exception(tr));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }

        public void reportWtfException(Throwable tr) {
            long time = new Date().getTime();
            NewRelic.noticeNetworkFailure((String)"http://WTF", (long)time, (long)time, (Exception)new Exception(tr));
        }

        public void reportWtfException(String message, Throwable tr) {
            long time = new Date().getTime();
            NewRelic.noticeNetworkFailure((String)"http://WTF", (long)time, (long)time, (Exception)new Exception(message, tr));
        }
    }
}

