/*
 * Decompiled with CFR 0.152.
 */
package de.jodamob.android.autolayout;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.preference.PreferenceFragment;
import de.jodamob.android.autolayout.DynamicResourceLoader;
import java.util.ArrayList;
import java.util.Collections;

public class NameConverter {
    @TargetApi(value=11)
    public static int convertToResourceMenuId(Fragment fragment) {
        return DynamicResourceLoader.getStringResourceByName("menu", fragment.getActivity().getPackageName(), fragment.getResources(), NameConverter.convertToResourceName(fragment));
    }

    @TargetApi(value=11)
    public static int convertToResourceLayoutId(Fragment fragment) {
        return DynamicResourceLoader.getStringResourceByName("layout", fragment.getActivity().getPackageName(), fragment.getResources(), NameConverter.convertToResourceName(fragment));
    }

    @TargetApi(value=11)
    public static int convertToResourceXmlId(PreferenceFragment fragment) {
        return DynamicResourceLoader.getStringResourceByName("xml", fragment.getActivity().getPackageName(), fragment.getResources(), NameConverter.convertToResourceName(fragment));
    }

    public static int convertToResourceLayoutId(Activity activity) {
        return DynamicResourceLoader.getStringResourceByName("layout", activity.getPackageName(), activity.getResources(), NameConverter.convertToResourceName(activity));
    }

    public static int convertToResourceMenuId(Activity activity) {
        return DynamicResourceLoader.getStringResourceByName("menu", activity.getPackageName(), activity.getResources(), NameConverter.convertToResourceName(activity));
    }

    static String[] convertToResourceName(Object object) {
        String pureClassname = NameConverter.getPureClassname(object);
        return NameConverter.asVariants(NameConverter.asLayoutNameCharacters(pureClassname));
    }

    private static String[] asVariants(String name) {
        String[] parts = name.split("_");
        ArrayList<String> fullnames = new ArrayList<String>(parts.length);
        for (String part : parts) {
            fullnames.add((fullnames.isEmpty() ? "" : (String)fullnames.get(fullnames.size() - 1) + "_") + part);
        }
        Collections.reverse(fullnames);
        return fullnames.toArray(new String[fullnames.size()]);
    }

    private static String getPureClassname(Object object) {
        String name = object.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    private static String asLayoutNameCharacters(String name) {
        String res = "" + Character.toLowerCase(name.charAt(0));
        for (int i = 1; i < name.length(); ++i) {
            res = res + NameConverter.asLayoutNameCharacter(name, res, i);
        }
        return res;
    }

    private static String asLayoutNameCharacter(String name, String res, int i) {
        Character ch = Character.valueOf(name.charAt(i));
        if (Character.isUpperCase(ch.charValue()) && i > 0) {
            return "_" + Character.toLowerCase(ch.charValue());
        }
        return "" + ch;
    }
}

