/*
 * Decompiled with CFR 0.152.
 */
package de.jodamob.android.tracing;

import android.content.Context;
import android.net.Uri;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.OkHttpDownloader;
import com.squareup.picasso.UrlConnectionDownloader;
import de.jodamob.android.tracing.Tracer;
import java.io.IOException;

@Deprecated
public class TracedPicassoDownloader
implements Downloader {
    private final Downloader downloader;
    private final Tracer tracer;

    public TracedPicassoDownloader(Tracer tracer, Context context) {
        this(tracer, TracedPicassoDownloader.createDefaultDownloader(context));
    }

    public TracedPicassoDownloader(Tracer tracer, Downloader downloader) {
        this.tracer = tracer;
        this.downloader = downloader;
    }

    public Downloader.Response load(Uri uri, boolean localCacheOnly) throws IOException {
        long startTime = this.getTime();
        try {
            return this.executeTraced(uri, localCacheOnly, startTime);
        }
        catch (IOException e) {
            this.traceException(uri, e, startTime);
            throw e;
        }
    }

    private void traceException(Uri uri, IOException e, long startTime) {
        if (this.isResponseException(e)) {
            try {
                this.traceStatus(uri, e, startTime);
                return;
            }
            catch (Exception parseError) {
                parseError.printStackTrace();
            }
        }
        this.trace(uri, e, startTime, this.getTime());
    }

    private void traceStatus(Uri uri, IOException e, long startTime) throws IOException {
        int status = Integer.parseInt(e.getMessage().substring(0, 3));
        this.trace(uri, status, startTime);
    }

    private boolean isResponseException(IOException e) {
        return e.getClass().getName().endsWith("ResponseException");
    }

    private void trace(Uri uri, IOException e, long startTime, long endTime) {
        this.tracer.trace(uri.toString(), startTime, endTime, e);
    }

    private void trace(Uri uri, int statusCode, long startTime) throws IOException {
        this.tracer.trace(uri.toString(), statusCode, startTime, this.getTime(), 0L, 0L);
    }

    private Downloader.Response executeTraced(Uri uri, boolean localCacheOnly, long startTime) throws IOException {
        Downloader.Response response = this.downloader.load(uri, localCacheOnly);
        this.trace(uri, response == null ? 400 : 200, startTime);
        return response;
    }

    private static Downloader createDefaultDownloader(Context context) {
        try {
            Class.forName("com.squareup.okhttp.OkHttpClient");
            return OkHttpLoaderCreator.create(context);
        }
        catch (ClassNotFoundException e) {
            return new UrlConnectionDownloader(context);
        }
    }

    private long getTime() {
        return System.currentTimeMillis();
    }

    private static class OkHttpLoaderCreator {
        private OkHttpLoaderCreator() {
        }

        static Downloader create(Context context) {
            return new OkHttpDownloader(context);
        }
    }
}

