/*
 * Decompiled with CFR 0.152.
 */
package de.jodamob.android.logging;

import de.jodamob.android.logging.Logging;

public class UncaughtExceptionLogger
implements Logging {
    private final Logging redirectLog;

    public UncaughtExceptionLogger(Logging redirectLog) {
        this.redirectLog = redirectLog;
        this.registerAsExceptionHandler();
    }

    @Override
    public int v(String tag, String message) {
        return this.redirectLog.v(tag, message);
    }

    @Override
    public int v(String tag, String message, Throwable tr) {
        return this.redirectLog.v(tag, message, tr);
    }

    @Override
    public int d(String tag, String message) {
        return this.redirectLog.d(tag, message);
    }

    @Override
    public int d(String tag, String message, Throwable tr) {
        return this.redirectLog.d(tag, message, tr);
    }

    @Override
    public int i(String tag, String message) {
        return this.redirectLog.i(tag, message);
    }

    @Override
    public int i(String tag, String message, Throwable tr) {
        return this.redirectLog.i(tag, message, tr);
    }

    @Override
    public int w(String tag, String message) {
        return this.redirectLog.w(tag, message);
    }

    @Override
    public int w(String tag, String message, Throwable tr) {
        return this.redirectLog.w(tag, message, tr);
    }

    @Override
    public int w(String tag, Throwable tr) {
        return this.redirectLog.w(tag, tr);
    }

    @Override
    public int e(String tag, String message) {
        return this.redirectLog.e(tag, message);
    }

    @Override
    public int e(String tag, String message, Throwable tr) {
        return this.redirectLog.e(tag, message, tr);
    }

    @Override
    public int e(String message) {
        return this.redirectLog.e(message);
    }

    @Override
    public int e(String msg, Throwable tr) {
        return this.redirectLog.e(msg, tr);
    }

    @Override
    public int wtf(String tag, String message, Throwable tr) {
        return this.redirectLog.wtf(tag, message, tr);
    }

    @Override
    public int wtf(String tag, Throwable tr) {
        return this.redirectLog.wtf(tag, tr);
    }

    @Override
    public int wtf(String tag, String message) {
        return this.redirectLog.wtf(tag, message);
    }

    @Override
    public int wtf(Throwable tr) {
        return this.redirectLog.wtf(tr);
    }

    @Override
    public String getStackTraceString(Throwable tr) {
        return this.redirectLog.getStackTraceString(tr);
    }

    private void registerAsExceptionHandler() {
        Thread.UncaughtExceptionHandler hdl = Thread.getDefaultUncaughtExceptionHandler();
        if (!(hdl instanceof HandlerImplementation)) {
            Thread.setDefaultUncaughtExceptionHandler(new HandlerImplementation(hdl, this.redirectLog));
        }
    }

    private static class HandlerImplementation
    implements Thread.UncaughtExceptionHandler {
        private Thread.UncaughtExceptionHandler handler;
        private Logging log;

        public HandlerImplementation(Thread.UncaughtExceptionHandler hdl, Logging log) {
            this.handler = hdl;
            this.log = log;
        }

        @Override
        public void uncaughtException(Thread thread, Throwable ex) {
            this.log.e("unexpected error", ex);
            this.handler.uncaughtException(thread, ex);
        }
    }
}

