/*
 * Decompiled with CFR 0.152.
 */
package de.jodamob.android.logging;

import de.jodamob.android.logging.Logging;
import de.jodamob.android.logging.RemoteReporter;
import de.jodamob.android.logging.SilentLogger;

public class RemoteToolLogger
implements Logging {
    private final Logging redirectLog;
    private final RemoteReporter exceptionReporter;

    public RemoteToolLogger(RemoteReporter reporter) {
        this(reporter, new SilentLogger());
    }

    public RemoteToolLogger(RemoteReporter reporter, Logging redirectLog) {
        this.exceptionReporter = reporter;
        this.redirectLog = redirectLog;
    }

    @Override
    public int v(String tag, String message) {
        return this.redirectLog.v(tag, message);
    }

    @Override
    public int v(String tag, String message, Throwable tr) {
        this.exceptionReporter.reportLoggedException(message, tr);
        return this.redirectLog.v(tag, message, tr);
    }

    @Override
    public int d(String tag, String message) {
        return this.redirectLog.d(tag, message);
    }

    @Override
    public int d(String tag, String message, Throwable tr) {
        this.exceptionReporter.reportLoggedException(message, tr);
        return this.redirectLog.d(tag, message, tr);
    }

    @Override
    public int i(String tag, String message) {
        return this.redirectLog.i(tag, message);
    }

    @Override
    public int i(String tag, String message, Throwable tr) {
        this.exceptionReporter.reportLoggedException(message, tr);
        return this.redirectLog.i(tag, message, tr);
    }

    @Override
    public int w(String tag, String message) {
        return this.redirectLog.w(tag, message);
    }

    @Override
    public int w(String tag, String message, Throwable tr) {
        this.exceptionReporter.reportLoggedException(message, tr);
        return this.redirectLog.w(tag, message, tr);
    }

    @Override
    public int w(String tag, Throwable tr) {
        return this.redirectLog.w(tag, tr);
    }

    @Override
    public int e(String tag, String message) {
        return this.redirectLog.e(tag, message);
    }

    @Override
    public int e(String tag, String message, Throwable tr) {
        this.exceptionReporter.reportLoggedException(message, tr);
        return this.redirectLog.e(tag, message, tr);
    }

    @Override
    public int e(String message) {
        return this.redirectLog.e(message);
    }

    @Override
    public int e(String msg, Throwable tr) {
        this.exceptionReporter.reportLoggedException(msg, tr);
        return this.redirectLog.e(msg, tr);
    }

    @Override
    public int wtf(String tag, String message, Throwable tr) {
        this.exceptionReporter.reportWtfException(tr);
        return this.redirectLog.wtf(tag, message, tr);
    }

    @Override
    public int wtf(String tag, Throwable tr) {
        this.exceptionReporter.reportWtfException(tr);
        return this.redirectLog.wtf(tag, tr);
    }

    @Override
    public int wtf(String tag, String message) {
        return this.redirectLog.wtf(tag, message);
    }

    @Override
    public int wtf(Throwable tr) {
        this.exceptionReporter.reportWtfException(tr);
        return this.redirectLog.wtf(tr);
    }

    @Override
    public String getStackTraceString(Throwable tr) {
        return this.redirectLog.getStackTraceString(tr);
    }
}

