/*
 * Decompiled with CFR 0.152.
 */
package de.jodamob.android.logging;

import android.content.Context;
import de.jodamob.android.logging.FileLoggerCollector;
import de.jodamob.android.logging.FileLoggerPreparation;
import de.jodamob.android.logging.Log;
import de.jodamob.android.logging.Logging;
import de.jodamob.android.logging.SilentLogger;
import java.io.File;
import java.util.logging.Logger;

public class FileLogger
implements Logging {
    static final String FOLDER_NAME = "logs";
    static final String FILE_PATTERN = "applog";
    static final String FILE_EXTENSION = ".log";
    private final Logging redirectLog;
    private final FileLoggerPreparation fileCreator;
    private final Logger logger = Logger.getLogger("");

    public FileLogger(Context context) {
        this(context, new SilentLogger());
    }

    public static File getLogFileContent(Context context) {
        return new FileLoggerCollector(context).getAsSingleLogfile();
    }

    public FileLogger(Context context, Logging redirectLog) {
        this.fileCreator = new FileLoggerPreparation(context);
        this.redirectLog = redirectLog;
        this.prepareInBackground();
    }

    @Override
    public int v(String tag, String message) {
        return this.redirectLog.v(tag, message);
    }

    @Override
    public int v(String tag, String message, Throwable tr) {
        return this.redirectLog.v(tag, message, tr);
    }

    @Override
    public int d(String tag, String message) {
        return this.redirectLog.d(tag, message);
    }

    @Override
    public int d(String tag, String message, Throwable tr) {
        return this.redirectLog.d(tag, message, tr);
    }

    @Override
    public int i(String tag, String message) {
        this.logger.info(message);
        return this.redirectLog.i(tag, message);
    }

    @Override
    public int i(String tag, String message, Throwable tr) {
        this.logger.info(message + Log.getStackTraceString(tr));
        return this.redirectLog.i(tag, message, tr);
    }

    @Override
    public int w(String tag, String message) {
        this.logger.warning(message);
        return this.redirectLog.w(tag, message);
    }

    @Override
    public int w(String tag, String message, Throwable tr) {
        this.logger.warning(message + Log.getStackTraceString(tr));
        return this.redirectLog.w(tag, message, tr);
    }

    @Override
    public int w(String tag, Throwable tr) {
        this.logger.warning(tag + Log.getStackTraceString(tr));
        return this.redirectLog.w(tag, tr);
    }

    @Override
    public int e(String tag, String message) {
        this.logger.severe(message);
        return this.redirectLog.e(tag, message);
    }

    @Override
    public int e(String tag, String message, Throwable tr) {
        this.logger.severe(message + this.getStackTraceString(tr));
        return this.redirectLog.e(tag, message, tr);
    }

    @Override
    public int e(String message) {
        this.logger.severe(message);
        return this.redirectLog.e(message);
    }

    @Override
    public int e(String msg, Throwable tr) {
        this.logger.severe(msg + this.getStackTraceString(tr));
        return this.redirectLog.e(msg, tr);
    }

    @Override
    public int wtf(String tag, String message, Throwable tr) {
        this.logger.severe(message + this.getStackTraceString(tr));
        return this.redirectLog.wtf(tag, message, tr);
    }

    @Override
    public int wtf(String tag, Throwable tr) {
        this.logger.severe(tag + this.getStackTraceString(tr));
        return this.redirectLog.wtf(tag, tr);
    }

    @Override
    public int wtf(String tag, String message) {
        this.logger.severe(message);
        return this.redirectLog.wtf(tag, message);
    }

    @Override
    public int wtf(Throwable tr) {
        this.logger.severe(this.getStackTraceString(tr));
        return this.redirectLog.wtf(tr);
    }

    @Override
    public String getStackTraceString(Throwable tr) {
        return android.util.Log.getStackTraceString((Throwable)tr);
    }

    private void prepareInBackground() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                FileLogger.this.fileCreator.prepare(FileLogger.this.logger);
            }
        }).start();
    }
}

