/*
 * Decompiled with CFR 0.152.
 */
package de.jodamob.android.tracing;

import de.jodamob.android.tracing.Tracer;
import retrofit.Profiler;

public class TracedRetrofitProfiler
implements Profiler<Long> {
    private final Tracer tracer;

    public TracedRetrofitProfiler(Tracer tracer) {
        this.tracer = tracer;
    }

    private long getTime() {
        return System.currentTimeMillis();
    }

    public Long beforeCall() {
        return this.getTime();
    }

    public void afterCall(Profiler.RequestInformation requestInfo, long elapsedTime, int statusCode, Long beforeCallData) {
        this.tracer.trace(this.getUrl(requestInfo), statusCode, beforeCallData, beforeCallData + elapsedTime, requestInfo.getContentLength(), 0L);
    }

    private String getUrl(Profiler.RequestInformation requestInfo) {
        String baseUrl = requestInfo.getBaseUrl();
        String relativePath = requestInfo.getRelativePath();
        if (baseUrl.endsWith("/") || relativePath.startsWith("/")) {
            return baseUrl + relativePath;
        }
        return baseUrl + "/" + relativePath;
    }
}

