/*
 * Decompiled with CFR 0.152.
 */
package de.jodamob.android.tracing;

import de.jodamob.android.tracing.Tracer;
import java.io.IOException;
import java.util.List;
import retrofit.client.Client;
import retrofit.client.Header;
import retrofit.client.Request;
import retrofit.client.Response;

@Deprecated
public class TracedRetrofitClient
implements Client {
    private final Client client;
    private final Tracer tracer;

    public TracedRetrofitClient(Client client, Tracer tracer) {
        this.client = client;
        this.tracer = tracer;
    }

    public Response execute(Request request) throws IOException {
        long startTime = this.getTime();
        try {
            return this.executeTraced(request, startTime);
        }
        catch (IOException e) {
            this.trace(request, e, startTime, this.getTime());
            throw e;
        }
    }

    private Response executeTraced(Request request, long startTime) throws IOException {
        Response response = this.client.execute(request);
        this.trace(request, response, startTime);
        return response;
    }

    private void trace(Request request, IOException e, long startTime, long endTime) {
        this.tracer.trace(request.getUrl(), startTime, endTime, e);
    }

    private void trace(Request request, Response response, long startTime) throws IOException {
        long bytesReceived = this.getBytesReceived(response);
        this.tracer.trace(request.getUrl(), this.getStatus(response), startTime, this.getTime(), 0L, bytesReceived);
    }

    private int getStatus(Response response) {
        return response != null ? response.getStatus() : -1;
    }

    private long getBytesReceived(Response response) {
        return response != null ? this.getResponseSize(response.getHeaders()) : 0L;
    }

    private long getResponseSize(List<Header> headers) {
        for (Header header : headers) {
            if (!this.isContentLenght(header.getName())) continue;
            return Long.parseLong(header.getValue());
        }
        return 0L;
    }

    private boolean isContentLenght(String name) {
        return "Content-Length".equalsIgnoreCase(name);
    }

    private long getTime() {
        return System.currentTimeMillis();
    }
}

