/*
 * Decompiled with CFR 0.152.
 */
package de.jodamob.android.logging;

import android.content.Context;
import de.jodamob.android.utils.Closeables;
import de.jodamob.android.utils.StreamUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class FileLoggerCollector {
    private static final String ACCUMMULATED_LOG = "logscollected.txt";
    private final Context context;

    FileLoggerCollector(Context context) {
        this.context = context;
    }

    final File getAsSingleLogfile() {
        return this.getAsSingleLogfile(this.getLogDir());
    }

    private final File getAsSingleLogfile(File logDir) {
        File newFile = new File(logDir, ACCUMMULATED_LOG);
        this.getAsSingleLogfile(logDir, newFile);
        return newFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void getAsSingleLogfile(File logDir, File newFile) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(newFile);
            this.writeFilesToStream(logDir, out);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(out);
                throw throwable;
            }
            Closeables.closeQuietly(out);
        }
        Closeables.closeQuietly(out);
    }

    private void writeFilesToStream(File dir, OutputStream out) throws IOException {
        this.writeFileToStream(dir.listFiles(new LogFileFilter()), out);
    }

    private void writeFileToStream(File[] files, OutputStream out) throws FileNotFoundException, IOException {
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (file.length() == 0L) continue;
                this.copyInto(out, file);
            }
        }
    }

    private File getLogDir() {
        return new File(this.context.getExternalCacheDir(), "logs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyInto(OutputStream out, File file) throws FileNotFoundException, IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            StreamUtils.copy(in, out);
        }
        finally {
            Closeables.closeQuietly(in);
        }
    }

    private static final class LogFileFilter
    implements FileFilter {
        private LogFileFilter() {
        }

        @Override
        public boolean accept(File path) {
            if (path.isDirectory()) {
                return false;
            }
            String name = path.getName();
            return name.startsWith("applog") && name.endsWith(".log");
        }
    }
}

