/*
 * Decompiled with CFR 0.152.
 */
package de.jodamob.android.autolayout;

import android.app.Activity;
import android.app.Fragment;
import android.preference.PreferenceFragment;
import de.jodamob.android.autolayout.DynamicResourceLoader;
import de.jodamob.android.autolayout.InjectLayout;
import java.util.ArrayList;
import java.util.Collections;

public class NameConverter {
    public static int convertToResourceMenuId(Fragment fragment) {
        return DynamicResourceLoader.getStringResourceByName("menu", fragment.getActivity().getPackageName(), fragment.getResources(), NameConverter.convertToResourceName(fragment));
    }

    public static int convertToResourceLayoutId(Fragment fragment) {
        Class<?> aClass = fragment.getClass();
        if (aClass.isAnnotationPresent(InjectLayout.class)) {
            return aClass.getAnnotation(InjectLayout.class).value();
        }
        return DynamicResourceLoader.getStringResourceByName("layout", fragment.getActivity().getPackageName(), fragment.getResources(), NameConverter.convertToResourceName(fragment));
    }

    public static int convertToResourceXmlId(PreferenceFragment fragment) {
        return DynamicResourceLoader.getStringResourceByName("xml", fragment.getActivity().getPackageName(), fragment.getResources(), NameConverter.convertToResourceName(fragment));
    }

    public static int convertToResourceLayoutId(Activity activity) {
        Class<?> aClass = activity.getClass();
        if (aClass.isAnnotationPresent(InjectLayout.class)) {
            return aClass.getAnnotation(InjectLayout.class).value();
        }
        return DynamicResourceLoader.getStringResourceByName("layout", activity.getPackageName(), activity.getResources(), NameConverter.convertToResourceName(activity));
    }

    public static int convertToResourceMenuId(Activity activity) {
        return DynamicResourceLoader.getStringResourceByName("menu", activity.getPackageName(), activity.getResources(), NameConverter.convertToResourceName(activity));
    }

    static String[] convertToResourceName(Object object) {
        String pureClassname = NameConverter.getPureClassname(object);
        return NameConverter.asVariants(NameConverter.asLayoutNameCharacters(pureClassname));
    }

    private static String[] asVariants(String name) {
        String[] parts = name.split("_");
        ArrayList<String> fullnames = new ArrayList<String>(parts.length);
        for (String part : parts) {
            fullnames.add((fullnames.isEmpty() ? "" : (String)fullnames.get(fullnames.size() - 1) + "_") + part);
        }
        Collections.reverse(fullnames);
        return fullnames.toArray(new String[fullnames.size()]);
    }

    private static String getPureClassname(Object object) {
        String name = object.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    private static String asLayoutNameCharacters(String name) {
        return NameConverter.asLayoutNameCharacters(name, new StringBuilder(name.length() * 1 / 3)).toString();
    }

    private static StringBuilder asLayoutNameCharacters(String name, StringBuilder res) {
        return NameConverter.asLayoutNameCharacters(name.toCharArray(), res);
    }

    private static StringBuilder asLayoutNameCharacters(char[] name, StringBuilder res) {
        res.append(Character.toLowerCase(name[0]));
        for (int i = 1; i < name.length; ++i) {
            NameConverter.addAsLayoutNameCharacter(name[i], res, i);
        }
        return res;
    }

    private static StringBuilder addAsLayoutNameCharacter(char ch, StringBuilder res, int i) {
        if (Character.isUpperCase(ch) && i > 0) {
            res.append("_");
            res.append(Character.toLowerCase(ch));
        } else {
            res.append(ch);
        }
        return res;
    }
}

