/*
 * Decompiled with CFR 0.152.
 */
package de.jnkconsulting.e3dc.easyrscp.service;

import de.jnkconsulting.e3dc.easyrscp.api.connection.ConnectionPool;
import de.jnkconsulting.e3dc.easyrscp.api.connection.HomePowerPlantConnection;
import de.jnkconsulting.e3dc.easyrscp.api.frame.Frame;
import de.jnkconsulting.e3dc.easyrscp.api.service.ChargingService;
import de.jnkconsulting.e3dc.easyrscp.api.service.model.ChargingConfiguration;
import de.jnkconsulting.e3dc.easyrscp.api.service.model.ChargingLimits;
import de.jnkconsulting.e3dc.easyrscp.api.service.model.ManualChargeState;
import de.jnkconsulting.e3dc.easyrscp.api.service.model.WriteChargingLimitsResult;
import de.jnkconsulting.e3dc.easyrscp.service.DefaultChargingService;
import de.jnkconsulting.e3dc.easyrscp.service.converter.ChargingConfigurationConverter;
import de.jnkconsulting.e3dc.easyrscp.service.converter.FrameConverter;
import de.jnkconsulting.e3dc.easyrscp.service.converter.ManualChargeStateConverter;
import de.jnkconsulting.e3dc.easyrscp.service.converter.StartManualChargeResponseConverter;
import de.jnkconsulting.e3dc.easyrscp.service.converter.WriteChargingLimitsResultConverter;
import de.jnkconsulting.e3dc.easyrscp.service.creator.FrameCreator;
import de.jnkconsulting.e3dc.easyrscp.service.creator.RequestChargingConfigurationCreator;
import de.jnkconsulting.e3dc.easyrscp.service.creator.RequestManualChargeStateCreator;
import de.jnkconsulting.e3dc.easyrscp.service.creator.RequestStartManualChargeCreator;
import de.jnkconsulting.e3dc.easyrscp.service.creator.SetPowerSettingsCreator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0091\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005\u0012\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u0012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0005\u0012\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\n\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001d\u001a\u00020\u0006H\u0016J\b\u0010\u001e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0014H\u0016J\b\u0010 \u001a\u00020\u0012H\u0016J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lde/jnkconsulting/e3dc/easyrscp/service/DefaultChargingService;", "Lde/jnkconsulting/e3dc/easyrscp/api/service/ChargingService;", "connectionPool", "Lde/jnkconsulting/e3dc/easyrscp/api/connection/ConnectionPool;", "convertFrameToChargingConfiguration", "Lde/jnkconsulting/e3dc/easyrscp/service/converter/FrameConverter;", "Lde/jnkconsulting/e3dc/easyrscp/api/service/model/ChargingConfiguration;", "convertFrameToWriteChargingLimitsResult", "Lde/jnkconsulting/e3dc/easyrscp/api/service/model/WriteChargingLimitsResult;", "createRequestChargingConfigurationFrame", "Lde/jnkconsulting/e3dc/easyrscp/service/creator/FrameCreator;", "", "createSetPowerSettingsFrame", "Lde/jnkconsulting/e3dc/easyrscp/api/service/model/ChargingLimits;", "convertFrameToManualChargeState", "Lde/jnkconsulting/e3dc/easyrscp/api/service/model/ManualChargeState;", "createRequestManualChargeState", "convertFrameToStartManualChargeResponseState", "", "createRequestStartManualCharge", "", "(Lde/jnkconsulting/e3dc/easyrscp/api/connection/ConnectionPool;Lde/jnkconsulting/e3dc/easyrscp/service/converter/FrameConverter;Lde/jnkconsulting/e3dc/easyrscp/service/converter/FrameConverter;Lde/jnkconsulting/e3dc/easyrscp/service/creator/FrameCreator;Lde/jnkconsulting/e3dc/easyrscp/service/creator/FrameCreator;Lde/jnkconsulting/e3dc/easyrscp/service/converter/FrameConverter;Lde/jnkconsulting/e3dc/easyrscp/service/creator/FrameCreator;Lde/jnkconsulting/e3dc/easyrscp/service/converter/FrameConverter;Lde/jnkconsulting/e3dc/easyrscp/service/creator/FrameCreator;)V", "logger", "Lmu/KLogger;", "executeManualCharge", "connection", "Lde/jnkconsulting/e3dc/easyrscp/api/connection/HomePowerPlantConnection;", "amountWh", "executeReadManualChargeState", "readConfiguration", "readManualChargeState", "startManualCharge", "stopManualCharge", "writeLimits", "limits", "jnk-easy-rscp-service"})
public final class DefaultChargingService
implements ChargingService {
    @NotNull
    private final ConnectionPool connectionPool;
    @NotNull
    private final FrameConverter<ChargingConfiguration> convertFrameToChargingConfiguration;
    @NotNull
    private final FrameConverter<WriteChargingLimitsResult> convertFrameToWriteChargingLimitsResult;
    @NotNull
    private final FrameCreator createRequestChargingConfigurationFrame;
    @NotNull
    private final FrameCreator<ChargingLimits> createSetPowerSettingsFrame;
    @NotNull
    private final FrameConverter<ManualChargeState> convertFrameToManualChargeState;
    @NotNull
    private final FrameCreator createRequestManualChargeState;
    @NotNull
    private final FrameConverter<Boolean> convertFrameToStartManualChargeResponseState;
    @NotNull
    private final FrameCreator<Integer> createRequestStartManualCharge;
    @NotNull
    private final KLogger logger;

    public DefaultChargingService(@NotNull ConnectionPool connectionPool, @NotNull FrameConverter<ChargingConfiguration> convertFrameToChargingConfiguration, @NotNull FrameConverter<WriteChargingLimitsResult> convertFrameToWriteChargingLimitsResult, @NotNull FrameCreator createRequestChargingConfigurationFrame, @NotNull FrameCreator<ChargingLimits> createSetPowerSettingsFrame, @NotNull FrameConverter<ManualChargeState> convertFrameToManualChargeState, @NotNull FrameCreator createRequestManualChargeState, @NotNull FrameConverter<Boolean> convertFrameToStartManualChargeResponseState, @NotNull FrameCreator<Integer> createRequestStartManualCharge) {
        Intrinsics.checkNotNullParameter((Object)connectionPool, (String)"connectionPool");
        Intrinsics.checkNotNullParameter(convertFrameToChargingConfiguration, (String)"convertFrameToChargingConfiguration");
        Intrinsics.checkNotNullParameter(convertFrameToWriteChargingLimitsResult, (String)"convertFrameToWriteChargingLimitsResult");
        Intrinsics.checkNotNullParameter((Object)createRequestChargingConfigurationFrame, (String)"createRequestChargingConfigurationFrame");
        Intrinsics.checkNotNullParameter(createSetPowerSettingsFrame, (String)"createSetPowerSettingsFrame");
        Intrinsics.checkNotNullParameter(convertFrameToManualChargeState, (String)"convertFrameToManualChargeState");
        Intrinsics.checkNotNullParameter((Object)createRequestManualChargeState, (String)"createRequestManualChargeState");
        Intrinsics.checkNotNullParameter(convertFrameToStartManualChargeResponseState, (String)"convertFrameToStartManualChargeResponseState");
        Intrinsics.checkNotNullParameter(createRequestStartManualCharge, (String)"createRequestStartManualCharge");
        this.connectionPool = connectionPool;
        this.convertFrameToChargingConfiguration = convertFrameToChargingConfiguration;
        this.convertFrameToWriteChargingLimitsResult = convertFrameToWriteChargingLimitsResult;
        this.createRequestChargingConfigurationFrame = createRequestChargingConfigurationFrame;
        this.createSetPowerSettingsFrame = createSetPowerSettingsFrame;
        this.convertFrameToManualChargeState = convertFrameToManualChargeState;
        this.createRequestManualChargeState = createRequestManualChargeState;
        this.convertFrameToStartManualChargeResponseState = convertFrameToStartManualChargeResponseState;
        this.createRequestStartManualCharge = createRequestStartManualCharge;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    }

    public /* synthetic */ DefaultChargingService(ConnectionPool connectionPool, FrameConverter frameConverter, FrameConverter frameConverter2, FrameCreator frameCreator, FrameCreator frameCreator2, FrameConverter frameConverter3, FrameCreator frameCreator3, FrameConverter frameConverter4, FrameCreator frameCreator4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            frameConverter = new ChargingConfigurationConverter();
        }
        if ((n & 4) != 0) {
            frameConverter2 = new WriteChargingLimitsResultConverter();
        }
        if ((n & 8) != 0) {
            frameCreator = new RequestChargingConfigurationCreator();
        }
        if ((n & 0x10) != 0) {
            frameCreator2 = new SetPowerSettingsCreator();
        }
        if ((n & 0x20) != 0) {
            frameConverter3 = new ManualChargeStateConverter();
        }
        if ((n & 0x40) != 0) {
            frameCreator3 = new RequestManualChargeStateCreator();
        }
        if ((n & 0x80) != 0) {
            frameConverter4 = new StartManualChargeResponseConverter();
        }
        if ((n & 0x100) != 0) {
            frameCreator4 = new RequestStartManualChargeCreator();
        }
        this(connectionPool, frameConverter, frameConverter2, frameCreator, frameCreator2, frameConverter3, frameCreator3, frameConverter4, frameCreator4);
    }

    @NotNull
    public ChargingConfiguration readConfiguration() {
        return (ChargingConfiguration)this.connectionPool.executeAndRelease((Function1)new Function1<HomePowerPlantConnection, ChargingConfiguration>(this){
            final /* synthetic */ DefaultChargingService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ChargingConfiguration invoke(@NotNull HomePowerPlantConnection it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Frame request = (Frame)DefaultChargingService.access$getCreateRequestChargingConfigurationFrame$p(this.this$0).invoke(null);
                DefaultChargingService.access$getLogger$p(this.this$0).trace((Function0)new Function0<Object>(request){
                    final /* synthetic */ Frame $request;
                    {
                        this.$request = $request;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Requesting charging configuration: " + this.$request;
                    }
                });
                Frame response = it.send(request);
                DefaultChargingService.access$getLogger$p(this.this$0).trace((Function0)new Function0<Object>(response){
                    final /* synthetic */ Frame $response;
                    {
                        this.$response = $response;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Received charging configuration: " + this.$response;
                    }
                });
                return (ChargingConfiguration)DefaultChargingService.access$getConvertFrameToChargingConfiguration$p(this.this$0).invoke(response);
            }
        });
    }

    @NotNull
    public WriteChargingLimitsResult writeLimits(@NotNull ChargingLimits limits) {
        Intrinsics.checkNotNullParameter((Object)limits, (String)"limits");
        return (WriteChargingLimitsResult)this.connectionPool.executeAndRelease((Function1)new Function1<HomePowerPlantConnection, WriteChargingLimitsResult>(this, limits){
            final /* synthetic */ DefaultChargingService this$0;
            final /* synthetic */ ChargingLimits $limits;
            {
                this.this$0 = $receiver;
                this.$limits = $limits;
                super(1);
            }

            @NotNull
            public final WriteChargingLimitsResult invoke(@NotNull HomePowerPlantConnection it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Frame writeRequest = (Frame)DefaultChargingService.access$getCreateSetPowerSettingsFrame$p(this.this$0).invoke(this.$limits);
                DefaultChargingService.access$getLogger$p(this.this$0).trace((Function0)new Function0<Object>(writeRequest){
                    final /* synthetic */ Frame $writeRequest;
                    {
                        this.$writeRequest = $writeRequest;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Writing charging limits: " + this.$writeRequest;
                    }
                });
                Frame writeResponse = it.send(writeRequest);
                DefaultChargingService.access$getLogger$p(this.this$0).trace((Function0)new Function0<Object>(writeResponse){
                    final /* synthetic */ Frame $writeResponse;
                    {
                        this.$writeResponse = $writeResponse;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Received write charging limits response: " + this.$writeResponse;
                    }
                });
                return (WriteChargingLimitsResult)DefaultChargingService.access$getConvertFrameToWriteChargingLimitsResult$p(this.this$0).invoke(writeResponse);
            }
        });
    }

    @NotNull
    public ManualChargeState readManualChargeState() {
        return (ManualChargeState)this.connectionPool.executeAndRelease((Function1)new Function1<HomePowerPlantConnection, ManualChargeState>(this){
            final /* synthetic */ DefaultChargingService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ManualChargeState invoke(@NotNull HomePowerPlantConnection it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return DefaultChargingService.access$executeReadManualChargeState(this.this$0, it);
            }
        });
    }

    public boolean startManualCharge(int amountWh) {
        return (Boolean)this.connectionPool.executeAndRelease((Function1)new Function1<HomePowerPlantConnection, Boolean>(this, amountWh){
            final /* synthetic */ DefaultChargingService this$0;
            final /* synthetic */ int $amountWh;
            {
                this.this$0 = $receiver;
                this.$amountWh = $amountWh;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull HomePowerPlantConnection it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return DefaultChargingService.access$executeManualCharge(this.this$0, it, this.$amountWh);
            }
        });
    }

    public boolean stopManualCharge() {
        return (Boolean)this.connectionPool.executeAndRelease((Function1)new Function1<HomePowerPlantConnection, Boolean>(this){
            final /* synthetic */ DefaultChargingService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull HomePowerPlantConnection it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ManualChargeState state = DefaultChargingService.access$executeReadManualChargeState(this.this$0, it);
                return state.getActive() ? DefaultChargingService.access$executeManualCharge(this.this$0, it, 0) : true;
            }
        });
    }

    private final ManualChargeState executeReadManualChargeState(HomePowerPlantConnection connection) {
        Frame request = (Frame)this.createRequestManualChargeState.invoke(null);
        this.logger.trace((Function0)new Function0<Object>(request){
            final /* synthetic */ Frame $request;
            {
                this.$request = $request;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Requesting manual charge state: " + this.$request;
            }
        });
        Frame response = connection.send(request);
        this.logger.trace((Function0)new Function0<Object>(response){
            final /* synthetic */ Frame $response;
            {
                this.$response = $response;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Received response for manual charge state: " + this.$response;
            }
        });
        return (ManualChargeState)this.convertFrameToManualChargeState.invoke(response);
    }

    private final boolean executeManualCharge(HomePowerPlantConnection connection, int amountWh) {
        Frame request = (Frame)this.createRequestStartManualCharge.invoke(amountWh);
        this.logger.trace((Function0)new Function0<Object>(request){
            final /* synthetic */ Frame $request;
            {
                this.$request = $request;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Requesting start of manual charge: " + this.$request;
            }
        });
        Frame response = connection.send(request);
        this.logger.trace((Function0)new Function0<Object>(response){
            final /* synthetic */ Frame $response;
            {
                this.$response = $response;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Received response for start manual charge state: " + this.$response;
            }
        });
        return (Boolean)this.convertFrameToStartManualChargeResponseState.invoke(response);
    }

    public static final /* synthetic */ FrameCreator access$getCreateRequestChargingConfigurationFrame$p(DefaultChargingService $this) {
        return $this.createRequestChargingConfigurationFrame;
    }

    public static final /* synthetic */ KLogger access$getLogger$p(DefaultChargingService $this) {
        return $this.logger;
    }

    public static final /* synthetic */ FrameConverter access$getConvertFrameToChargingConfiguration$p(DefaultChargingService $this) {
        return $this.convertFrameToChargingConfiguration;
    }

    public static final /* synthetic */ FrameCreator access$getCreateSetPowerSettingsFrame$p(DefaultChargingService $this) {
        return $this.createSetPowerSettingsFrame;
    }

    public static final /* synthetic */ FrameConverter access$getConvertFrameToWriteChargingLimitsResult$p(DefaultChargingService $this) {
        return $this.convertFrameToWriteChargingLimitsResult;
    }

    public static final /* synthetic */ ManualChargeState access$executeReadManualChargeState(DefaultChargingService $this, HomePowerPlantConnection connection) {
        return $this.executeReadManualChargeState(connection);
    }

    public static final /* synthetic */ boolean access$executeManualCharge(DefaultChargingService $this, HomePowerPlantConnection connection, int amountWh) {
        return $this.executeManualCharge(connection, amountWh);
    }
}

