/*
 * Decompiled with CFR 0.152.
 */
package de.jnkconsulting.e3dc.easyrscp.service;

import de.jnkconsulting.e3dc.easyrscp.api.connection.ConnectionPool;
import de.jnkconsulting.e3dc.easyrscp.api.connection.HomePowerPlantConnection;
import de.jnkconsulting.e3dc.easyrscp.api.frame.Data;
import de.jnkconsulting.e3dc.easyrscp.api.frame.Frame;
import de.jnkconsulting.e3dc.easyrscp.api.frame.Tag;
import de.jnkconsulting.e3dc.easyrscp.api.frame.tags.BatTag;
import de.jnkconsulting.e3dc.easyrscp.api.service.BatteryService;
import de.jnkconsulting.e3dc.easyrscp.api.service.model.BatterySpec;
import de.jnkconsulting.e3dc.easyrscp.api.service.model.BatteryStatus;
import de.jnkconsulting.e3dc.easyrscp.api.service.model.DCBSpec;
import de.jnkconsulting.e3dc.easyrscp.api.service.model.DCBStatus;
import de.jnkconsulting.e3dc.easyrscp.api.service.model.TrainingMode;
import de.jnkconsulting.e3dc.easyrscp.service.DefaultBatteryService;
import de.jnkconsulting.e3dc.easyrscp.service.creator.BatteryInfoRequestCreator;
import de.jnkconsulting.e3dc.easyrscp.service.creator.DCBInfoRequestCreator;
import de.jnkconsulting.e3dc.easyrscp.service.creator.FrameCreator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\b0\u0005\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/jnkconsulting/e3dc/easyrscp/service/DefaultBatteryService;", "Lde/jnkconsulting/e3dc/easyrscp/api/service/BatteryService;", "connectionPool", "Lde/jnkconsulting/e3dc/easyrscp/api/connection/ConnectionPool;", "batInfoRequestCreator", "Lde/jnkconsulting/e3dc/easyrscp/service/creator/FrameCreator;", "", "dcbInfoRequestCreator", "Lkotlin/Pair;", "(Lde/jnkconsulting/e3dc/easyrscp/api/connection/ConnectionPool;Lde/jnkconsulting/e3dc/easyrscp/service/creator/FrameCreator;Lde/jnkconsulting/e3dc/easyrscp/service/creator/FrameCreator;)V", "logger", "Lmu/KLogger;", "readMonitoringData", "", "Lde/jnkconsulting/e3dc/easyrscp/api/service/model/BatteryStatus;", "readSpecification", "Lde/jnkconsulting/e3dc/easyrscp/api/service/model/BatterySpec;", "jnk-easy-rscp-service"})
public final class DefaultBatteryService
implements BatteryService {
    @NotNull
    private final ConnectionPool connectionPool;
    @NotNull
    private final FrameCreator<Integer> batInfoRequestCreator;
    @NotNull
    private final FrameCreator<Pair<Integer, Integer>> dcbInfoRequestCreator;
    @NotNull
    private final KLogger logger;

    public DefaultBatteryService(@NotNull ConnectionPool connectionPool, @NotNull FrameCreator<Integer> batInfoRequestCreator, @NotNull FrameCreator<Pair<Integer, Integer>> dcbInfoRequestCreator) {
        Intrinsics.checkNotNullParameter((Object)connectionPool, (String)"connectionPool");
        Intrinsics.checkNotNullParameter(batInfoRequestCreator, (String)"batInfoRequestCreator");
        Intrinsics.checkNotNullParameter(dcbInfoRequestCreator, (String)"dcbInfoRequestCreator");
        this.connectionPool = connectionPool;
        this.batInfoRequestCreator = batInfoRequestCreator;
        this.dcbInfoRequestCreator = dcbInfoRequestCreator;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    }

    public /* synthetic */ DefaultBatteryService(ConnectionPool connectionPool, FrameCreator frameCreator, FrameCreator frameCreator2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            frameCreator = new BatteryInfoRequestCreator();
        }
        if ((n & 4) != 0) {
            frameCreator2 = new DCBInfoRequestCreator();
        }
        this(connectionPool, frameCreator, frameCreator2);
    }

    @NotNull
    public List<BatterySpec> readSpecification() {
        return (List)this.connectionPool.executeAndRelease((Function1)new Function1<HomePowerPlantConnection, List<BatterySpec>>(this){
            final /* synthetic */ DefaultBatteryService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final List<BatterySpec> invoke(@NotNull HomePowerPlantConnection it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                List result = new ArrayList<E>();
                for (int batIndex = 0; batIndex < 10; ++batIndex) {
                    List dcbSpecs = new ArrayList<E>();
                    Frame batInfoRequest = (Frame)DefaultBatteryService.access$getBatInfoRequestCreator$p(this.this$0).invoke(batIndex);
                    Frame batInfoResponse = it.send(batInfoRequest);
                    if (batInfoResponse.isDataBlockInError((Tag)BatTag.DATA, new Tag[0])) break;
                    Tag[] tagArray = new Tag[]{BatTag.DATA};
                    int dcbCount = batInfoResponse.byteByTag((Tag)BatTag.DCB_COUNT, tagArray);
                    int n = dcbCount;
                    for (int dcbIndex = 0; dcbIndex < n; ++dcbIndex) {
                        Frame dcbInfoRequest = (Frame)DefaultBatteryService.access$getDcbInfoRequestCreator$p(this.this$0).invoke(TuplesKt.to((Object)batIndex, (Object)dcbIndex));
                        Frame dcbInfoResponse = it.send(dcbInfoRequest);
                        Tag[] tagArray2 = new Tag[]{BatTag.DATA, BatTag.DCB_INFO};
                        float f = dcbInfoResponse.floatByTag((Tag)BatTag.DCB_DESIGN_CAPACITY, tagArray2);
                        tagArray2 = new Tag[]{BatTag.DATA, BatTag.DCB_INFO};
                        float f2 = dcbInfoResponse.floatByTag((Tag)BatTag.DCB_MAX_CHARGE_CURRENT, tagArray2);
                        tagArray2 = new Tag[]{BatTag.DATA, BatTag.DCB_INFO};
                        float f3 = dcbInfoResponse.floatByTag((Tag)BatTag.DCB_MAX_DISCHARGE_CURRENT, tagArray2);
                        tagArray2 = new Tag[]{BatTag.DATA, BatTag.DCB_INFO};
                        float f4 = dcbInfoResponse.floatByTag((Tag)BatTag.DCB_FULL_CHARGE_CAPACITY, tagArray2);
                        tagArray2 = new Tag[]{BatTag.DATA, BatTag.DCB_INFO};
                        float f5 = dcbInfoResponse.floatByTag((Tag)BatTag.DCB_DESIGN_VOLTAGE, tagArray2);
                        tagArray2 = new Tag[]{BatTag.DATA, BatTag.DCB_INFO};
                        float f6 = dcbInfoResponse.floatByTag((Tag)BatTag.DCB_CHARGE_HIGH_TEMPERATURE, tagArray2);
                        tagArray2 = new Tag[]{BatTag.DATA, BatTag.DCB_INFO};
                        float f7 = dcbInfoResponse.floatByTag((Tag)BatTag.DCB_CHARGE_LOW_TEMPERATURE, tagArray2);
                        tagArray2 = new Tag[]{BatTag.DATA, BatTag.DCB_INFO};
                        int n2 = dcbInfoResponse.intByTag((Tag)BatTag.DCB_NR_SERIES_CELL, tagArray2);
                        tagArray2 = new Tag[]{BatTag.DATA, BatTag.DCB_INFO};
                        dcbSpecs.add(new DCBSpec(dcbIndex, f, f2, f3, f4, f5, f6, f7, n2, dcbInfoResponse.intByTag((Tag)BatTag.DCB_NR_PARALLEL_CELL, tagArray2)));
                    }
                    tagArray = new Tag[]{BatTag.DATA};
                    String string = batInfoResponse.stringByTag((Tag)BatTag.DEVICE_NAME, tagArray);
                    tagArray = new Tag[]{BatTag.DATA};
                    int n3 = batInfoResponse.intByTag((Tag)BatTag.CHARGE_HIGH_TEMP, tagArray);
                    tagArray = new Tag[]{BatTag.DATA};
                    int n4 = batInfoResponse.intByTag((Tag)BatTag.CHARGE_LOW_TEMP, tagArray);
                    tagArray = new Tag[]{BatTag.DATA};
                    float f = batInfoResponse.floatByTag((Tag)BatTag.DESIGN_VOLTAGE, tagArray);
                    tagArray = new Tag[]{BatTag.DATA};
                    float f8 = batInfoResponse.floatByTag((Tag)BatTag.DESIGN_CAPACITY, tagArray);
                    tagArray = new Tag[]{BatTag.DATA, BatTag.SPECIFICATION};
                    float f9 = batInfoResponse.floatByTag((Tag)BatTag.SPECIFIED_CAPACITY, tagArray);
                    tagArray = new Tag[]{BatTag.DATA};
                    float f10 = batInfoResponse.floatByTag((Tag)BatTag.MAX_CHARGE_CURRENT, tagArray);
                    tagArray = new Tag[]{BatTag.DATA};
                    result.add(new BatterySpec((short)batIndex, string, n3, n4, f, f8, f9, f10, batInfoResponse.floatByTag((Tag)BatTag.MAX_DISCHARGE_CURRENT, tagArray), CollectionsKt.toList((Iterable)dcbSpecs)));
                }
                return result;
            }
        });
    }

    @NotNull
    public List<BatteryStatus> readMonitoringData() {
        return (List)this.connectionPool.executeAndRelease((Function1)new Function1<HomePowerPlantConnection, List<BatteryStatus>>(this){
            final /* synthetic */ DefaultBatteryService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<BatteryStatus> invoke(@NotNull HomePowerPlantConnection it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                List result = new ArrayList<E>();
                for (int batIndex = 0; batIndex < 10; ++batIndex) {
                    List dcbStatus = new ArrayList<E>();
                    Frame batInfoRequest = (Frame)DefaultBatteryService.access$getBatInfoRequestCreator$p(this.this$0).invoke(batIndex);
                    Frame batInfoResponse = it.send(batInfoRequest);
                    if (batInfoResponse.isDataBlockInError((Tag)BatTag.DATA, new Tag[0])) break;
                    Tag[] tagArray = new Tag[]{BatTag.DATA};
                    int dcbCount = batInfoResponse.byteByTag((Tag)BatTag.DCB_COUNT, tagArray);
                    int n = dcbCount;
                    for (int dcbIndex = 0; dcbIndex < n; ++dcbIndex) {
                        Collection<Float> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Frame dcbInfoRequest = (Frame)DefaultBatteryService.access$getDcbInfoRequestCreator$p(this.this$0).invoke(TuplesKt.to((Object)batIndex, (Object)dcbIndex));
                        Frame dcbInfoResponse = it.send(dcbInfoRequest);
                        Object object = new Tag[]{BatTag.DATA, BatTag.DCB_INFO};
                        float f = dcbInfoResponse.floatByTag((Tag)BatTag.DCB_VOLTAGE, object);
                        object = new Tag[]{BatTag.DATA, BatTag.DCB_INFO};
                        float f2 = dcbInfoResponse.floatByTag((Tag)BatTag.DCB_VOLTAGE_AVG_30S, object);
                        object = new Tag[]{BatTag.DATA, BatTag.DCB_INFO};
                        float f3 = dcbInfoResponse.floatByTag((Tag)BatTag.DCB_CURRENT, object);
                        object = new Tag[]{BatTag.DATA, BatTag.DCB_INFO};
                        float f4 = dcbInfoResponse.floatByTag((Tag)BatTag.DCB_CURRENT_AVG_30S, object);
                        object = new Tag[]{BatTag.DATA, BatTag.DCB_ALL_CELL_TEMPERATURES};
                        object = dcbInfoResponse.containerByTag((Tag)BatTag.DATA, object);
                        float f5 = f4;
                        float f6 = f3;
                        float f7 = f2;
                        float f8 = f;
                        int n2 = dcbIndex;
                        List list = dcbStatus;
                        boolean $i$f$map = false;
                        void var14_17 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void data;
                            Data data2 = (Data)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            Float f9 = data.valueAsFloat();
                            collection.add(Float.valueOf(f9 != null ? f9.floatValue() : 0.0f));
                        }
                        Collection<Float> collection2 = collection = (List)destination$iv$iv;
                        float f10 = f5;
                        float f11 = f6;
                        float f12 = f7;
                        float f13 = f8;
                        int n3 = n2;
                        list.add(new DCBStatus(n3, f13, f12, f11, f10, collection2));
                    }
                    Tag[] tagArray2 = new Tag[]{BatTag.DATA};
                    byte trainingModeRAW = batInfoResponse.byteByTag((Tag)BatTag.TRAINING_MODE, tagArray2);
                    byte by = trainingModeRAW;
                    TrainingMode trainingMode = by == 0 ? TrainingMode.NOT_IN_TRAINING : (by == 1 ? TrainingMode.TRAINING_DISCHARGE : (by == 2 ? TrainingMode.TRAINING_CHARGE : TrainingMode.UNKNOWN));
                    Tag[] tagArray3 = new Tag[]{BatTag.DATA, BatTag.DEVICE_STATE};
                    boolean bl = batInfoResponse.booleanByTag((Tag)BatTag.DEVICE_CONNECTED, tagArray3);
                    tagArray3 = new Tag[]{BatTag.DATA, BatTag.DEVICE_STATE};
                    boolean bl2 = batInfoResponse.booleanByTag((Tag)BatTag.DEVICE_WORKING, tagArray3);
                    tagArray3 = new Tag[]{BatTag.DATA, BatTag.DEVICE_STATE};
                    boolean bl3 = batInfoResponse.booleanByTag((Tag)BatTag.DEVICE_IN_SERVICE, tagArray3);
                    tagArray3 = new Tag[]{BatTag.DATA};
                    float f = batInfoResponse.floatByTag((Tag)BatTag.ASOC, tagArray3) / 100.0f;
                    tagArray3 = new Tag[]{BatTag.DATA};
                    float f14 = batInfoResponse.floatByTag((Tag)BatTag.RSOC_REAL, tagArray3) / 100.0f;
                    tagArray3 = new Tag[]{BatTag.DATA};
                    result.add(new BatteryStatus((short)batIndex, trainingMode != TrainingMode.NOT_IN_TRAINING, bl, bl2, bl3, f, f14, batInfoResponse.floatByTag((Tag)BatTag.MODULE_VOLTAGE, tagArray3), dcbStatus, trainingMode));
                }
                return result;
            }
        });
    }

    public static final /* synthetic */ FrameCreator access$getBatInfoRequestCreator$p(DefaultBatteryService $this) {
        return $this.batInfoRequestCreator;
    }

    public static final /* synthetic */ FrameCreator access$getDcbInfoRequestCreator$p(DefaultBatteryService $this) {
        return $this.dcbInfoRequestCreator;
    }
}

