/*
 * Decompiled with CFR 0.152.
 */
package de.jnkconsulting.e3dc.easyrscp.service.builder;

import de.jnkconsulting.e3dc.easyrscp.api.service.DBSummaryService;
import de.jnkconsulting.e3dc.easyrscp.api.service.model.HistoryData;
import de.jnkconsulting.e3dc.easyrscp.connection.ConnectionBuilder;
import de.jnkconsulting.e3dc.easyrscp.service.DefaultDBSummaryService;
import de.jnkconsulting.e3dc.easyrscp.service.builder.DefaultServiceBuilder;
import de.jnkconsulting.e3dc.easyrscp.service.builder.ServiceBuilder;
import de.jnkconsulting.e3dc.easyrscp.service.converter.RequestResponseFrameConvert;
import de.jnkconsulting.e3dc.easyrscp.service.converter.db.DailySummaryConverter;
import de.jnkconsulting.e3dc.easyrscp.service.converter.db.MonthlySummaryConverter;
import de.jnkconsulting.e3dc.easyrscp.service.converter.db.YearlySummaryConverter;
import de.jnkconsulting.e3dc.easyrscp.service.creator.FrameCreator;
import de.jnkconsulting.e3dc.easyrscp.service.creator.db.ReadDailySummaryCreator;
import de.jnkconsulting.e3dc.easyrscp.service.creator.db.ReadMonthlySummaryCreator;
import de.jnkconsulting.e3dc.easyrscp.service.creator.db.ReadYearlySummaryCreator;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\nH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0014\u0010\u001b\u001a\u00020\u00002\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0014\u0010\u001d\u001a\u00020\u00002\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0016\u0010\u001e\u001a\u00020\u00002\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nJ\u0016\u0010 \u001a\u00020\u00002\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\nJ\u0016\u0010!\u001a\u00020\u00002\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\nJ\u0014\u0010\"\u001a\u00020\u00002\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lde/jnkconsulting/e3dc/easyrscp/service/builder/DBSummaryServiceBuilder;", "Lde/jnkconsulting/e3dc/easyrscp/service/builder/DefaultServiceBuilder;", "Lde/jnkconsulting/e3dc/easyrscp/api/service/DBSummaryService;", "()V", "convertFrameToDailySummary", "Lde/jnkconsulting/e3dc/easyrscp/service/converter/RequestResponseFrameConvert;", "Lde/jnkconsulting/e3dc/easyrscp/api/service/model/HistoryData;", "convertFrameToMonthlySummary", "convertFrameToYearlySummary", "createRequestDailySummaryFrame", "Lde/jnkconsulting/e3dc/easyrscp/service/creator/FrameCreator;", "Ljava/time/LocalDate;", "createRequestMonthlySummaryFrame", "Ljava/time/YearMonth;", "createRequestYearlySummaryFrame", "Ljava/time/Year;", "buildDailySummaryFrameConverter", "buildMonthlySummaryFrameConverter", "buildRequestDailySummaryFrameCreator", "buildRequestMonthlySummaryFrameCreator", "buildRequestYearlySummaryFrameCreator", "buildService", "Lde/jnkconsulting/e3dc/easyrscp/service/DefaultDBSummaryService;", "buildYearlySummaryFrameConverter", "withConnectionBuilder", "connectionBuilder", "Lde/jnkconsulting/e3dc/easyrscp/connection/ConnectionBuilder;", "withDailySummaryFrameConverter", "converter", "withMonthlySummaryFrameConverter", "withRequestDailySummaryFrameCreator", "creator", "withRequestMonthlySummaryFrameCreator", "withRequestYearlySummaryFrameCreator", "withYearlySummaryFrameConverter", "jnk-easy-rscp-service"})
public final class DBSummaryServiceBuilder
extends DefaultServiceBuilder<DBSummaryService> {
    @Nullable
    private RequestResponseFrameConvert<HistoryData> convertFrameToDailySummary;
    @Nullable
    private RequestResponseFrameConvert<HistoryData> convertFrameToMonthlySummary;
    @Nullable
    private RequestResponseFrameConvert<HistoryData> convertFrameToYearlySummary;
    @Nullable
    private FrameCreator<LocalDate> createRequestDailySummaryFrame;
    @Nullable
    private FrameCreator<YearMonth> createRequestMonthlySummaryFrame;
    @Nullable
    private FrameCreator<Year> createRequestYearlySummaryFrame;

    @NotNull
    public DBSummaryServiceBuilder withConnectionBuilder(@NotNull ConnectionBuilder connectionBuilder) {
        Intrinsics.checkNotNullParameter((Object)connectionBuilder, (String)"connectionBuilder");
        ServiceBuilder serviceBuilder = super.withConnectionBuilder(connectionBuilder);
        Intrinsics.checkNotNull(serviceBuilder, (String)"null cannot be cast to non-null type de.jnkconsulting.e3dc.easyrscp.service.builder.DBSummaryServiceBuilder");
        return (DBSummaryServiceBuilder)serviceBuilder;
    }

    @NotNull
    public final DBSummaryServiceBuilder withDailySummaryFrameConverter(@NotNull RequestResponseFrameConvert<HistoryData> converter) {
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        RequestResponseFrameConvert<HistoryData> it = converter;
        boolean bl = false;
        this.convertFrameToDailySummary = it;
        return this;
    }

    @NotNull
    public final DBSummaryServiceBuilder withMonthlySummaryFrameConverter(@NotNull RequestResponseFrameConvert<HistoryData> converter) {
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        RequestResponseFrameConvert<HistoryData> it = converter;
        boolean bl = false;
        this.convertFrameToMonthlySummary = it;
        return this;
    }

    @NotNull
    public final DBSummaryServiceBuilder withYearlySummaryFrameConverter(@NotNull RequestResponseFrameConvert<HistoryData> converter) {
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        RequestResponseFrameConvert<HistoryData> it = converter;
        boolean bl = false;
        this.convertFrameToYearlySummary = it;
        return this;
    }

    @NotNull
    public final DBSummaryServiceBuilder withRequestDailySummaryFrameCreator(@Nullable FrameCreator<LocalDate> creator) {
        FrameCreator<LocalDate> it = creator;
        boolean bl = false;
        this.createRequestDailySummaryFrame = it;
        return this;
    }

    @NotNull
    public final DBSummaryServiceBuilder withRequestMonthlySummaryFrameCreator(@Nullable FrameCreator<YearMonth> creator) {
        FrameCreator<YearMonth> it = creator;
        boolean bl = false;
        this.createRequestMonthlySummaryFrame = it;
        return this;
    }

    @NotNull
    public final DBSummaryServiceBuilder withRequestYearlySummaryFrameCreator(@Nullable FrameCreator<Year> creator) {
        FrameCreator<Year> it = creator;
        boolean bl = false;
        this.createRequestYearlySummaryFrame = it;
        return this;
    }

    private final RequestResponseFrameConvert<HistoryData> buildDailySummaryFrameConverter() {
        RequestResponseFrameConvert requestResponseFrameConvert = this.convertFrameToDailySummary;
        if (requestResponseFrameConvert == null) {
            requestResponseFrameConvert = new DailySummaryConverter();
        }
        return requestResponseFrameConvert;
    }

    private final RequestResponseFrameConvert<HistoryData> buildMonthlySummaryFrameConverter() {
        RequestResponseFrameConvert requestResponseFrameConvert = this.convertFrameToMonthlySummary;
        if (requestResponseFrameConvert == null) {
            requestResponseFrameConvert = new MonthlySummaryConverter();
        }
        return requestResponseFrameConvert;
    }

    private final RequestResponseFrameConvert<HistoryData> buildYearlySummaryFrameConverter() {
        RequestResponseFrameConvert requestResponseFrameConvert = this.convertFrameToYearlySummary;
        if (requestResponseFrameConvert == null) {
            requestResponseFrameConvert = new YearlySummaryConverter();
        }
        return requestResponseFrameConvert;
    }

    private final FrameCreator<LocalDate> buildRequestDailySummaryFrameCreator() {
        FrameCreator frameCreator = this.createRequestDailySummaryFrame;
        if (frameCreator == null) {
            frameCreator = new ReadDailySummaryCreator();
        }
        return frameCreator;
    }

    private final FrameCreator<YearMonth> buildRequestMonthlySummaryFrameCreator() {
        FrameCreator frameCreator = this.createRequestMonthlySummaryFrame;
        if (frameCreator == null) {
            frameCreator = new ReadMonthlySummaryCreator();
        }
        return frameCreator;
    }

    private final FrameCreator<Year> buildRequestYearlySummaryFrameCreator() {
        FrameCreator frameCreator = this.createRequestYearlySummaryFrame;
        if (frameCreator == null) {
            frameCreator = new ReadYearlySummaryCreator();
        }
        return frameCreator;
    }

    @Override
    @NotNull
    public DefaultDBSummaryService buildService() {
        return new DefaultDBSummaryService(this.getConnectionBuilder().buildConnectionPool(), this.buildDailySummaryFrameConverter(), this.buildMonthlySummaryFrameConverter(), this.buildYearlySummaryFrameConverter(), this.buildRequestDailySummaryFrameCreator(), this.buildRequestMonthlySummaryFrameCreator(), this.buildRequestYearlySummaryFrameCreator());
    }
}

