/*
 * Decompiled with CFR 0.152.
 */
package de.jnkconsulting.e3dc.easyrscp.service;

import de.jnkconsulting.e3dc.easyrscp.api.connection.ConnectionPool;
import de.jnkconsulting.e3dc.easyrscp.api.connection.HomePowerPlantConnection;
import de.jnkconsulting.e3dc.easyrscp.api.frame.Frame;
import de.jnkconsulting.e3dc.easyrscp.api.service.EmergencyPowerService;
import de.jnkconsulting.e3dc.easyrscp.api.service.model.BatteryUnit;
import de.jnkconsulting.e3dc.easyrscp.api.service.model.EmergencyPowerState;
import de.jnkconsulting.e3dc.easyrscp.service.DefaultEmergencyPowerService;
import de.jnkconsulting.e3dc.easyrscp.service.converter.EmergencyPowerStateConverter;
import de.jnkconsulting.e3dc.easyrscp.service.converter.FrameConverter;
import de.jnkconsulting.e3dc.easyrscp.service.creator.FrameCreator;
import de.jnkconsulting.e3dc.easyrscp.service.creator.PowerReserveInput;
import de.jnkconsulting.e3dc.easyrscp.service.creator.ReadEmergencyPowerStateCreator;
import de.jnkconsulting.e3dc.easyrscp.service.creator.SetEmergencyPowerReserveCreator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\b\u0010\u0013\u001a\u00020\u0006H\u0016J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0014\u0010\u0019\u001a\u00020\u00062\n\u0010\u001a\u001a\u00060\u0016j\u0002`\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lde/jnkconsulting/e3dc/easyrscp/service/DefaultEmergencyPowerService;", "Lde/jnkconsulting/e3dc/easyrscp/api/service/EmergencyPowerService;", "connectionPool", "Lde/jnkconsulting/e3dc/easyrscp/api/connection/ConnectionPool;", "convertFrameToEmergencyPowerState", "Lde/jnkconsulting/e3dc/easyrscp/service/converter/FrameConverter;", "Lde/jnkconsulting/e3dc/easyrscp/api/service/model/EmergencyPowerState;", "createReadStateFrame", "Lde/jnkconsulting/e3dc/easyrscp/service/creator/FrameCreator;", "", "createSetEmergencyPowerReserveFrame", "Lde/jnkconsulting/e3dc/easyrscp/service/creator/PowerReserveInput;", "(Lde/jnkconsulting/e3dc/easyrscp/api/connection/ConnectionPool;Lde/jnkconsulting/e3dc/easyrscp/service/converter/FrameConverter;Lde/jnkconsulting/e3dc/easyrscp/service/creator/FrameCreator;Lde/jnkconsulting/e3dc/easyrscp/service/creator/FrameCreator;)V", "logger", "Lmu/KLogger;", "readEPState", "it", "Lde/jnkconsulting/e3dc/easyrscp/api/connection/HomePowerPlantConnection;", "readState", "removeReserve", "setEmergencyPowerReserve", "value", "", "unit", "Lde/jnkconsulting/e3dc/easyrscp/api/service/model/BatteryUnit;", "setReservePercentage", "reserve", "Lde/jnkconsulting/e3dc/easyrscp/api/service/model/Percentage;", "setReserveWH", "jnk-easy-rscp-service"})
public final class DefaultEmergencyPowerService
implements EmergencyPowerService {
    @NotNull
    private final ConnectionPool connectionPool;
    @NotNull
    private final FrameConverter<EmergencyPowerState> convertFrameToEmergencyPowerState;
    @NotNull
    private final FrameCreator createReadStateFrame;
    @NotNull
    private final FrameCreator<PowerReserveInput> createSetEmergencyPowerReserveFrame;
    @NotNull
    private final KLogger logger;

    public DefaultEmergencyPowerService(@NotNull ConnectionPool connectionPool, @NotNull FrameConverter<EmergencyPowerState> convertFrameToEmergencyPowerState, @NotNull FrameCreator createReadStateFrame, @NotNull FrameCreator<PowerReserveInput> createSetEmergencyPowerReserveFrame) {
        Intrinsics.checkNotNullParameter((Object)connectionPool, (String)"connectionPool");
        Intrinsics.checkNotNullParameter(convertFrameToEmergencyPowerState, (String)"convertFrameToEmergencyPowerState");
        Intrinsics.checkNotNullParameter((Object)createReadStateFrame, (String)"createReadStateFrame");
        Intrinsics.checkNotNullParameter(createSetEmergencyPowerReserveFrame, (String)"createSetEmergencyPowerReserveFrame");
        this.connectionPool = connectionPool;
        this.convertFrameToEmergencyPowerState = convertFrameToEmergencyPowerState;
        this.createReadStateFrame = createReadStateFrame;
        this.createSetEmergencyPowerReserveFrame = createSetEmergencyPowerReserveFrame;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    }

    public /* synthetic */ DefaultEmergencyPowerService(ConnectionPool connectionPool, FrameConverter frameConverter, FrameCreator frameCreator, FrameCreator frameCreator2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            frameConverter = new EmergencyPowerStateConverter();
        }
        if ((n & 4) != 0) {
            frameCreator = new ReadEmergencyPowerStateCreator();
        }
        if ((n & 8) != 0) {
            frameCreator2 = new SetEmergencyPowerReserveCreator();
        }
        this(connectionPool, frameConverter, frameCreator, frameCreator2);
    }

    @NotNull
    public EmergencyPowerState removeReserve() {
        return this.setEmergencyPowerReserve(0.0f, BatteryUnit.PERCENTAGE);
    }

    @NotNull
    public EmergencyPowerState setReserveWH(float reserve) {
        return this.setEmergencyPowerReserve(reserve, BatteryUnit.WATT_HOURS);
    }

    @NotNull
    public EmergencyPowerState setReservePercentage(float reserve) {
        return this.setEmergencyPowerReserve(reserve, BatteryUnit.PERCENTAGE);
    }

    @NotNull
    public EmergencyPowerState readState() {
        return (EmergencyPowerState)this.connectionPool.executeAndRelease((Function1)new Function1<HomePowerPlantConnection, EmergencyPowerState>(this){
            final /* synthetic */ DefaultEmergencyPowerService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final EmergencyPowerState invoke(@NotNull HomePowerPlantConnection it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return DefaultEmergencyPowerService.access$readEPState(this.this$0, it);
            }
        });
    }

    private final EmergencyPowerState setEmergencyPowerReserve(float value, BatteryUnit unit) {
        return (EmergencyPowerState)this.connectionPool.executeAndRelease((Function1)new Function1<HomePowerPlantConnection, EmergencyPowerState>(this, value, unit){
            final /* synthetic */ DefaultEmergencyPowerService this$0;
            final /* synthetic */ float $value;
            final /* synthetic */ BatteryUnit $unit;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                this.$unit = $unit;
                super(1);
            }

            @NotNull
            public final EmergencyPowerState invoke(@NotNull HomePowerPlantConnection it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Frame request = (Frame)DefaultEmergencyPowerService.access$getCreateSetEmergencyPowerReserveFrame$p(this.this$0).invoke(new PowerReserveInput(this.$value, this.$unit));
                DefaultEmergencyPowerService.access$getLogger$p(this.this$0).trace((Function0)new Function0<Object>(request){
                    final /* synthetic */ Frame $request;
                    {
                        this.$request = $request;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Setting emergency power reserve: " + this.$request;
                    }
                });
                Frame response = it.send(request);
                DefaultEmergencyPowerService.access$getLogger$p(this.this$0).trace((Function0)new Function0<Object>(response){
                    final /* synthetic */ Frame $response;
                    {
                        this.$response = $response;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Setting emergency power reserve response: " + this.$response;
                    }
                });
                return DefaultEmergencyPowerService.access$readEPState(this.this$0, it);
            }
        });
    }

    private final EmergencyPowerState readEPState(HomePowerPlantConnection it) {
        Frame request = (Frame)this.createReadStateFrame.invoke(null);
        this.logger.trace((Function0)new Function0<Object>(request){
            final /* synthetic */ Frame $request;
            {
                this.$request = $request;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Requesting emergency power state: " + this.$request;
            }
        });
        Frame response = it.send(request);
        this.logger.trace((Function0)new Function0<Object>(response){
            final /* synthetic */ Frame $response;
            {
                this.$response = $response;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Received emergency power state: " + this.$response;
            }
        });
        return (EmergencyPowerState)this.convertFrameToEmergencyPowerState.invoke(response);
    }

    public static final /* synthetic */ EmergencyPowerState access$readEPState(DefaultEmergencyPowerService $this, HomePowerPlantConnection it) {
        return $this.readEPState(it);
    }

    public static final /* synthetic */ FrameCreator access$getCreateSetEmergencyPowerReserveFrame$p(DefaultEmergencyPowerService $this) {
        return $this.createSetEmergencyPowerReserveFrame;
    }

    public static final /* synthetic */ KLogger access$getLogger$p(DefaultEmergencyPowerService $this) {
        return $this.logger;
    }
}

