/*
 * Decompiled with CFR 0.152.
 */
package de.jnkconsulting.e3dc.easyrscp.service.converter;

import de.jnkconsulting.e3dc.easyrscp.api.bytes.ByteHelperKt;
import de.jnkconsulting.e3dc.easyrscp.api.frame.Data;
import de.jnkconsulting.e3dc.easyrscp.api.frame.DataParser;
import de.jnkconsulting.e3dc.easyrscp.api.frame.DataType;
import de.jnkconsulting.e3dc.easyrscp.api.frame.Frame;
import de.jnkconsulting.e3dc.easyrscp.service.converter.FrameConverter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0011\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0096\u0002\u00a8\u0006\u000e"}, d2={"Lde/jnkconsulting/e3dc/easyrscp/service/converter/StringFrameConverter;", "Lde/jnkconsulting/e3dc/easyrscp/service/converter/FrameConverter;", "", "()V", "convertData", "toPrint", "Lde/jnkconsulting/e3dc/easyrscp/api/frame/Data;", "level", "", "parser", "Lde/jnkconsulting/e3dc/easyrscp/api/frame/DataParser;", "invoke", "frame", "Lde/jnkconsulting/e3dc/easyrscp/api/frame/Frame;", "jnk-easy-rscp-service"})
@SourceDebugExtension(value={"SMAP\nStringFrameConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringFrameConverter.kt\nde/jnkconsulting/e3dc/easyrscp/service/converter/StringFrameConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n1855#2,2:43\n1855#2,2:45\n*S KotlinDebug\n*F\n+ 1 StringFrameConverter.kt\nde/jnkconsulting/e3dc/easyrscp/service/converter/StringFrameConverter\n*L\n22#1:43,2\n34#1:45,2\n*E\n"})
public final class StringFrameConverter
implements FrameConverter<String> {
    @NotNull
    public String invoke(@NotNull Frame frame) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        StringBuilder out = stringBuilder = new StringBuilder().append("Timestamp:\t" + frame.getTimestamp() + "\n").append("WithChecksum:\t" + frame.isChecksumEnabled() + "\n");
        boolean bl = false;
        Iterable $this$forEach$iv = frame.getData();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Data it = (Data)element$iv;
            boolean bl2 = false;
            out.append(this.convertData(it, 1, frame.getParser()));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String convertData(Data toPrint, int level, DataParser parser) {
        String tabs = StringsKt.repeat((CharSequence)"\t", (int)level);
        Object object = new byte[]{toPrint.getType()};
        StringBuilder result = new StringBuilder().append(tabs + "Tag:\t" + toPrint.tagObject().getNamespace() + "." + toPrint.tagObject() + " - " + ByteHelperKt.toHexString((byte[])toPrint.getTag()) + "\n").append(tabs + "Type:\t" + toPrint.typeObject() + " - " + ByteHelperKt.toHexString((byte[])object) + "\n");
        if (toPrint.typeObject() == DataType.CONTAINER) {
            void $this$forEach$iv;
            object = toPrint.valueAsContainer(parser);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Data it = (Data)element$iv;
                boolean bl = false;
                result.append(this.convertData(it, level + 1, parser)).append("\n");
            }
        } else {
            result.append(tabs + "Value:\t" + toPrint.valueAsString() + " - " + ByteHelperKt.toHexString((byte[])toPrint.getValue()) + "\n");
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

