/*
 * Decompiled with CFR 0.152.
 */
package de.jnkconsulting.e3dc.easyrscp.frame;

import de.jnkconsulting.e3dc.easyrscp.api.bytes.ByteHelperKt;
import de.jnkconsulting.e3dc.easyrscp.api.frame.Data;
import de.jnkconsulting.e3dc.easyrscp.api.frame.DataParser;
import de.jnkconsulting.e3dc.easyrscp.frame.DataBuilder;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0011"}, d2={"Lde/jnkconsulting/e3dc/easyrscp/frame/DefaultDataParser;", "Lde/jnkconsulting/e3dc/easyrscp/api/frame/DataParser;", "()V", "parseRSCPData", "", "Lde/jnkconsulting/e3dc/easyrscp/api/frame/Data;", "data", "", "readDataLength", "", "offset", "", "readSingleData", "readTag", "readType", "", "readValue", "jnk-easy-rscp-lowlevel"})
public final class DefaultDataParser
implements DataParser {
    @NotNull
    public List<Data> parseRSCPData(@NotNull byte[] data) {
        Data deserializedData;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        List result = new ArrayList();
        for (int bytesParsed = 0; bytesParsed < data.length; bytesParsed += deserializedData.asByteArray().length) {
            deserializedData = this.readSingleData(data, bytesParsed);
            result.add(deserializedData);
        }
        return result;
    }

    private final Data readSingleData(byte[] data, int offset) {
        return new DataBuilder().tag(this.readTag(data, offset)).raw(this.readValue(offset, data), this.readType(data, offset)).build();
    }

    private final byte[] readValue(int offset, byte[] data) {
        short valueLength = this.readDataLength(data, offset);
        int startOfDataSection = offset + ByteHelperKt.getPOSITIONS().getDataValueSection();
        return ArraysKt.sliceArray((byte[])data, (IntRange)new IntRange(startOfDataSection, startOfDataSection + valueLength - 1));
    }

    private final short readDataLength(byte[] data, int offset) {
        return ByteHelperKt.emptyByteBuffer((int)2).put(data, offset + ByteHelperKt.getPOSITIONS().getDataValueLength(), ByteHelperKt.getSIZES().getDataValueLengthSize()).flip().getShort();
    }

    private final byte readType(byte[] data, int offset) {
        return ArraysKt.reversedArray((byte[])ArraysKt.sliceArray((byte[])data, (IntRange)new IntRange(offset + ByteHelperKt.getPOSITIONS().getDataType(), offset + ByteHelperKt.getPOSITIONS().getDataValueLength() - 1)))[0];
    }

    private final byte[] readTag(byte[] data, int offset) {
        return ArraysKt.reversedArray((byte[])ArraysKt.sliceArray((byte[])data, (IntRange)new IntRange(offset, offset + ByteHelperKt.getSIZES().getDataTagSize() - 1)));
    }
}

