/*
 * Decompiled with CFR 0.152.
 */
package de.jnkconsulting.e3dc.easyrscp.frame;

import de.jnkconsulting.e3dc.easyrscp.api.bytes.ByteHelperKt;
import de.jnkconsulting.e3dc.easyrscp.api.frame.Data;
import de.jnkconsulting.e3dc.easyrscp.api.frame.DataType;
import de.jnkconsulting.e3dc.easyrscp.api.frame.Tag;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0004J\u001f\u0010\u0010\u001a\u00020\u00002\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0011\"\u00020\r\u00a2\u0006\u0002\u0010\u0012J\u0014\u0010\u0010\u001a\u00020\u00002\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\r0\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\rH\u0002J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0015H\u0002J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020 J\u0006\u0010!\u001a\u00020\u0000J\b\u0010\"\u001a\u00020\u0007H\u0002J\u0016\u0010#\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0004J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020&J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020'J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0007J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010)\u001a\u00020*J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010)\u001a\u00020+J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0004J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u001cJ\u000e\u0010.\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u001eJ\u000e\u0010/\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020 R\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lde/jnkconsulting/e3dc/easyrscp/frame/DataBuilder;", "", "()V", "dataType", "", "Ljava/lang/Byte;", "tag", "", "value", "bitfield", "bool", "", "build", "Lde/jnkconsulting/e3dc/easyrscp/api/frame/Data;", "bytearray", "char8", "container", "", "([Lde/jnkconsulting/e3dc/easyrscp/api/frame/Data;)Lde/jnkconsulting/e3dc/easyrscp/frame/DataBuilder;", "", "containerAdd", "", "double64", "", "ensureValueIsSet", "float32", "", "int16", "", "int32", "", "int64", "", "none", "nullSafeValue", "raw", "type", "string", "", "Lde/jnkconsulting/e3dc/easyrscp/api/frame/Tag;", "bytes", "timestamp", "Ljava/time/Duration;", "Ljava/time/Instant;", "uchar8", "uint16", "uint32", "uint64", "jnk-easy-rscp-lowlevel"})
@SourceDebugExtension(value={"SMAP\nDataBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataBuilder.kt\nde/jnkconsulting/e3dc/easyrscp/frame/DataBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,377:1\n1#2:378\n1855#3,2:379\n13309#4,2:381\n*S KotlinDebug\n*F\n+ 1 DataBuilder.kt\nde/jnkconsulting/e3dc/easyrscp/frame/DataBuilder\n*L\n317#1:379,2\n331#1:381,2\n*E\n"})
public final class DataBuilder {
    @Nullable
    private byte[] tag;
    @Nullable
    private Byte dataType;
    @Nullable
    private byte[] value;

    @NotNull
    public final DataBuilder tag(@NotNull byte[] bytes) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        byte[] it = byArray = bytes;
        boolean bl = false;
        this.tag = it;
        it = byArray;
        boolean bl2 = false;
        return this;
    }

    @NotNull
    public final DataBuilder tag(@NotNull Tag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Object it = tag;
        boolean bl = false;
        this.dataType = it.getType().getCode();
        it = ByteHelperKt.fromHexString((String)it.getHex());
        boolean bl2 = false;
        return this.tag((byte[])it);
    }

    @NotNull
    public final DataBuilder raw(@NotNull byte[] value, byte type) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        byte[] it = byArray = value;
        boolean bl = false;
        this.value = it;
        this.dataType = type;
        it = byArray;
        boolean bl2 = false;
        return this;
    }

    @NotNull
    public final DataBuilder timestamp(@NotNull Instant timestamp) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        byte[] it = ByteHelperKt.emptyByteBuffer((int)(ByteHelperKt.getSIZES().getTimestampEpochSeconds() + ByteHelperKt.getSIZES().getTimestampEpochNanos())).putLong(timestamp.getEpochSecond()).putInt(timestamp.getNano()).array();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return this.raw(it, DataType.TIMESTAMP.getCode());
    }

    @NotNull
    public final DataBuilder timestamp(@NotNull Duration timestamp) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Instant instant = Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNano());
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochSecond(...)");
        return this.timestamp(instant);
    }

    @NotNull
    public final DataBuilder none() {
        return this.raw(new byte[0], DataType.NONE.getCode());
    }

    @NotNull
    public final DataBuilder bool(boolean value) {
        byte[] byArray;
        byte[] it = byArray = new byte[1];
        boolean bl = false;
        it[0] = (byte)(value ? 1 : 0);
        it = byArray;
        boolean bl2 = false;
        return this.raw(it, DataType.BOOL.getCode());
    }

    @NotNull
    public final DataBuilder char8(byte value) {
        byte[] it = ByteHelperKt.emptyByteBuffer((int)1).put(value).array();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return this.raw(it, DataType.CHAR8.getCode());
    }

    @NotNull
    public final DataBuilder uchar8(byte value) {
        byte[] it = ByteHelperKt.emptyByteBuffer((int)1).put(value).array();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return this.raw(it, DataType.UCHAR8.getCode());
    }

    @NotNull
    public final DataBuilder int16(short value) {
        byte[] it = ByteHelperKt.emptyByteBuffer((int)2).putShort(value).array();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return this.raw(it, DataType.INT16.getCode());
    }

    @NotNull
    public final DataBuilder uint16(short value) {
        byte[] it = ByteHelperKt.emptyByteBuffer((int)2).putShort(value).array();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return this.raw(it, DataType.UINT16.getCode());
    }

    @NotNull
    public final DataBuilder int32(int value) {
        byte[] it = ByteHelperKt.emptyByteBuffer((int)4).putInt(value).array();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return this.raw(it, DataType.INT32.getCode());
    }

    @NotNull
    public final DataBuilder uint32(int value) {
        byte[] it = ByteHelperKt.emptyByteBuffer((int)4).putInt(value).array();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return this.raw(it, DataType.UINT32.getCode());
    }

    @NotNull
    public final DataBuilder int64(long value) {
        byte[] it = ByteHelperKt.emptyByteBuffer((int)8).putLong(value).array();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return this.raw(it, DataType.INT64.getCode());
    }

    @NotNull
    public final DataBuilder uint64(long value) {
        byte[] it = ByteHelperKt.emptyByteBuffer((int)8).putLong(value).array();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return this.raw(it, DataType.UINT64.getCode());
    }

    @NotNull
    public final DataBuilder float32(float value) {
        byte[] it = ByteHelperKt.emptyByteBuffer((int)4).putFloat(value).array();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return this.raw(it, DataType.FLOAT32.getCode());
    }

    @NotNull
    public final DataBuilder double64(double value) {
        byte[] it = ByteHelperKt.emptyByteBuffer((int)8).putDouble(value).array();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return this.raw(it, DataType.DOUBLE64.getCode());
    }

    @NotNull
    public final DataBuilder bitfield(byte value) {
        byte[] it = ByteHelperKt.emptyByteBuffer((int)1).put(value).array();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return this.raw(it, DataType.BITFIELD.getCode());
    }

    @NotNull
    public final DataBuilder string(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value;
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return this.raw(byArray, DataType.STRING.getCode());
    }

    @NotNull
    public final DataBuilder container(@NotNull List<Data> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Iterable $this$forEach$iv = value;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Data it = (Data)element$iv;
            boolean bl = false;
            this.containerAdd(it);
        }
        Unit it = Unit.INSTANCE;
        boolean bl = false;
        return this;
    }

    @NotNull
    public final DataBuilder container(Data ... value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Data[] $this$forEach$iv = value;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Data element$iv;
            Data it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.containerAdd(it);
        }
        Unit it = Unit.INSTANCE;
        boolean bl = false;
        return this;
    }

    private final void containerAdd(Data value) {
        this.value = ArraysKt.plus((byte[])this.nullSafeValue(), (byte[])value.asByteArray());
        this.dataType = DataType.CONTAINER.getCode();
    }

    @NotNull
    public final DataBuilder bytearray(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.raw(value, DataType.BYTEARRAY.getCode());
    }

    @NotNull
    public final Data build() {
        byte[] byArray;
        Object it = this.tag;
        boolean bl = false;
        if (it == null) {
            throw new IllegalStateException("tag is required");
        }
        it = byArray = it;
        boolean bl2 = false;
        this.ensureValueIsSet();
        it = byArray;
        boolean bl3 = false;
        if (this.value == null) {
            throw new IllegalStateException("value is required");
        }
        it = TuplesKt.to((Object)it, (Object)this.value);
        boolean bl4 = false;
        Byte by = this.dataType;
        if (by == null) {
            throw new IllegalStateException("dataType is required");
        }
        it = TuplesKt.to((Object)it, (Object)by);
        boolean bl5 = false;
        return new Data((byte[])((Pair)it.getFirst()).getFirst(), ((Number)it.getSecond()).byteValue(), (byte[])((Pair)it.getFirst()).getSecond());
    }

    private final void ensureValueIsSet() {
        if (this.value == null) {
            this.none();
        }
    }

    private final byte[] nullSafeValue() {
        byte[] byArray = this.value;
        if (this.value == null) {
            byArray = new byte[]{};
        }
        return byArray;
    }
}

