/*
 * Decompiled with CFR 0.152.
 */
package de.jnkconsulting.e3dc.easyrscp.connection;

import de.jnkconsulting.e3dc.easyrscp.api.connection.E3DCConnectionData;
import de.jnkconsulting.e3dc.easyrscp.api.connection.HomePowerPlantConnection;
import de.jnkconsulting.e3dc.easyrscp.api.connection.SocketFactory;
import de.jnkconsulting.e3dc.easyrscp.api.crypt.AESCipher;
import de.jnkconsulting.e3dc.easyrscp.api.crypt.AESCipherFactory;
import de.jnkconsulting.e3dc.easyrscp.api.frame.Frame;
import de.jnkconsulting.e3dc.easyrscp.api.frame.FrameParser;
import de.jnkconsulting.e3dc.easyrscp.connection.DefaultHomePowerPlantConnection;
import de.jnkconsulting.e3dc.easyrscp.connection.DefaultSocketFactory;
import de.jnkconsulting.e3dc.easyrscp.connection.RSCPAfterRequestSendEvent;
import de.jnkconsulting.e3dc.easyrscp.connection.RSCPAnswerDecryptedEvent;
import de.jnkconsulting.e3dc.easyrscp.connection.RSCPAnswerParsedEvent;
import de.jnkconsulting.e3dc.easyrscp.connection.RSCPAnswerReceivedEvent;
import de.jnkconsulting.e3dc.easyrscp.connection.RSCPBeforeRequestEncryptionEvent;
import de.jnkconsulting.e3dc.easyrscp.connection.RSCPBeforeRequestSendEvent;
import de.jnkconsulting.e3dc.easyrscp.connection.RSCPRequestResponseListener;
import de.jnkconsulting.e3dc.easyrscp.frame.DefaultDataParser;
import de.jnkconsulting.e3dc.easyrscp.frame.DefaultFrameParser;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\r\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001eH\u0002J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001cH\u0002J\u0018\u0010#\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001eH\u0002J\u0010\u0010%\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010&\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u001eH\u0002J\b\u0010(\u001a\u00020\u001eH\u0002J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010*\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lde/jnkconsulting/e3dc/easyrscp/connection/DefaultHomePowerPlantConnection;", "Lde/jnkconsulting/e3dc/easyrscp/api/connection/HomePowerPlantConnection;", "connectionData", "Lde/jnkconsulting/e3dc/easyrscp/api/connection/E3DCConnectionData;", "aesFactory", "Lde/jnkconsulting/e3dc/easyrscp/api/crypt/AESCipherFactory;", "socketFactory", "Lde/jnkconsulting/e3dc/easyrscp/api/connection/SocketFactory;", "frameParser", "Lde/jnkconsulting/e3dc/easyrscp/api/frame/FrameParser;", "listener", "", "Lde/jnkconsulting/e3dc/easyrscp/connection/RSCPRequestResponseListener;", "(Lde/jnkconsulting/e3dc/easyrscp/api/connection/E3DCConnectionData;Lde/jnkconsulting/e3dc/easyrscp/api/crypt/AESCipherFactory;Lde/jnkconsulting/e3dc/easyrscp/api/connection/SocketFactory;Lde/jnkconsulting/e3dc/easyrscp/api/frame/FrameParser;Ljava/util/List;)V", "aes", "Lde/jnkconsulting/e3dc/easyrscp/api/crypt/AESCipher;", "logger", "Lmu/KLogger;", "socket", "Ljava/net/Socket;", "close", "", "connect", "disconnect", "isConnected", "", "onAfterSend", "frame", "Lde/jnkconsulting/e3dc/easyrscp/api/frame/Frame;", "sentData", "", "onAnswerDecrypted", "decryptedAnswer", "onAnswerParsed", "answer", "onAnswerReceived", "encryptedAnswer", "onBeforeRequestEncryption", "onBeforeSend", "encryptedData", "readDataFromE3DC", "send", "sendAndReceive", "jnk-easy-rscp-lowlevel"})
@SourceDebugExtension(value={"SMAP\nDefaultHomePowerPlantConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultHomePowerPlantConnection.kt\nde/jnkconsulting/e3dc/easyrscp/connection/DefaultHomePowerPlantConnection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n1#2:165\n1855#3,2:166\n1855#3,2:168\n1855#3,2:170\n1855#3,2:172\n1855#3,2:174\n1855#3,2:176\n*S KotlinDebug\n*F\n+ 1 DefaultHomePowerPlantConnection.kt\nde/jnkconsulting/e3dc/easyrscp/connection/DefaultHomePowerPlantConnection\n*L\n94#1:166,2\n103#1:168,2\n112#1:170,2\n121#1:172,2\n130#1:174,2\n139#1:176,2\n*E\n"})
public final class DefaultHomePowerPlantConnection
implements HomePowerPlantConnection {
    @NotNull
    private final E3DCConnectionData connectionData;
    @NotNull
    private final SocketFactory socketFactory;
    @NotNull
    private final FrameParser frameParser;
    @NotNull
    private final List<RSCPRequestResponseListener> listener;
    @NotNull
    private final KLogger logger;
    @Nullable
    private Socket socket;
    @NotNull
    private final AESCipher aes;

    public DefaultHomePowerPlantConnection(@NotNull E3DCConnectionData connectionData, @NotNull AESCipherFactory aesFactory, @NotNull SocketFactory socketFactory, @NotNull FrameParser frameParser, @NotNull List<? extends RSCPRequestResponseListener> listener) {
        Intrinsics.checkNotNullParameter((Object)connectionData, (String)"connectionData");
        Intrinsics.checkNotNullParameter((Object)aesFactory, (String)"aesFactory");
        Intrinsics.checkNotNullParameter((Object)socketFactory, (String)"socketFactory");
        Intrinsics.checkNotNullParameter((Object)frameParser, (String)"frameParser");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.connectionData = connectionData;
        this.socketFactory = socketFactory;
        this.frameParser = frameParser;
        this.listener = listener;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.aes = aesFactory.buildCipher();
    }

    public /* synthetic */ DefaultHomePowerPlantConnection(E3DCConnectionData e3DCConnectionData, AESCipherFactory aESCipherFactory, SocketFactory socketFactory, FrameParser frameParser, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            socketFactory = new DefaultSocketFactory();
        }
        if ((n & 8) != 0) {
            frameParser = new DefaultFrameParser(new DefaultDataParser());
        }
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(e3DCConnectionData, aESCipherFactory, socketFactory, frameParser, list);
    }

    public void connect() {
        if (this.isConnected()) {
            this.logger.trace((Function0)connect.1.INSTANCE);
        } else {
            this.logger.trace((Function0)new Function0<Object>(this){
                final /* synthetic */ DefaultHomePowerPlantConnection this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Open connection to " + DefaultHomePowerPlantConnection.access$getConnectionData$p(this.this$0) + ".";
                }
            });
            this.socket = this.socketFactory.createSocket(this.connectionData);
            this.logger.trace((Function0)new Function0<Object>(this){
                final /* synthetic */ DefaultHomePowerPlantConnection this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Connection to " + DefaultHomePowerPlantConnection.access$getConnectionData$p(this.this$0) + " established.";
                }
            });
        }
    }

    public void disconnect() {
        if (this.isConnected()) {
            this.logger.trace((Function0)new Function0<Object>(this){
                final /* synthetic */ DefaultHomePowerPlantConnection this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Close the connection to " + DefaultHomePowerPlantConnection.access$getConnectionData$p(this.this$0) + ".";
                }
            });
            Socket socket = this.socket;
            if (socket != null) {
                socket.close();
            }
        } else {
            this.logger.trace((Function0)new Function0<Object>(this){
                final /* synthetic */ DefaultHomePowerPlantConnection this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Connection to " + DefaultHomePowerPlantConnection.access$getConnectionData$p(this.this$0) + " has already been closed.";
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConnected() {
        if (this.socket == null) return false;
        Socket socket = this.socket;
        Intrinsics.checkNotNull((Object)socket);
        if (!socket.isConnected()) return false;
        return true;
    }

    @NotNull
    public Frame send(@NotNull Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        boolean bl = this.isConnected();
        if (!bl) {
            if (!bl) {
                String string;
                String it = string = "Connection not established. First call connect().";
                boolean bl2 = false;
                this.logger.error((Function0)new Function0<Object>(it){
                    final /* synthetic */ String $it;
                    {
                        this.$it = $it;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return this.$it;
                    }
                });
                it = string;
                boolean bl3 = false;
                throw (Throwable)new IllegalStateException(it);
            }
            throw new NoWhenBranchMatchedException();
        }
        return this.sendAndReceive(frame);
    }

    private final Frame sendAndReceive(Frame frame) {
        Object object;
        Frame it = object = frame;
        boolean bl = false;
        this.onBeforeRequestEncryption(frame);
        it = object;
        boolean bl2 = false;
        it = object = (Object)this.aes.encrypt(frame.asByteArray());
        boolean bl3 = false;
        this.onBeforeSend(frame, (byte[])it);
        it = object;
        boolean bl4 = false;
        Socket socket = this.socket;
        Intrinsics.checkNotNull((Object)socket);
        DataOutputStream $this$sendAndReceive_u24lambda_u246_u24lambda_u245 = new DataOutputStream(socket.getOutputStream());
        boolean bl5 = false;
        $this$sendAndReceive_u24lambda_u246_u24lambda_u245.write((byte[])it);
        $this$sendAndReceive_u24lambda_u246_u24lambda_u245.flush();
        it = object;
        boolean bl6 = false;
        this.onAfterSend(frame, (byte[])it);
        it = object;
        boolean bl7 = false;
        it = object = (Object)this.readDataFromE3DC();
        boolean bl8 = false;
        this.onAnswerReceived(frame, (byte[])it);
        it = object;
        boolean bl9 = false;
        it = object = (Object)this.aes.decrypt((byte[])it);
        boolean bl10 = false;
        this.onAnswerDecrypted(frame, (byte[])it);
        it = object;
        boolean bl11 = false;
        it = object = this.frameParser.parseRSCPFrame((byte[])it);
        boolean bl12 = false;
        this.onAnswerParsed(frame, it);
        return object;
    }

    private final void onBeforeRequestEncryption(Frame frame) {
        this.logger.trace((Function0)new Function0<Object>(frame){
            final /* synthetic */ Frame $frame;
            {
                this.$frame = $frame;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Encrypt frame: " + this.$frame;
            }
        });
        RSCPBeforeRequestEncryptionEvent event = new RSCPBeforeRequestEncryptionEvent(frame);
        Iterable $this$forEach$iv = this.listener;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RSCPRequestResponseListener it = (RSCPRequestResponseListener)element$iv;
            boolean bl = false;
            it.onRSCPRequestResponseEvent(event);
            it.onBeforeRequestFrameEncryption(event);
        }
    }

    private final void onBeforeSend(Frame frame, byte[] encryptedData) {
        this.logger.trace((Function0)new Function0<Object>(encryptedData, this){
            final /* synthetic */ byte[] $encryptedData;
            final /* synthetic */ DefaultHomePowerPlantConnection this$0;
            {
                this.$encryptedData = $encryptedData;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Encryption successful. Send " + this.$encryptedData.length + " bytes to " + DefaultHomePowerPlantConnection.access$getConnectionData$p(this.this$0) + ".";
            }
        });
        RSCPBeforeRequestSendEvent event = new RSCPBeforeRequestSendEvent(frame, encryptedData);
        Iterable $this$forEach$iv = this.listener;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RSCPRequestResponseListener it = (RSCPRequestResponseListener)element$iv;
            boolean bl = false;
            it.onRSCPRequestResponseEvent(event);
            it.onBeforeRequestSend(event);
        }
    }

    private final void onAfterSend(Frame frame, byte[] sentData) {
        this.logger.trace((Function0)onAfterSend.1.INSTANCE);
        RSCPAfterRequestSendEvent event = new RSCPAfterRequestSendEvent(frame, sentData);
        Iterable $this$forEach$iv = this.listener;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RSCPRequestResponseListener it = (RSCPRequestResponseListener)element$iv;
            boolean bl = false;
            it.onRSCPRequestResponseEvent(event);
            it.onAfterRequestSend(event);
        }
    }

    private final void onAnswerReceived(Frame frame, byte[] encryptedAnswer) {
        this.logger.trace((Function0)new Function0<Object>(encryptedAnswer){
            final /* synthetic */ byte[] $encryptedAnswer;
            {
                this.$encryptedAnswer = $encryptedAnswer;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return this.$encryptedAnswer.length + " bytes Received. Decrypt data.";
            }
        });
        RSCPAnswerReceivedEvent event = new RSCPAnswerReceivedEvent(frame, encryptedAnswer);
        Iterable $this$forEach$iv = this.listener;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RSCPRequestResponseListener it = (RSCPRequestResponseListener)element$iv;
            boolean bl = false;
            it.onRSCPRequestResponseEvent(event);
            it.onAnswerReceived(event);
        }
    }

    private final void onAnswerDecrypted(Frame frame, byte[] decryptedAnswer) {
        this.logger.trace((Function0)onAnswerDecrypted.1.INSTANCE);
        RSCPAnswerDecryptedEvent event = new RSCPAnswerDecryptedEvent(frame, decryptedAnswer);
        Iterable $this$forEach$iv = this.listener;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RSCPRequestResponseListener it = (RSCPRequestResponseListener)element$iv;
            boolean bl = false;
            it.onRSCPRequestResponseEvent(event);
            it.onAnswerDecrypted(event);
        }
    }

    private final void onAnswerParsed(Frame frame, Frame answer) {
        this.logger.trace((Function0)new Function0<Object>(answer){
            final /* synthetic */ Frame $answer;
            {
                this.$answer = $answer;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Parsing of the frame successful: " + this.$answer;
            }
        });
        RSCPAnswerParsedEvent event = new RSCPAnswerParsedEvent(frame, answer);
        Iterable $this$forEach$iv = this.listener;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RSCPRequestResponseListener it = (RSCPRequestResponseListener)element$iv;
            boolean bl = false;
            it.onRSCPRequestResponseEvent(event);
            it.onAnswerParsed(event);
        }
    }

    private final byte[] readDataFromE3DC() {
        Socket socket = this.socket;
        Intrinsics.checkNotNull((Object)socket);
        DataInputStream streamIn = new DataInputStream(socket.getInputStream());
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] currentBlock = new byte[4096];
        do {
            int bytesRead;
            if ((bytesRead = streamIn.read(currentBlock, 0, currentBlock.length)) == -1) {
                this.logger.error((Function0)readDataFromE3DC.1.INSTANCE);
                throw new IllegalStateException("Error reading the response. This can happen among other things if the e3dc system has terminated the connection or the authentication has failed.");
            }
            buffer.write(currentBlock, 0, bytesRead);
        } while (streamIn.available() > 0);
        byte[] byArray = buffer.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    public void close() {
        this.disconnect();
    }

    public static final /* synthetic */ E3DCConnectionData access$getConnectionData$p(DefaultHomePowerPlantConnection $this) {
        return $this.connectionData;
    }
}

