/*
 * Decompiled with CFR 0.152.
 */
package de.jnkconsulting.e3dc.easyrscp.connection;

import de.jnkconsulting.e3dc.easyrscp.api.connection.ConnectionPool;
import de.jnkconsulting.e3dc.easyrscp.api.connection.E3DCConnectionData;
import de.jnkconsulting.e3dc.easyrscp.api.connection.HomePowerPlantConnectionFactory;
import de.jnkconsulting.e3dc.easyrscp.api.connection.SocketFactory;
import de.jnkconsulting.e3dc.easyrscp.api.crypt.AESCipherFactory;
import de.jnkconsulting.e3dc.easyrscp.api.frame.FrameParser;
import de.jnkconsulting.e3dc.easyrscp.connection.DefaultHomePowerPlantConnectionFactory;
import de.jnkconsulting.e3dc.easyrscp.connection.DefaultSocketFactory;
import de.jnkconsulting.e3dc.easyrscp.connection.RSCPRequestResponseListener;
import de.jnkconsulting.e3dc.easyrscp.connection.SingleInstanceConnectionPool;
import de.jnkconsulting.e3dc.easyrscp.crypt.BouncyCastleAESCipherFactory;
import de.jnkconsulting.e3dc.easyrscp.frame.DefaultDataParser;
import de.jnkconsulting.e3dc.easyrscp.frame.DefaultFrameParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0018\u001a\u00020\u00002\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001a\"\u00020\u0013\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u0006J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\bJ\b\u0010\"\u001a\u00020\fH\u0002J\b\u0010#\u001a\u00020\u0006H\u0002J\b\u0010$\u001a\u00020\bH\u0002J\b\u0010%\u001a\u00020\fH\u0002J\b\u0010&\u001a\u00020\u0016H\u0002J\u0006\u0010'\u001a\u00020\u0016J\b\u0010(\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020)H\u0002J\u0018\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u0004H\u0002J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010/\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u00100\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u00020\nJ\u000e\u00103\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u00104\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u00105\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u00106\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u00107\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u00108\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u00109\u001a\u00020\u00002\u0006\u00102\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lde/jnkconsulting/e3dc/easyrscp/connection/ConnectionBuilder;", "", "()V", "address", "", "cipherFactory", "Lde/jnkconsulting/e3dc/easyrscp/api/crypt/AESCipherFactory;", "connectionPool", "Lde/jnkconsulting/e3dc/easyrscp/api/connection/ConnectionPool;", "connectionPoolTimeoutMillis", "", "frameParser", "Lde/jnkconsulting/e3dc/easyrscp/api/frame/FrameParser;", "port", "", "portalPassword", "portalUser", "requestResponseListener", "", "Lde/jnkconsulting/e3dc/easyrscp/connection/RSCPRequestResponseListener;", "rscpPassword", "socketFactory", "Lde/jnkconsulting/e3dc/easyrscp/api/connection/SocketFactory;", "socketTimeoutMillis", "addRequestResponseListener", "listener", "", "([Lde/jnkconsulting/e3dc/easyrscp/connection/RSCPRequestResponseListener;)Lde/jnkconsulting/e3dc/easyrscp/connection/ConnectionBuilder;", "buildCipherFactory", "buildConnectionData", "Lde/jnkconsulting/e3dc/easyrscp/api/connection/E3DCConnectionData;", "buildConnectionFactory", "Lde/jnkconsulting/e3dc/easyrscp/api/connection/HomePowerPlantConnectionFactory;", "buildConnectionPool", "buildFrameParser", "buildOwnCipherFactor", "buildOwnConnectionPool", "buildOwnFrameParser", "buildOwnSocketFactory", "buildSocketFactory", "validateForCipher", "", "validateForConnectionData", "validateMandatoryStringParameter", "value", "parameter", "withAddress", "withCipherFactory", "withConnectionPool", "withConnectionPoolTimeoutMillis", "timeout", "withFrameParser", "withPort", "withPortalPassword", "withPortalUser", "withRSCPPassword", "withSocketFactory", "withSocketTimeoutMillis", "jnk-easy-rscp-lowlevel"})
@SourceDebugExtension(value={"SMAP\nConnectionBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectionBuilder.kt\nde/jnkconsulting/e3dc/easyrscp/connection/ConnectionBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,331:1\n1#2:332\n*E\n"})
public final class ConnectionBuilder {
    @NotNull
    private String address = "";
    private int port = 5033;
    @NotNull
    private String portalUser = "";
    @NotNull
    private String rscpPassword = "";
    @NotNull
    private String portalPassword = "";
    private long socketTimeoutMillis = 10000L;
    @Nullable
    private AESCipherFactory cipherFactory;
    @Nullable
    private SocketFactory socketFactory;
    @Nullable
    private FrameParser frameParser;
    @NotNull
    private final List<RSCPRequestResponseListener> requestResponseListener = new ArrayList();
    @Nullable
    private ConnectionPool connectionPool;
    private long connectionPoolTimeoutMillis = 10000L;

    private final void validateForConnectionData() {
        this.validateMandatoryStringParameter(this.address, "address");
        this.validateMandatoryStringParameter(this.portalUser, "portalUser");
        this.validateMandatoryStringParameter(this.rscpPassword, "rscpPassword");
        this.validateMandatoryStringParameter(this.portalPassword, "portalPassword");
    }

    private final void validateForCipher() {
        this.validateMandatoryStringParameter(this.rscpPassword, "rscpPassword");
    }

    private final void validateMandatoryStringParameter(String value, String parameter) {
        if (StringsKt.isBlank((CharSequence)value)) {
            throw new IllegalStateException(parameter + " is a mandatory information");
        }
    }

    @NotNull
    public final ConnectionBuilder withAddress(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        String it = address;
        boolean bl = false;
        this.address = it;
        return this;
    }

    @NotNull
    public final ConnectionBuilder withPort(int port) {
        int it = port;
        boolean bl = false;
        this.port = it;
        return this;
    }

    @NotNull
    public final ConnectionBuilder withPortalUser(@NotNull String portalUser) {
        Intrinsics.checkNotNullParameter((Object)portalUser, (String)"portalUser");
        String it = portalUser;
        boolean bl = false;
        this.portalUser = it;
        return this;
    }

    @NotNull
    public final ConnectionBuilder withPortalPassword(@NotNull String portalPassword) {
        Intrinsics.checkNotNullParameter((Object)portalPassword, (String)"portalPassword");
        String it = portalPassword;
        boolean bl = false;
        this.portalPassword = it;
        return this;
    }

    @NotNull
    public final ConnectionBuilder withRSCPPassword(@NotNull String rscpPassword) {
        Intrinsics.checkNotNullParameter((Object)rscpPassword, (String)"rscpPassword");
        String it = rscpPassword;
        boolean bl = false;
        this.rscpPassword = it;
        return this;
    }

    @NotNull
    public final ConnectionBuilder withCipherFactory(@NotNull AESCipherFactory cipherFactory) {
        Intrinsics.checkNotNullParameter((Object)cipherFactory, (String)"cipherFactory");
        AESCipherFactory it = cipherFactory;
        boolean bl = false;
        this.cipherFactory = it;
        return this;
    }

    @NotNull
    public final ConnectionBuilder withSocketTimeoutMillis(long timeout) {
        long it = timeout;
        boolean bl = false;
        this.socketTimeoutMillis = it;
        return this;
    }

    @NotNull
    public final ConnectionBuilder withSocketFactory(@NotNull SocketFactory socketFactory) {
        Intrinsics.checkNotNullParameter((Object)socketFactory, (String)"socketFactory");
        SocketFactory it = socketFactory;
        boolean bl = false;
        this.socketFactory = it;
        return this;
    }

    @NotNull
    public final ConnectionBuilder withFrameParser(@NotNull FrameParser frameParser) {
        Intrinsics.checkNotNullParameter((Object)frameParser, (String)"frameParser");
        FrameParser it = frameParser;
        boolean bl = false;
        this.frameParser = it;
        return this;
    }

    @NotNull
    public final ConnectionBuilder withConnectionPool(@NotNull ConnectionPool connectionPool) {
        Intrinsics.checkNotNullParameter((Object)connectionPool, (String)"connectionPool");
        ConnectionPool it = connectionPool;
        boolean bl = false;
        this.connectionPool = it;
        return this;
    }

    @NotNull
    public final ConnectionBuilder withConnectionPoolTimeoutMillis(long timeout) {
        long it = timeout;
        boolean bl = false;
        this.connectionPoolTimeoutMillis = it;
        return this;
    }

    @NotNull
    public final ConnectionBuilder addRequestResponseListener(RSCPRequestResponseListener ... listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        boolean it = CollectionsKt.addAll((Collection)this.requestResponseListener, (Object[])listener);
        boolean bl = false;
        return this;
    }

    @NotNull
    public final HomePowerPlantConnectionFactory buildConnectionFactory() {
        return new DefaultHomePowerPlantConnectionFactory(this.buildConnectionData(), this.buildCipherFactory(), this.buildSocketFactory(), this.buildFrameParser(), this.requestResponseListener);
    }

    @NotNull
    public final E3DCConnectionData buildConnectionData() {
        this.validateForConnectionData();
        return new E3DCConnectionData(this.address, this.port, this.portalUser, this.portalPassword, this.rscpPassword, this.socketTimeoutMillis);
    }

    @NotNull
    public final AESCipherFactory buildCipherFactory() {
        AESCipherFactory aESCipherFactory = this.cipherFactory;
        if (aESCipherFactory == null) {
            aESCipherFactory = this.buildOwnCipherFactor();
        }
        return aESCipherFactory;
    }

    @NotNull
    public final SocketFactory buildSocketFactory() {
        SocketFactory socketFactory = this.socketFactory;
        if (socketFactory == null) {
            socketFactory = this.buildOwnSocketFactory();
        }
        return socketFactory;
    }

    @NotNull
    public final ConnectionPool buildConnectionPool() {
        ConnectionPool connectionPool = this.connectionPool;
        if (connectionPool == null) {
            connectionPool = this.buildOwnConnectionPool();
        }
        return connectionPool;
    }

    private final ConnectionPool buildOwnConnectionPool() {
        return new SingleInstanceConnectionPool(this.buildConnectionFactory(), this.connectionPoolTimeoutMillis);
    }

    private final SocketFactory buildOwnSocketFactory() {
        return new DefaultSocketFactory();
    }

    private final AESCipherFactory buildOwnCipherFactor() {
        this.validateForCipher();
        return new BouncyCastleAESCipherFactory(this.rscpPassword);
    }

    private final FrameParser buildFrameParser() {
        FrameParser frameParser = this.frameParser;
        if (frameParser == null) {
            frameParser = this.buildOwnFrameParser();
        }
        return frameParser;
    }

    private final FrameParser buildOwnFrameParser() {
        return new DefaultFrameParser(new DefaultDataParser());
    }
}

