/*
 * Decompiled with CFR 0.152.
 */
package de.jnkconsulting.e3dc.easyrscp.frame;

import de.jnkconsulting.e3dc.easyrscp.api.bytes.ByteHelperKt;
import de.jnkconsulting.e3dc.easyrscp.api.frame.Data;
import de.jnkconsulting.e3dc.easyrscp.api.frame.DataParser;
import de.jnkconsulting.e3dc.easyrscp.api.frame.Frame;
import de.jnkconsulting.e3dc.easyrscp.frame.DefaultDataParser;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0007J\u001f\u0010\f\u001a\u00020\u00002\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u000e\"\u00020\u0007\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\f\u001a\u00020\u00002\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0000J\u0006\u0010\u0014\u001a\u00020\u0000J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/jnkconsulting/e3dc/easyrscp/frame/FrameBuilder;", "", "()V", "controlBytes", "", "data", "", "Lde/jnkconsulting/e3dc/easyrscp/api/frame/Data;", "parser", "Lde/jnkconsulting/e3dc/easyrscp/api/frame/DataParser;", "timestamp", "Ljava/time/Instant;", "addData", "toAdd", "", "([Lde/jnkconsulting/e3dc/easyrscp/api/frame/Data;)Lde/jnkconsulting/e3dc/easyrscp/frame/FrameBuilder;", "", "build", "Lde/jnkconsulting/e3dc/easyrscp/api/frame/Frame;", "disableChecksum", "enableChecksum", "withChecksumEnabled", "enabled", "", "withParser", "jnk-easy-rscp-lowlevel"})
@SourceDebugExtension(value={"SMAP\nFrameBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameBuilder.kt\nde/jnkconsulting/e3dc/easyrscp/frame/FrameBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1#2:147\n*E\n"})
public final class FrameBuilder {
    @Nullable
    private Instant timestamp;
    @NotNull
    private List<Data> data = new ArrayList();
    @NotNull
    private byte[] controlBytes = ByteHelperKt.getFIXED_VALUES().getControlBytesWithChecksum();
    @NotNull
    private DataParser parser = new DefaultDataParser();

    @NotNull
    public final FrameBuilder withParser(@NotNull DataParser parser) {
        DataParser dataParser;
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        DataParser it = dataParser = parser;
        boolean bl = false;
        this.parser = it;
        it = dataParser;
        boolean bl2 = false;
        return this;
    }

    @NotNull
    public final FrameBuilder timestamp(@NotNull Instant timestamp) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Instant it = instant = timestamp;
        boolean bl = false;
        this.timestamp = it;
        it = instant;
        boolean bl2 = false;
        return this;
    }

    @NotNull
    public final FrameBuilder addData(@NotNull Data toAdd) {
        Intrinsics.checkNotNullParameter((Object)toAdd, (String)"toAdd");
        boolean it = this.data.add(toAdd);
        boolean bl = false;
        return this;
    }

    @NotNull
    public final FrameBuilder addData(@NotNull Collection<Data> toAdd) {
        Intrinsics.checkNotNullParameter(toAdd, (String)"toAdd");
        boolean it = this.data.addAll(toAdd);
        boolean bl = false;
        return this;
    }

    @NotNull
    public final FrameBuilder addData(Data ... toAdd) {
        Intrinsics.checkNotNullParameter((Object)toAdd, (String)"toAdd");
        boolean it = CollectionsKt.addAll((Collection)this.data, (Object[])toAdd);
        boolean bl = false;
        return this;
    }

    @NotNull
    public final FrameBuilder enableChecksum() {
        FrameBuilder frameBuilder;
        FrameBuilder it = frameBuilder = this;
        boolean bl = false;
        this.controlBytes = ByteHelperKt.getFIXED_VALUES().getControlBytesWithChecksum();
        return frameBuilder;
    }

    @NotNull
    public final FrameBuilder disableChecksum() {
        FrameBuilder frameBuilder;
        FrameBuilder it = frameBuilder = this;
        boolean bl = false;
        this.controlBytes = ByteHelperKt.getFIXED_VALUES().getControlBytesWithoutChecksum();
        return frameBuilder;
    }

    @NotNull
    public final FrameBuilder withChecksumEnabled(boolean enabled) {
        FrameBuilder frameBuilder;
        boolean bl = enabled;
        if (bl) {
            frameBuilder = this.enableChecksum();
        } else if (!bl) {
            frameBuilder = this.disableChecksum();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return frameBuilder;
    }

    @NotNull
    public final Frame build() {
        Instant instant = this.timestamp;
        if (instant == null) {
            instant = Instant.now();
        }
        Instant instant2 = instant;
        Intrinsics.checkNotNull((Object)instant2);
        return new Frame(instant2, this.controlBytes, this.data, this.parser);
    }
}

