/*
 * Decompiled with CFR 0.152.
 */
package de.jnkconsulting.e3dc.easyrscp.frame;

import de.jnkconsulting.e3dc.easyrscp.api.bytes.ByteHelperKt;
import de.jnkconsulting.e3dc.easyrscp.api.frame.DataParser;
import de.jnkconsulting.e3dc.easyrscp.api.frame.Frame;
import de.jnkconsulting.e3dc.easyrscp.api.frame.FrameParser;
import de.jnkconsulting.e3dc.easyrscp.frame.FrameBuilder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/jnkconsulting/e3dc/easyrscp/frame/DefaultFrameParser;", "Lde/jnkconsulting/e3dc/easyrscp/api/frame/FrameParser;", "dataParser", "Lde/jnkconsulting/e3dc/easyrscp/api/frame/DataParser;", "(Lde/jnkconsulting/e3dc/easyrscp/api/frame/DataParser;)V", "isChecksumsEnabled", "", "frameBuffer", "Ljava/nio/ByteBuffer;", "parseRSCPFrame", "Lde/jnkconsulting/e3dc/easyrscp/api/frame/Frame;", "frame", "", "readControlBytes", "readDataSection", "readDataSectionLength", "", "readTimestamp", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "jnk-easy-rscp-lowlevel"})
@SourceDebugExtension(value={"SMAP\nDefaultFrameParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultFrameParser.kt\nde/jnkconsulting/e3dc/easyrscp/frame/DefaultFrameParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
public final class DefaultFrameParser
implements FrameParser {
    @NotNull
    private final DataParser dataParser;

    public DefaultFrameParser(@NotNull DataParser dataParser) {
        Intrinsics.checkNotNullParameter((Object)dataParser, (String)"dataParser");
        this.dataParser = dataParser;
    }

    @NotNull
    public Frame parseRSCPFrame(@NotNull byte[] frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        FrameBuilder frameBuilder = new FrameBuilder();
        ByteBuffer frameBuffer = ByteBuffer.wrap(frame).order(ByteOrder.LITTLE_ENDIAN).rewind();
        Intrinsics.checkNotNull((Object)frameBuffer);
        boolean checksumEnabled = this.isChecksumsEnabled(frameBuffer);
        Instant timestamp = this.readTimestamp(frameBuffer);
        byte[] data = this.readDataSection(frameBuffer);
        Intrinsics.checkNotNull((Object)timestamp);
        return frameBuilder.timestamp(timestamp).withChecksumEnabled(checksumEnabled).addData(this.dataParser.parseRSCPData(data)).build();
    }

    private final byte[] readDataSection(ByteBuffer frameBuffer) {
        byte[] byArray;
        short dataSectionLength = this.readDataSectionLength(frameBuffer);
        boolean bl = false;
        byte[] it = byArray = new byte[dataSectionLength];
        boolean bl2 = false;
        frameBuffer.position(ByteHelperKt.getPOSITIONS().getFrameDataSection()).get(it, 0, dataSectionLength);
        return byArray;
    }

    private final short readDataSectionLength(ByteBuffer frameBuffer) {
        return frameBuffer.getShort(ByteHelperKt.getPOSITIONS().getFrameHeaderDataLength());
    }

    private final boolean isChecksumsEnabled(ByteBuffer frameBuffer) {
        byte[] it = this.readControlBytes(frameBuffer);
        boolean bl = false;
        return it[1] == 17;
    }

    private final byte[] readControlBytes(ByteBuffer frameBuffer) {
        byte[] byArray;
        byte[] it = byArray = new byte[ByteHelperKt.getSIZES().getFrameHeaderControlBytes()];
        boolean bl = false;
        frameBuffer.position(ByteHelperKt.getPOSITIONS().getFrameHeaderControlBytes()).get(it, 0, ByteHelperKt.getSIZES().getFrameHeaderControlBytes());
        return byArray;
    }

    private final Instant readTimestamp(ByteBuffer frameBuffer) {
        return Instant.ofEpochSecond(frameBuffer.getLong(ByteHelperKt.getPOSITIONS().getFrameHeaderTimestampEpochSeconds()), frameBuffer.getInt(ByteHelperKt.getPOSITIONS().getFrameHeaderTimestampEpochNanos()));
    }
}

