/*
 * Decompiled with CFR 0.152.
 */
package de.jnkconsulting.e3dc.easyrscp.crypt;

import de.jnkconsulting.e3dc.easyrscp.api.crypt.AESCipher;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.RijndaelEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.paddings.ZeroBytePadding;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/jnkconsulting/e3dc/easyrscp/crypt/BouncyCastleAESCipher;", "Lde/jnkconsulting/e3dc/easyrscp/api/crypt/AESCipher;", "rscpPassword", "", "(Ljava/lang/String;)V", "blockSize", "", "ivDecryption", "", "ivEncryption", "key", "createCipher", "Lorg/bouncycastle/crypto/paddings/PaddedBufferedBlockCipher;", "forEncryption", "", "iv", "decrypt", "message", "encrypt", "updateIv", "", "source", "jnk-easy-rscp-lowlevel"})
@SourceDebugExtension(value={"SMAP\nBouncyCastleAESCipher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BouncyCastleAESCipher.kt\nde/jnkconsulting/e3dc/easyrscp/crypt/BouncyCastleAESCipher\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,85:1\n13384#2,3:86\n*S KotlinDebug\n*F\n+ 1 BouncyCastleAESCipher.kt\nde/jnkconsulting/e3dc/easyrscp/crypt/BouncyCastleAESCipher\n*L\n28#1:86,3\n*E\n"})
public final class BouncyCastleAESCipher
implements AESCipher {
    private final int blockSize;
    @NotNull
    private final byte[] ivEncryption;
    @NotNull
    private final byte[] ivDecryption;
    @NotNull
    private final byte[] key;

    /*
     * WARNING - void declaration
     */
    public BouncyCastleAESCipher(@NotNull String rscpPassword) {
        void $this$key_u24lambda_u243;
        byte[] $this$ivDecryption_u24lambda_u241;
        byte[] $this$ivEncryption_u24lambda_u240;
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)rscpPassword, (String)"rscpPassword");
        this.blockSize = 256;
        byte[] byArray2 = byArray = new byte[32];
        BouncyCastleAESCipher bouncyCastleAESCipher = this;
        boolean bl = false;
        Arrays.fill($this$ivEncryption_u24lambda_u240, (byte)-1);
        bouncyCastleAESCipher.ivEncryption = byArray;
        $this$ivEncryption_u24lambda_u240 = byArray = new byte[32];
        bouncyCastleAESCipher = this;
        boolean bl2 = false;
        Arrays.fill($this$ivDecryption_u24lambda_u241, (byte)-1);
        bouncyCastleAESCipher.ivDecryption = byArray;
        $this$ivDecryption_u24lambda_u241 = byArray = new byte[32];
        bouncyCastleAESCipher = this;
        boolean bl3 = false;
        byte[] byArray3 = rscpPassword.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"this as java.lang.String).getBytes(charset)");
        byte[] passwordBytes = byArray3;
        void $this$forEachIndexed$iv = $this$key_u24lambda_u243;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (void item$iv : $this$forEachIndexed$iv) {
            int index = index$iv++;
            boolean bl4 = false;
            if (index < passwordBytes.length) {
                $this$key_u24lambda_u243[index] = passwordBytes[index];
                continue;
            }
            $this$key_u24lambda_u243[index] = -1;
        }
        bouncyCastleAESCipher.key = byArray;
    }

    @NotNull
    public byte[] encrypt(@NotNull byte[] message) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        PaddedBufferedBlockCipher it = this.createCipher(true, this.ivEncryption);
        boolean bl = false;
        byte[] $this$encrypt_u24lambda_u245_u24lambda_u244 = byArray = new byte[it.getOutputSize(message.length)];
        boolean bl2 = false;
        int len = it.processBytes(message, 0, message.length, $this$encrypt_u24lambda_u245_u24lambda_u244, 0);
        it.doFinal($this$encrypt_u24lambda_u245_u24lambda_u244, len);
        this.updateIv($this$encrypt_u24lambda_u245_u24lambda_u244, this.ivEncryption);
        return byArray;
    }

    @NotNull
    public byte[] decrypt(@NotNull byte[] message) {
        int lastZeroIdx;
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        PaddedBufferedBlockCipher paddedBuffer = this.createCipher(false, this.ivDecryption);
        boolean bl = false;
        byte[] $this$decrypt_u24lambda_u248_u24lambda_u246 = byArray = new byte[paddedBuffer.getOutputSize(message.length)];
        boolean bl2 = false;
        int len = paddedBuffer.processBytes(message, 0, message.length, $this$decrypt_u24lambda_u248_u24lambda_u246, 0);
        paddedBuffer.doFinal($this$decrypt_u24lambda_u248_u24lambda_u246, len);
        this.updateIv(message, this.ivDecryption);
        byte[] it = byArray;
        boolean bl3 = false;
        for (lastZeroIdx = it.length - 1; lastZeroIdx >= 0 && it[lastZeroIdx] == 0; --lastZeroIdx) {
        }
        byte[] byArray2 = Arrays.copyOf(it, lastZeroIdx + 1);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(this, newSize)");
        return byArray2;
    }

    private final void updateIv(byte[] source, byte[] iv) {
        System.arraycopy(source, source.length - iv.length, iv, 0, iv.length);
    }

    private final PaddedBufferedBlockCipher createCipher(boolean forEncryption, byte[] iv) {
        PaddedBufferedBlockCipher paddedBufferedBlockCipher;
        PaddedBufferedBlockCipher it = paddedBufferedBlockCipher = new PaddedBufferedBlockCipher((BlockCipher)CBCBlockCipher.newInstance((BlockCipher)((BlockCipher)new RijndaelEngine(this.blockSize))), (BlockCipherPadding)new ZeroBytePadding());
        boolean bl = false;
        int keySize = this.blockSize / 8;
        it.init(forEncryption, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(this.key, 0, keySize), iv, 0, keySize));
        return paddedBufferedBlockCipher;
    }
}

