/*
 * Decompiled with CFR 0.152.
 */
package de.jnkconsulting.e3dc.easyrscp.connection;

import de.jnkconsulting.e3dc.easyrscp.api.connection.ConnectionPool;
import de.jnkconsulting.e3dc.easyrscp.api.connection.HomePowerPlantConnection;
import de.jnkconsulting.e3dc.easyrscp.api.connection.HomePowerPlantConnectionFactory;
import de.jnkconsulting.e3dc.easyrscp.connection.SingleInstanceConnectionPool;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\bH\u0002J6\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112!\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u0002H\u00110\u0013H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\bH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\bH\u0016J\b\u0010\u001b\u001a\u00020\u0019H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/jnkconsulting/e3dc/easyrscp/connection/SingleInstanceConnectionPool;", "Lde/jnkconsulting/e3dc/easyrscp/api/connection/ConnectionPool;", "connector", "Lde/jnkconsulting/e3dc/easyrscp/api/connection/HomePowerPlantConnectionFactory;", "timeoutMillis", "", "(Lde/jnkconsulting/e3dc/easyrscp/api/connection/HomePowerPlantConnectionFactory;J)V", "connection", "Lde/jnkconsulting/e3dc/easyrscp/api/connection/HomePowerPlantConnection;", "free", "", "lock", "", "logger", "Lmu/KLogger;", "ensureConnectionIsOpen", "executeAndRelease", "R", "receiver", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getConnection", "releaseConnection", "", "toRelease", "shutdown", "jnk-easy-rscp-lowlevel"})
@SourceDebugExtension(value={"SMAP\nSingleInstanceConnectionPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleInstanceConnectionPool.kt\nde/jnkconsulting/e3dc/easyrscp/connection/SingleInstanceConnectionPool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class SingleInstanceConnectionPool
implements ConnectionPool {
    @NotNull
    private final HomePowerPlantConnectionFactory connector;
    private final long timeoutMillis;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final Object lock;
    @Nullable
    private HomePowerPlantConnection connection;
    private boolean free;

    public SingleInstanceConnectionPool(@NotNull HomePowerPlantConnectionFactory connector, long timeoutMillis) {
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        this.connector = connector;
        this.timeoutMillis = timeoutMillis;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.lock = new Object();
        this.free = true;
    }

    public /* synthetic */ SingleInstanceConnectionPool(HomePowerPlantConnectionFactory homePowerPlantConnectionFactory, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 10000L;
        }
        this(homePowerPlantConnectionFactory, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public HomePowerPlantConnection getConnection() {
        Object object = this.lock;
        synchronized (object) {
            block8: {
                boolean bl = false;
                if (!this.free) break block8;
                HomePowerPlantConnection homePowerPlantConnection = this.ensureConnectionIsOpen();
                return homePowerPlantConnection;
            }
            Unit unit = Unit.INSTANCE;
        }
        Thread.sleep(this.timeoutMillis);
        object = this.lock;
        synchronized (object) {
            block9: {
                boolean bl = false;
                if (!this.free) break block9;
                HomePowerPlantConnection homePowerPlantConnection = this.ensureConnectionIsOpen();
                return homePowerPlantConnection;
            }
            Unit unit = Unit.INSTANCE;
        }
        throw new TimeoutException("Could not get a connection within the configured timeout of " + this.timeoutMillis + " ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(@NotNull HomePowerPlantConnection toRelease) {
        Intrinsics.checkNotNullParameter((Object)toRelease, (String)"toRelease");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.free = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R executeAndRelease(@NotNull Function1<? super HomePowerPlantConnection, ? extends R> receiver) {
        Object object;
        Intrinsics.checkNotNullParameter(receiver, (String)"receiver");
        HomePowerPlantConnection it = this.getConnection();
        boolean bl = false;
        try {
            object = receiver.invoke((Object)it);
        }
        catch (IOException e) {
            this.shutdown();
            this.logger.error((Throwable)e, (Function0)executeAndRelease.1.1.INSTANCE);
            throw new IOException(e.getMessage(), e);
        }
        finally {
            this.releaseConnection(it);
        }
        return (R)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            try {
                HomePowerPlantConnection homePowerPlantConnection = this.connection;
                if (homePowerPlantConnection != null) {
                    homePowerPlantConnection.disconnect();
                }
            }
            catch (IOException e) {
                this.logger.error((Throwable)e, (Function0)shutdown.1.1.INSTANCE);
            }
            this.connection = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HomePowerPlantConnection ensureConnectionIsOpen() {
        HomePowerPlantConnection homePowerPlantConnection;
        Object object = this.lock;
        synchronized (object) {
            HomePowerPlantConnection homePowerPlantConnection2;
            boolean bl;
            boolean bl2 = false;
            HomePowerPlantConnection it = this.connection;
            boolean bl3 = false;
            boolean bl4 = bl = it != null && it.isConnected();
            if (bl) {
                HomePowerPlantConnection homePowerPlantConnection3;
                HomePowerPlantConnection it2 = homePowerPlantConnection3 = it;
                boolean bl5 = false;
                this.logger.trace((Function0)ensureConnectionIsOpen.1.1.1.1.INSTANCE);
                it2 = homePowerPlantConnection3;
                boolean bl6 = false;
                this.free = false;
                homePowerPlantConnection2 = homePowerPlantConnection3;
            } else if (!bl) {
                HomePowerPlantConnectionFactory homePowerPlantConnectionFactory;
                HomePowerPlantConnectionFactory it3 = homePowerPlantConnectionFactory = this.connector;
                boolean bl7 = false;
                this.logger.trace((Function0)ensureConnectionIsOpen.1.1.3.1.INSTANCE);
                it3 = homePowerPlantConnectionFactory = homePowerPlantConnectionFactory.openConnection();
                boolean bl8 = false;
                this.connection = it3;
                this.free = false;
                homePowerPlantConnection2 = homePowerPlantConnectionFactory;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            homePowerPlantConnection = homePowerPlantConnection2;
        }
        return homePowerPlantConnection;
    }
}

