/*
 * Decompiled with CFR 0.152.
 */
package de.jiac.micro.internal.io;

import com.github.libxjava.lang.IClassLoader;
import de.jiac.micro.core.io.IStreamConnection;
import de.jiac.micro.internal.io.AbstractConnectionMapper;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;

public final class ConnectionMapperFactory {
    public static final String PATH = "de/jiac/micro/conmap/";
    static /* synthetic */ Class class$de$jiac$micro$core$io$IStreamConnection;

    private ConnectionMapperFactory() {
    }

    public static IStreamConnection openStreamConnection(IClassLoader classLoader, String scheme) throws IOException {
        Connection c = Connector.open((String)scheme);
        try {
            return ConnectionMapperFactory.getStreamConnection(classLoader, scheme, c);
        }
        catch (IOException ioe) {
            try {
                c.close();
            }
            catch (IOException innerIOE) {
                // empty catch block
            }
            throw ioe;
        }
    }

    public static IStreamConnection getStreamConnection(IClassLoader classLoader, String scheme, Connection c) throws IOException {
        String className;
        int colon = scheme.indexOf(58);
        String type = scheme.substring(0, colon).toLowerCase();
        if (c instanceof StreamConnection) {
            type = "stream";
        }
        if ((className = ConnectionMapperFactory.searchClassName(classLoader, type)) == null) {
            throw new IOException("no stream mapping found for '" + type + "'");
        }
        try {
            AbstractConnectionMapper stream = (AbstractConnectionMapper)classLoader.loadClass(className).newInstance();
            stream.initialise(c);
            return stream;
        }
        catch (ClassNotFoundException cfne) {
            throw new IOException("no stream mapping found for '" + type + "': " + cfne.getMessage());
        }
        catch (InstantiationException ie) {
            throw new IOException("could not instantiate stream mapping for + '" + type + "': " + ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new IOException("could not access constructor of stream mapping for '" + type + "': " + iae.getMessage());
        }
        catch (ClassCastException cce) {
            throw new IOException("stream mapping for '" + type + "' does not implement '" + (class$de$jiac$micro$core$io$IStreamConnection == null ? (class$de$jiac$micro$core$io$IStreamConnection = ConnectionMapperFactory.class$("de.jiac.micro.core.io.IStreamConnection")) : class$de$jiac$micro$core$io$IStreamConnection).getName() + "': " + cce.getMessage());
        }
    }

    private static String searchClassName(IClassLoader classLoader, String type) {
        InputStream in = classLoader.getResourceAsStream(PATH + type);
        String result = null;
        if (in != null) {
            StringBuffer buffer = new StringBuffer();
            try {
                int ch;
                block5: while ((ch = in.read()) > 0) {
                    switch (ch) {
                        case 10: 
                        case 13: 
                        case 32: {
                            continue block5;
                        }
                    }
                    buffer.append((char)ch);
                }
                result = buffer.toString();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

