/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jflex;

import JFlex.Main;
import JFlex.Options;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.jflex.ClassInfo;
import org.codehaus.mojo.jflex.LexSimpleAnalyzer;

public class JFlexMojo
extends AbstractMojo {
    public static final String SRC_MAIN_JFLEX = "src/main/jflex";
    private MavenProject project;
    private File[] lexDefinitions;
    private File outputDirectory;
    private int staleMillis;
    private boolean verbose;
    private boolean dot;
    private File skeleton;
    private boolean jlex;
    private String generationMethod = "pack";
    private boolean minimize = true;
    private boolean backup = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<File> filesIt;
        this.outputDirectory = this.getAbsolutePath(this.outputDirectory);
        this.project.addCompileSourceRoot(this.outputDirectory.getPath());
        if (this.lexDefinitions != null) {
            filesIt = Arrays.asList(this.lexDefinitions);
            this.getLog().debug((CharSequence)("Parsing " + this.lexDefinitions.length + " jflex files or directories given in configuration"));
        } else {
            this.getLog().debug((CharSequence)"Use lexer files found in (default) src/main/jflex");
            filesIt = new ArrayList<File>();
            File defaultDir = this.getAbsolutePath(new File(SRC_MAIN_JFLEX));
            if (defaultDir.isDirectory()) {
                filesIt.add(defaultDir);
            }
        }
        Iterator<File> fileIterator = filesIt.iterator();
        while (fileIterator.hasNext()) {
            File lexDefinition = fileIterator.next();
            lexDefinition = this.getAbsolutePath(lexDefinition);
            this.parseLexDefinition(lexDefinition);
        }
    }

    private void parseLexDefinition(File lexDefinition) throws MojoFailureException, MojoExecutionException {
        if (lexDefinition.isDirectory()) {
            String[] extensions = new String[]{"jflex", "jlex", "lex", "flex"};
            this.getLog().debug((CharSequence)("Processing lexer files found in " + lexDefinition));
            Iterator fileIterator = FileUtils.iterateFiles((File)lexDefinition, (String[])extensions, (boolean)true);
            while (fileIterator.hasNext()) {
                File lexFile = (File)fileIterator.next();
                this.parseLexFile(lexFile);
            }
        } else {
            this.parseLexFile(lexDefinition);
        }
    }

    private void parseLexFile(File lexFile) throws MojoFailureException, MojoExecutionException {
        this.getLog().debug((CharSequence)("Generationg Java code from " + lexFile.getName()));
        ClassInfo classInfo = null;
        try {
            classInfo = LexSimpleAnalyzer.guessPackageAndClass(lexFile);
        }
        catch (FileNotFoundException e1) {
            throw new MojoFailureException(e1.getMessage());
        }
        catch (IOException e3) {
            classInfo = new ClassInfo();
            classInfo.className = "Yylex";
            classInfo.packageName = null;
        }
        this.checkParameters(lexFile);
        File generatedFile = new File(this.outputDirectory, classInfo.getOutputFilename());
        if (lexFile.lastModified() - generatedFile.lastModified() <= (long)this.staleMillis) {
            this.getLog().info((CharSequence)("  " + generatedFile.getName() + " is up to date."));
            this.getLog().debug((CharSequence)("StaleMillis = " + this.staleMillis + "ms"));
            return;
        }
        Options.setDefaults();
        Options.setDir((File)generatedFile.getParentFile());
        Options.dump = this.verbose;
        Options.verbose = this.verbose;
        Options.dot = this.dot;
        if (this.skeleton != null) {
            Options.setSkeleton((File)this.skeleton);
        }
        Options.jlex = this.jlex;
        Options.no_minimize = !this.minimize;
        boolean bl = Options.no_backup = !this.backup;
        if ("switch".equals(this.generationMethod)) {
            Options.gen_method = 2;
        } else if ("table".equals(this.generationMethod)) {
            Options.gen_method = 1;
        } else if ("pack".equals(this.generationMethod)) {
            Options.gen_method = 0;
        } else {
            throw new MojoExecutionException("Illegal generation method: " + this.generationMethod);
        }
        try {
            Main.generate((File)lexFile);
            this.getLog().info((CharSequence)("  generated " + generatedFile));
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private void checkParameters(File lexFile) throws MojoExecutionException {
        if (lexFile == null) {
            throw new MojoExecutionException("<lexDefinition> is empty. Please define input file with <lexDefinition>input.jflex</lexDefinition>");
        }
        if (!lexFile.isFile()) {
            throw new MojoExecutionException("Input file does not exist: " + lexFile);
        }
    }

    protected File getAbsolutePath(File path) {
        if (path == null || path.isAbsolute()) {
            return path;
        }
        return new File(this.project.getBasedir().getAbsolutePath(), path.getPath());
    }
}

