/*
 * Decompiled with CFR 0.152.
 */
package de.jflex.plugin.maven;

import de.jflex.plugin.maven.ClassInfo;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;

class LexSimpleAnalyzer {
    static final String DEFAULT_NAME = "Yylex";

    LexSimpleAnalyzer() {
    }

    static ClassInfo guessPackageAndClass(File lexFile) throws IOException {
        assert (lexFile.isAbsolute()) : lexFile;
        try (LineNumberReader reader = new LineNumberReader(new FileReader(lexFile));){
            String line;
            ClassInfo classInfo = new ClassInfo();
            while ((classInfo.className == null || classInfo.packageName == null) && (line = reader.readLine()) != null) {
                LexSimpleAnalyzer.guessPackage(classInfo, line);
                LexSimpleAnalyzer.guessClass(classInfo, line);
            }
            if (classInfo.className == null) {
                classInfo.className = DEFAULT_NAME;
            }
            ClassInfo classInfo2 = classInfo;
            return classInfo2;
        }
    }

    private static void guessClass(ClassInfo classInfo, String line) {
        int index;
        if (classInfo.className == null && (index = line.indexOf("%class")) >= 0) {
            classInfo.className = line.substring(index += 6);
            classInfo.className = classInfo.className.trim();
        }
    }

    private static void guessPackage(ClassInfo classInfo, String line) {
        int end;
        int index;
        if (classInfo.packageName == null && (index = line.indexOf("package")) >= 0 && (end = line.indexOf(59, index += 7)) >= index) {
            classInfo.packageName = line.substring(index, end);
            classInfo.packageName = classInfo.packageName.trim();
        }
    }
}

