/*
 * Decompiled with CFR 0.152.
 */
package de.jflex.plugin.maven;

import de.jflex.plugin.maven.ClassInfo;
import de.jflex.plugin.maven.LexSimpleAnalyzer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import jflex.Main;
import jflex.Options;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=false)
public class JFlexMojo
extends AbstractMojo {
    private static final String SRC_MAIN_JFLEX = "src/main/jflex";
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter
    private File[] lexDefinitions;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/jflex")
    private File outputDirectory;
    @Parameter(property="lastModGranularityMs", defaultValue="0")
    private int staleMillis;
    @Parameter(defaultValue="false")
    private boolean verbose;
    @Parameter(defaultValue="true")
    private boolean unusedWarning;
    @Parameter(defaultValue="false")
    private boolean dump;
    @Parameter(defaultValue="false")
    private boolean dot;
    @Parameter
    private File skeleton;
    @Parameter(defaultValue="false")
    private boolean jlex;
    @Parameter(defaultValue="pack")
    private String generationMethod = "pack";
    @Parameter(defaultValue="true")
    private boolean minimize = true;
    @Parameter(defaultValue="true")
    private boolean backup = true;
    @Parameter(defaultValue="false")
    private boolean legacyDot = false;
    @Parameter(defaultValue="")
    private String encodingName = "";

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<File> filesIt;
        this.outputDirectory = this.getAbsolutePath(this.outputDirectory);
        this.project.addCompileSourceRoot(this.outputDirectory.getPath());
        if (this.lexDefinitions == null) {
            this.getLog().debug((CharSequence)"Use lexer files found in (default) src/main/jflex");
            filesIt = new ArrayList<File>();
            File defaultDir = this.getAbsolutePath(new File(SRC_MAIN_JFLEX));
            if (defaultDir.isDirectory()) {
                filesIt.add(defaultDir);
            }
        } else {
            filesIt = Arrays.asList(this.lexDefinitions);
            this.getLog().debug((CharSequence)("Parsing " + this.lexDefinitions.length + " jflex files or directories given in configuration"));
        }
        for (File lexDefinition : filesIt) {
            lexDefinition = this.getAbsolutePath(lexDefinition);
            this.parseLexDefinition(lexDefinition);
        }
    }

    private void parseLexDefinition(File lexDefinition) throws MojoFailureException, MojoExecutionException {
        assert (lexDefinition.isAbsolute()) : lexDefinition;
        if (lexDefinition.isDirectory()) {
            String[] extensions = new String[]{"jflex", "jlex", "lex", "flex"};
            this.getLog().debug((CharSequence)("Processing lexer files found in " + lexDefinition));
            Iterator fileIterator = FileUtils.iterateFiles((File)lexDefinition, (String[])extensions, (boolean)true);
            while (fileIterator.hasNext()) {
                File lexFile = (File)fileIterator.next();
                this.parseLexFile(lexFile);
            }
        } else {
            this.parseLexFile(lexDefinition);
        }
    }

    private void parseLexFile(File lexFile) throws MojoFailureException, MojoExecutionException {
        ClassInfo classInfo;
        assert (lexFile.isAbsolute()) : lexFile;
        this.getLog().debug((CharSequence)("Generating Java code from " + lexFile.getName()));
        try {
            classInfo = LexSimpleAnalyzer.guessPackageAndClass(lexFile);
        }
        catch (FileNotFoundException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            classInfo = new ClassInfo();
            classInfo.className = "Yylex";
            classInfo.packageName = null;
        }
        this.checkParameters(lexFile);
        File generatedFile = new File(this.outputDirectory, classInfo.getOutputFilename());
        if (lexFile.lastModified() - generatedFile.lastModified() <= (long)this.staleMillis) {
            this.getLog().info((CharSequence)("  " + generatedFile.getName() + " is up to date."));
            this.getLog().debug((CharSequence)("StaleMillis = " + this.staleMillis + "ms"));
            return;
        }
        Options.setDefaults();
        Options.setDir((File)generatedFile.getParentFile());
        Options.dump = this.dump;
        Options.verbose = this.verbose;
        Options.unused_warning = this.unusedWarning;
        Options.dot = this.dot;
        Options.legacy_dot = this.legacyDot;
        if (this.skeleton != null) {
            Options.setSkeleton((File)this.skeleton);
        }
        Options.jlex = this.jlex;
        Options.no_minimize = !this.minimize;
        boolean bl = Options.no_backup = !this.backup;
        if (!"pack".equals(this.generationMethod)) {
            throw new MojoExecutionException("Illegal generation method: " + this.generationMethod);
        }
        if (!"".equals(this.encodingName)) {
            try {
                Options.setEncoding((String)this.encodingName);
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage());
            }
        }
        try {
            Main.generate((File)lexFile);
            this.getLog().info((CharSequence)("  generated " + generatedFile));
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void checkParameters(File lexFile) throws MojoExecutionException {
        if (lexFile == null) {
            throw new MojoExecutionException("<lexDefinition> is empty. Please define input file with <lexDefinition>input.jflex</lexDefinition>");
        }
        if (!lexFile.isFile()) {
            throw new MojoExecutionException("Input file does not exist: " + lexFile);
        }
    }

    private File getAbsolutePath(File path) {
        if (path == null || path.isAbsolute()) {
            return path;
        }
        return new File(this.project.getBasedir().getAbsolutePath(), path.getPath());
    }
}

