/*
 * Decompiled with CFR 0.152.
 */
package jflex.maven.plugin.cup;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Pattern;
import jflex.maven.plugin.cup.CliCupInvoker;
import jflex.maven.plugin.cup.JavaUtils;
import jflex.maven.plugin.cup.Logger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=false)
public class GenerateMojo
extends AbstractMojo {
    private static final String PACKAGE_DEFINITION = "package";
    private static final String DEFAULT_JAVA_PACKAGE = "";
    static final String DEFAULT_PARSER_NAME = "parser";
    static final String DEFAULT_SYMBOLS_NAME = "sym";
    @Parameter(defaultValue="${project.basedir}/src/main/cup")
    File cupSourceDirectory;
    @Parameter(defaultValue=".*\\.cup")
    String cupSourceFilesFilter;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/cup")
    File generatedSourcesDirectory;
    @Parameter(defaultValue="false")
    boolean symbolInterface;
    @Parameter(defaultValue="sym")
    String symbolsName;
    @Parameter(defaultValue="parser")
    String parserName;
    @Parameter(property="project", required=true, readonly=true)
    MavenProject mavenProject;
    @Parameter(defaultValue="false")
    private boolean force;
    private CliCupInvoker cupInvoker;
    private final Logger log;

    public GenerateMojo() {
        this.log = new Logger(this.getLog());
        this.cupInvoker = new CliCupInvoker(this.getLog());
    }

    @VisibleForTesting
    GenerateMojo(CliCupInvoker cupInvoker, Log logger) {
        this.log = new Logger(logger);
        this.cupInvoker = cupInvoker;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File[] srcs;
        File[] fileArray = srcs = this.getSources();
        int n = srcs.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            try {
                this.generateParser(f);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not generate parser for " + f.getPath(), (Exception)e);
            }
            ++n2;
        }
    }

    @VisibleForTesting
    void generateParser(File cupFile) throws IOException, MojoExecutionException {
        boolean skipGeneration;
        String javaPackage = this.findJavaPackage(cupFile);
        this.mavenProject.addCompileSourceRoot(this.generatedSourcesDirectory.getPath());
        boolean bl = skipGeneration = !this.force && !this.isGeneratedCodeOutdated(cupFile, javaPackage);
        if (skipGeneration) {
            this.log.i("Do nothing. Generated code for is up to date for: %s", cupFile.getName());
            return;
        }
        if (this.force) {
            this.log.i("Generation requested by force for: %s", cupFile.getName());
        }
        try {
            this.log.d("Generate CUP parser for %s", cupFile.getAbsolutePath());
            File outputDirectory = JavaUtils.directory(this.generatedSourcesDirectory, javaPackage);
            this.log.d("CUP output directory: %s", outputDirectory);
            if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
                throw new IOException("Could not create " + outputDirectory);
            }
            this.cupInvoker.invoke(javaPackage, outputDirectory, this.parserName, this.symbolsName, this.symbolInterface, cupFile.getAbsolutePath());
            this.log.i("CUP generated %s and %s for %s", this.parserName, this.symbolsName, cupFile.getPath());
        }
        catch (Exception e) {
            throw new MojoExecutionException("CUP failed to generate parser for " + cupFile.getAbsolutePath(), e);
        }
    }

    private boolean isGeneratedCodeOutdated(File cupFile, String javaPackage) {
        File parserFile = JavaUtils.file(this.generatedSourcesDirectory, javaPackage, this.parserName);
        File symFile = JavaUtils.file(this.generatedSourcesDirectory, javaPackage, this.symbolsName);
        if (parserFile.lastModified() <= cupFile.lastModified()) {
            this.log.d("Parser file for %s is not actual: %s", cupFile.getName(), parserFile);
            return true;
        }
        this.log.d("Parser file for %s is actual: %s", cupFile.getName(), parserFile);
        if (symFile.lastModified() <= cupFile.lastModified()) {
            this.log.d("Symbol file for %s is not actual: %s", symFile.getName(), symFile);
            return true;
        }
        this.log.d("Symbol file for %s is actual: %s", symFile.getName(), symFile);
        return false;
    }

    private String findJavaPackage(File cupFile) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(new FileReader(cupFile));){
            while (br.ready()) {
                String line = br.readLine();
                Optional<String> optJavaPackage = this.optionalJavaPackage(line);
                if (!optJavaPackage.isPresent()) continue;
                return (String)optJavaPackage.get();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return DEFAULT_JAVA_PACKAGE;
    }

    @VisibleForTesting
    Optional<String> optionalJavaPackage(String line) {
        int endOfLine;
        if (line.startsWith(PACKAGE_DEFINITION) && (endOfLine = line.indexOf(";")) > -1) {
            String javaPackage = line.substring(PACKAGE_DEFINITION.length(), endOfLine);
            javaPackage = javaPackage.trim();
            return Optional.of((Object)javaPackage);
        }
        return Optional.absent();
    }

    private File[] getSources() throws MojoFailureException {
        File defaultDir = this.getAbsolutePath(this.cupSourceDirectory);
        if (defaultDir == null) {
            throw new MojoFailureException("Expected " + this.cupSourceDirectory + " to be a directory");
        }
        if (!defaultDir.isDirectory()) {
            throw new MojoFailureException("Expected " + defaultDir.getAbsolutePath() + " to be a directory");
        }
        Pattern regexp = Pattern.compile(this.cupSourceFilesFilter);
        return defaultDir.listFiles((dir, name) -> regexp.matcher(name).matches());
    }

    private File getAbsolutePath(File path) {
        if (path == null || path.isAbsolute()) {
            return path;
        }
        return new File(this.mavenProject.getBasedir().getAbsolutePath(), path.getPath());
    }
}

