/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.zeit;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.jfachwert.KFachwert;
import de.jfachwert.util.ToFachwertSerializer;
import de.jfachwert.zeit.Zeitdauer;
import de.jfachwert.zeit.Zeiteinheit;
import de.jfachwert.zeit.Zeitpunkt;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=ToFachwertSerializer.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tB\u001d\b\u0017\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u000b\u00a2\u0006\u0004\b\u0005\u0010\fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0000J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0000J\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\bH\u0016J\u0014\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0016J\u0013\u0010\u0018\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lde/jfachwert/zeit/Zeitraum;", "Lde/jfachwert/KFachwert;", "von", "Lde/jfachwert/zeit/Zeitpunkt;", "bis", "<init>", "(Lde/jfachwert/zeit/Zeitpunkt;Lde/jfachwert/zeit/Zeitpunkt;)V", "vonbis", "", "(Ljava/lang/String;)V", "map", "", "(Ljava/util/Map;)V", "getVon", "()Lde/jfachwert/zeit/Zeitpunkt;", "getBis", "isBefore", "", "zeitraum", "isAfter", "getZeitdauer", "Lde/jfachwert/zeit/Zeitdauer;", "toString", "toMap", "equals", "other", "", "hashCode", "", "Companion", "zeit"})
public class Zeitraum
implements KFachwert {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Zeitpunkt von;
    @NotNull
    private final Zeitpunkt bis;
    @NotNull
    private static final WeakHashMap<Pair<Zeitpunkt, Zeitpunkt>, Zeitraum> WEAK_CACHE = new WeakHashMap();
    @JvmField
    @NotNull
    public static final Zeitraum NULL = new Zeitraum(Zeitpunkt.EPOCH, Zeitpunkt.EPOCH);
    @JvmField
    @NotNull
    public static final Zeitraum PRAEKAMBRIUM = new Zeitraum(Zeitpunkt.Companion.of(-4600L, Zeiteinheit.ERAS), Zeitpunkt.Companion.of(-590L, Zeiteinheit.ERAS));
    @JvmField
    @NotNull
    public static final Zeitraum PALAEOZOLIKUM = new Zeitraum(Zeitpunkt.Companion.of(-590L, Zeiteinheit.ERAS), Zeitpunkt.Companion.of(-240L, Zeiteinheit.ERAS));
    @JvmField
    @NotNull
    public static final Zeitraum MESOZOIKUM = new Zeitraum(Zeitpunkt.Companion.of(-240L, Zeiteinheit.ERAS), Zeitpunkt.Companion.of(-65L, Zeiteinheit.ERAS));
    @JvmField
    @NotNull
    public static final Zeitraum KAENOZOIKUM = new Zeitraum(Zeitpunkt.Companion.of(-65L, Zeiteinheit.ERAS), Zeitpunkt.Companion.now());

    public Zeitraum(@NotNull Zeitpunkt von, @NotNull Zeitpunkt bis) {
        Intrinsics.checkNotNullParameter((Object)von, (String)"von");
        Intrinsics.checkNotNullParameter((Object)bis, (String)"bis");
        this.von = von;
        this.bis = bis;
    }

    public /* synthetic */ Zeitraum(Zeitpunkt zeitpunkt, Zeitpunkt zeitpunkt2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            zeitpunkt = Zeitpunkt.MIN;
        }
        if ((n & 2) != 0) {
            zeitpunkt2 = Zeitpunkt.MAX;
        }
        this(zeitpunkt, zeitpunkt2);
    }

    @NotNull
    public final Zeitpunkt getVon() {
        return this.von;
    }

    @NotNull
    public final Zeitpunkt getBis() {
        return this.bis;
    }

    public Zeitraum(@NotNull String vonbis) {
        Intrinsics.checkNotNullParameter((Object)vonbis, (String)"vonbis");
        this(Zeitraum.Companion.split(vonbis));
    }

    @JsonCreator
    public Zeitraum(@NotNull Map<String, ? extends Zeitpunkt> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Zeitpunkt zeitpunkt = map.get("von");
        Intrinsics.checkNotNull((Object)zeitpunkt);
        Zeitpunkt zeitpunkt2 = map.get("bis");
        Intrinsics.checkNotNull((Object)zeitpunkt2);
        this(zeitpunkt, zeitpunkt2);
    }

    public final boolean isBefore(@NotNull Zeitraum zeitraum) {
        Intrinsics.checkNotNullParameter((Object)zeitraum, (String)"zeitraum");
        return this.bis.compareTo(zeitraum.von) >= 0;
    }

    public final boolean isAfter(@NotNull Zeitraum zeitraum) {
        Intrinsics.checkNotNullParameter((Object)zeitraum, (String)"zeitraum");
        return this.von.compareTo(zeitraum.bis) >= 0;
    }

    @NotNull
    public final Zeitdauer getZeitdauer() {
        return Zeitdauer.Companion.of(this.von, this.bis);
    }

    @NotNull
    public String toString() {
        return this.von + " - " + this.bis;
    }

    @NotNull
    public Map<String, Zeitpunkt> toMap() {
        Map map = new HashMap();
        map.put("von", this.von);
        map.put("bis", this.bis);
        return map;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Zeitraum)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.von, (Object)((Zeitraum)other).von) && Intrinsics.areEqual((Object)this.bis, (Object)((Zeitraum)other).bis);
    }

    public int hashCode() {
        return this.bis.hashCode();
    }

    public boolean isValid() {
        return KFachwert.DefaultImpls.isValid((KFachwert)this);
    }

    public Zeitraum() {
        this(null, null, 3, null);
    }

    @JvmStatic
    @NotNull
    public static final Zeitraum of(@NotNull String s) {
        return Companion.of(s);
    }

    @JvmStatic
    @NotNull
    public static final Zeitraum of(@Nullable Date von, @Nullable Date bis) {
        return Companion.of(von, bis);
    }

    @JvmStatic
    @NotNull
    public static final Zeitraum of(@Nullable Timestamp von, @Nullable Timestamp bis) {
        return Companion.of(von, bis);
    }

    @JvmStatic
    @NotNull
    public static final Zeitraum of(@Nullable LocalDate von, @Nullable LocalDate bis) {
        return Companion.of(von, bis);
    }

    @JvmStatic
    @NotNull
    public static final Zeitraum of(@Nullable LocalDateTime von, @Nullable LocalDateTime bis) {
        return Companion.of(von, bis);
    }

    @JvmStatic
    @NotNull
    public static final Zeitraum of(@Nullable Zeitpunkt von, @Nullable Zeitpunkt bis) {
        return Companion.of(von, bis);
    }

    @JvmStatic
    @NotNull
    public static final Zeitraum von(@NotNull Zeitpunkt start) {
        return Companion.von(start);
    }

    @JvmStatic
    @NotNull
    public static final Zeitraum bis(@NotNull Zeitpunkt end) {
        return Companion.bis(end);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001c\u0010\u000e\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0007J\u001c\u0010\u000e\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007J\u001c\u0010\u000e\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00152\b\u0010\u0013\u001a\u0004\u0018\u00010\u0015H\u0007J\u001c\u0010\u000e\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00162\b\u0010\u0013\u001a\u0004\u0018\u00010\u0016H\u0007J\u001c\u0010\u000e\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0007J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0007H\u0007J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0007H\u0007J\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00070\u001a2\u0006\u0010\u001b\u001a\u00020\u0010H\u0002R&\u0010\u0004\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/jfachwert/zeit/Zeitraum$Companion;", "", "<init>", "()V", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "Lkotlin/Pair;", "Lde/jfachwert/zeit/Zeitpunkt;", "Lde/jfachwert/zeit/Zeitraum;", "NULL", "PRAEKAMBRIUM", "PALAEOZOLIKUM", "MESOZOIKUM", "KAENOZOIKUM", "of", "s", "", "von", "Ljava/util/Date;", "bis", "Ljava/sql/Timestamp;", "Ljava/time/LocalDate;", "Ljava/time/LocalDateTime;", "start", "end", "split", "", "vonbis", "zeit"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Zeitraum of(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            Map<String, Zeitpunkt> map = this.split(s);
            Zeitpunkt zeitpunkt = map.get("von");
            Intrinsics.checkNotNull((Object)zeitpunkt);
            Zeitpunkt zeitpunkt2 = map.get("bis");
            Intrinsics.checkNotNull((Object)zeitpunkt2);
            return this.of(zeitpunkt, zeitpunkt2);
        }

        @JvmStatic
        @NotNull
        public final Zeitraum of(@Nullable Date von, @Nullable Date bis) {
            Date date = von;
            Zeitpunkt t1 = date != null ? Zeitpunkt.Companion.of(date) : null;
            Date date2 = bis;
            Zeitpunkt t2 = date2 != null ? Zeitpunkt.Companion.of(date2) : null;
            return this.of(t1, t2);
        }

        @JvmStatic
        @NotNull
        public final Zeitraum of(@Nullable Timestamp von, @Nullable Timestamp bis) {
            Timestamp timestamp = von;
            Zeitpunkt t1 = timestamp != null ? Zeitpunkt.Companion.of(timestamp) : null;
            Timestamp timestamp2 = bis;
            Zeitpunkt t2 = timestamp2 != null ? Zeitpunkt.Companion.of(timestamp2) : null;
            return this.of(t1, t2);
        }

        @JvmStatic
        @NotNull
        public final Zeitraum of(@Nullable LocalDate von, @Nullable LocalDate bis) {
            LocalDate localDate = von;
            Zeitpunkt t1 = localDate != null ? Zeitpunkt.Companion.of(localDate) : null;
            LocalDate localDate2 = bis;
            Zeitpunkt t2 = localDate2 != null ? Zeitpunkt.Companion.of(localDate2) : null;
            return this.of(t1, t2);
        }

        @JvmStatic
        @NotNull
        public final Zeitraum of(@Nullable LocalDateTime von, @Nullable LocalDateTime bis) {
            LocalDateTime localDateTime = von;
            Zeitpunkt t1 = localDateTime != null ? Zeitpunkt.Companion.of(localDateTime) : null;
            LocalDateTime localDateTime2 = bis;
            Zeitpunkt t2 = localDateTime2 != null ? Zeitpunkt.Companion.of(localDateTime2) : null;
            return this.of(t1, t2);
        }

        @JvmStatic
        @NotNull
        public final Zeitraum of(@Nullable Zeitpunkt von, @Nullable Zeitpunkt bis) {
            Zeitpunkt zeitpunkt;
            Zeitpunkt zeitpunkt2 = von;
            if (zeitpunkt2 == null) {
                zeitpunkt2 = Zeitpunkt.MIN;
            }
            if ((zeitpunkt = bis) == null) {
                zeitpunkt = Zeitpunkt.MAX;
            }
            Pair pair = new Pair((Object)zeitpunkt2, (Object)zeitpunkt);
            Zeitraum zeitraum = WEAK_CACHE.computeIfAbsent(pair, arg_0 -> Companion.of$lambda$1(arg_0 -> Companion.of$lambda$0(pair, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)zeitraum, (String)"computeIfAbsent(...)");
            return zeitraum;
        }

        @JvmStatic
        @NotNull
        public final Zeitraum von(@NotNull Zeitpunkt start) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            return this.of(start, Zeitpunkt.MAX);
        }

        @JvmStatic
        @NotNull
        public final Zeitraum bis(@NotNull Zeitpunkt end) {
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            return this.of(Zeitpunkt.MIN, end);
        }

        private final Map<String, Zeitpunkt> split(String vonbis) {
            Map map = new HashMap();
            String string = vonbis.substring(0, vonbis.length() / 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String von = ((Object)StringsKt.trim((CharSequence)string)).toString();
            String string2 = vonbis.substring(vonbis.length() / 2 + 1, vonbis.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String bis = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            map.put("von", Zeitpunkt.Companion.of(von));
            map.put("bis", Zeitpunkt.Companion.of(bis));
            return map;
        }

        private static final Zeitraum of$lambda$0(Pair $pair, Pair it) {
            Intrinsics.checkNotNullParameter((Object)$pair, (String)"$pair");
            return new Zeitraum((Zeitpunkt)$pair.getFirst(), (Zeitpunkt)$pair.getSecond());
        }

        private static final Zeitraum of$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Zeitraum)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

