/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.zeit;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.jfachwert.KFachwert;
import de.jfachwert.Localized;
import de.jfachwert.util.ToFachwertSerializer;
import de.jfachwert.zeit.Zeiteinheit;
import de.jfachwert.zeit.Zeitpunkt;
import java.math.BigInteger;
import java.time.Period;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=ToFachwertSerializer.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u0000 .2\u00020\u00012\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u00020\u00000\u0004:\u0001.B\u001b\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tB\t\b\u0016\u00a2\u0006\u0004\b\b\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\b\u0010\u000fB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u0010\u00a2\u0006\u0004\b\b\u0010\u0011J\u0006\u0010\u0012\u001a\u00020\u0000J\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0014J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0014H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0010J\u0006\u0010\u001b\u001a\u00020\fJ\u0011\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0014H\u0096\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0011\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0000H\u0096\u0002J\u0014\u0010(\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020*0)H\u0016J\u0013\u0010+\u001a\u00020,2\b\u0010'\u001a\u0004\u0018\u00010*H\u0096\u0002J\b\u0010-\u001a\u00020&H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lde/jfachwert/zeit/Zeitdauer;", "Lde/jfachwert/KFachwert;", "Lde/jfachwert/Localized;", "Ljava/time/temporal/TemporalAmount;", "", "von", "Lde/jfachwert/zeit/Zeitpunkt;", "bis", "<init>", "(Lde/jfachwert/zeit/Zeitpunkt;Lde/jfachwert/zeit/Zeitpunkt;)V", "()V", "code", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)V", "Ljava/math/BigInteger;", "(Ljava/math/BigInteger;)V", "stop", "getZaehler", "Ljava/time/temporal/TemporalUnit;", "t", "getEinheit", "Lde/jfachwert/zeit/Zeiteinheit;", "toPeriod", "Ljava/time/Period;", "getTimeInNanos", "getTimeInMillis", "get", "getUnits", "", "addTo", "Ljava/time/temporal/Temporal;", "temporal", "subtractFrom", "toString", "", "compareTo", "", "other", "toMap", "", "", "equals", "", "hashCode", "Companion", "zeit"})
public class Zeitdauer
implements KFachwert,
Localized,
TemporalAmount,
Comparable<Zeitdauer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Zeitpunkt von;
    @Nullable
    private final Zeitpunkt bis;
    @NotNull
    private static final WeakHashMap<BigInteger, Zeitdauer> WEAK_CACHE = new WeakHashMap();

    public Zeitdauer(@NotNull Zeitpunkt von, @Nullable Zeitpunkt bis) {
        Intrinsics.checkNotNullParameter((Object)von, (String)"von");
        this.von = von;
        this.bis = bis;
    }

    public /* synthetic */ Zeitdauer(Zeitpunkt zeitpunkt, Zeitpunkt zeitpunkt2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            zeitpunkt2 = null;
        }
        this(zeitpunkt, zeitpunkt2);
    }

    public Zeitdauer() {
        this(new Zeitpunkt(), null, 2, null);
    }

    public Zeitdauer(long code, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        BigInteger bigInteger = BigInteger.valueOf(unit.toNanos(code));
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
        this(Zeitpunkt.EPOCH, Zeitpunkt.Companion.of(bigInteger));
    }

    public Zeitdauer(@NotNull BigInteger code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this(Zeitpunkt.EPOCH, Zeitpunkt.Companion.of(code));
    }

    @NotNull
    public final Zeitdauer stop() {
        return new Zeitdauer(this.von, Zeitpunkt.Companion.now());
    }

    @NotNull
    public final BigInteger getZaehler() {
        return this.getZaehler(this.getTimeInNanos());
    }

    @NotNull
    public final BigInteger getZaehler(@NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return this.getZaehler(this.getTimeInNanos(), unit);
    }

    @NotNull
    public final BigInteger getZaehler(@NotNull TemporalUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return this.getZaehler(this.getTimeInNanos(), unit);
    }

    private final BigInteger getZaehler(BigInteger t) {
        return this.getZaehler(t, this.getEinheit(t));
    }

    private final BigInteger getZaehler(BigInteger t, TimeUnit unit) {
        return this.getZaehler(t, Zeiteinheit.Companion.of(unit));
    }

    private final BigInteger getZaehler(BigInteger t, TemporalUnit unit) {
        Zeiteinheit zeiteinheit = Zeiteinheit.Companion.of(unit);
        BigInteger bigInteger = t.divide(zeiteinheit.toNanos(1L));
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"divide(...)");
        return bigInteger;
    }

    @NotNull
    public final Zeiteinheit getEinheit() {
        return this.getEinheit(this.getTimeInNanos());
    }

    private final Zeiteinheit getEinheit(BigInteger t) {
        if (t.compareTo(Zeiteinheit.ERAS.toNanos(5L)) > 0) {
            return Zeiteinheit.ERAS;
        }
        return t.compareTo(Zeiteinheit.MILLENNIA.toNanos(5L)) > 0 ? Zeiteinheit.MILLENNIA : (t.compareTo(Zeiteinheit.CENTURIES.toNanos(5L)) > 0 ? Zeiteinheit.CENTURIES : (t.compareTo(Zeiteinheit.DECADES.toNanos(5L)) > 0 ? Zeiteinheit.DECADES : (t.compareTo(Zeiteinheit.YEARS.toNanos(5L)) > 0 ? Zeiteinheit.YEARS : (t.compareTo(Zeiteinheit.MONTHS.toNanos(5L)) > 0 ? Zeiteinheit.MONTHS : (t.compareTo(Zeiteinheit.WEEKS.toNanos(5L)) > 0 ? Zeiteinheit.WEEKS : (t.compareTo(Zeiteinheit.DAYS.toNanos(3L)) > 0 ? Zeiteinheit.DAYS : (t.compareTo(Zeiteinheit.HALF_DAYS.toNanos(5L)) > 0 ? Zeiteinheit.HALF_DAYS : (t.compareTo(Zeiteinheit.HOURS.toNanos(3L)) > 0 ? Zeiteinheit.HOURS : (t.compareTo(Zeiteinheit.MINUTES.toNanos(3L)) > 0 ? Zeiteinheit.MINUTES : (t.compareTo(Zeiteinheit.SECONDS.toNanos(5L)) > 0 ? Zeiteinheit.SECONDS : (t.compareTo(Zeiteinheit.MILLISECONDS.toNanos(5L)) > 0 ? Zeiteinheit.MILLISECONDS : (t.compareTo(Zeiteinheit.MICROSECONDS.toNanos(5L)) > 0 ? Zeiteinheit.MICROSECONDS : Zeiteinheit.NANOSECONDS))))))))))));
    }

    @NotNull
    public final Period toPeriod() {
        Period period;
        Zeiteinheit einheit = this.getEinheit();
        switch (WhenMappings.$EnumSwitchMapping$0[einheit.ordinal()]) {
            case 1: {
                Period period2 = Period.ofWeeks(this.getZaehler(einheit).intValue());
                period = period2;
                Intrinsics.checkNotNullExpressionValue((Object)period2, (String)"ofWeeks(...)");
                break;
            }
            case 2: {
                Period period3 = Period.ofMonths(this.getZaehler(einheit).intValue());
                period = period3;
                Intrinsics.checkNotNullExpressionValue((Object)period3, (String)"ofMonths(...)");
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                Period period4 = Period.ofYears(this.getZaehler(Zeiteinheit.YEARS).intValue());
                period = period4;
                Intrinsics.checkNotNullExpressionValue((Object)period4, (String)"ofYears(...)");
                break;
            }
            default: {
                Period period5 = Period.ofDays(this.getZaehler(Zeiteinheit.DAYS).intValue());
                period = period5;
                Intrinsics.checkNotNullExpressionValue((Object)period5, (String)"ofDays(...)");
            }
        }
        return period;
    }

    @NotNull
    public final BigInteger getTimeInNanos() {
        Zeitpunkt zeitpunkt = this.bis;
        if (zeitpunkt == null) {
            zeitpunkt = new Zeitpunkt();
        }
        return zeitpunkt.minus(this.von).getTimeInNanos();
    }

    public final long getTimeInMillis() {
        return this.getTimeInNanos().divide(Zeiteinheit.MILLISECONDS.toNanos(1L)).longValue();
    }

    @Override
    public long get(@NotNull TemporalUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return this.getZaehler(unit).longValue();
    }

    @Override
    @NotNull
    public List<TemporalUnit> getUnits() {
        Zeiteinheit einheit = this.getEinheit();
        List units = new ArrayList();
        for (Zeiteinheit e : Zeiteinheit.getEntries()) {
            if (e == Zeiteinheit.UNBEKANNT || einheit.compareTo((Enum)e) < 0) continue;
            units.add(e);
        }
        return CollectionsKt.toList((Iterable)units);
    }

    @Override
    @NotNull
    public Temporal addTo(@NotNull Temporal temporal) {
        Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
        Zeiteinheit einheit = this.getEinheit();
        Temporal temporal2 = temporal.plus(this.getZaehler().longValue(), einheit.toChronoUnit());
        Intrinsics.checkNotNullExpressionValue((Object)temporal2, (String)"plus(...)");
        return temporal2;
    }

    @Override
    @NotNull
    public Temporal subtractFrom(@NotNull Temporal temporal) {
        Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
        Zeiteinheit einheit = this.getEinheit();
        Temporal temporal2 = temporal.minus(this.getZaehler().longValue(), einheit.toChronoUnit());
        Intrinsics.checkNotNullExpressionValue((Object)temporal2, (String)"minus(...)");
        return temporal2;
    }

    @NotNull
    public String toString() {
        BigInteger t = this.getTimeInNanos();
        return this.getZaehler(t) + " " + this.getLocalizedString(this.getEinheit(t).toString());
    }

    @Override
    public int compareTo(@NotNull Zeitdauer other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getTimeInNanos().compareTo(other.getTimeInNanos());
    }

    @NotNull
    public Map<String, Object> toMap() {
        Map map = new HashMap();
        map.put("von", this.von.getTimeInNanos());
        if (this.bis != null) {
            map.put("bis", this.bis.getTimeInNanos());
        }
        return map;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type de.jfachwert.zeit.Zeitdauer");
        Zeitdauer cfr_ignored_0 = (Zeitdauer)other;
        return this.von.equals(((Zeitdauer)other).von) && Objects.equals(this.bis, ((Zeitdauer)other).bis);
    }

    public int hashCode() {
        return this.von.hashCode();
    }

    public boolean isValid() {
        return KFachwert.DefaultImpls.isValid((KFachwert)this);
    }

    @NotNull
    public String getLocalizedString(@NotNull String key) {
        return Localized.DefaultImpls.getLocalizedString((Localized)this, (String)key);
    }

    @NotNull
    public String getLocalizedMessage(@NotNull String key, Object ... args) {
        return Localized.DefaultImpls.getLocalizedMessage((Localized)this, (String)key, (Object[])args);
    }

    @JvmStatic
    @NotNull
    public static final Zeitdauer of(long code, @NotNull TimeUnit unit) {
        return Companion.of(code, unit);
    }

    @JvmStatic
    @NotNull
    public static final Zeitdauer of(long code, @NotNull TemporalUnit unit) {
        return Companion.of(code, unit);
    }

    @JvmStatic
    @NotNull
    public static final Zeitdauer of(@NotNull Zeitpunkt von, @NotNull Zeitpunkt bis) {
        return Companion.of(von, bis);
    }

    @JvmStatic
    @NotNull
    public static final Zeitdauer of(@NotNull BigInteger nanos) {
        return Companion.of(nanos);
    }

    @JvmStatic
    @NotNull
    public static final Zeitdauer of(long millis) {
        return Companion.of(millis);
    }

    @JsonCreator
    @JvmStatic
    @NotNull
    public static final Zeitdauer of(@JsonProperty(value="von") @NotNull BigInteger von, @JsonProperty(value="bis") @NotNull BigInteger bis) {
        return Companion.of(von, bis);
    }

    @JvmStatic
    @NotNull
    public static final Zeitdauer start() {
        return Companion.start();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\rH\u0007J\u0018\u0010\b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0007J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0006H\u0007J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\nH\u0007J\u001c\u0010\b\u001a\u00020\u00072\b\b\u0001\u0010\u000e\u001a\u00020\u00062\b\b\u0001\u0010\u0010\u001a\u00020\u0006H\u0007J\b\u0010\u0013\u001a\u00020\u0007H\u0007R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/jfachwert/zeit/Zeitdauer$Companion;", "", "<init>", "()V", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "Ljava/math/BigInteger;", "Lde/jfachwert/zeit/Zeitdauer;", "of", "code", "", "unit", "Ljava/util/concurrent/TimeUnit;", "Ljava/time/temporal/TemporalUnit;", "von", "Lde/jfachwert/zeit/Zeitpunkt;", "bis", "nanos", "millis", "start", "zeit"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Zeitdauer of(long code, @NotNull TimeUnit unit) {
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            return this.of(code, Zeiteinheit.Companion.of(unit));
        }

        @JvmStatic
        @NotNull
        public final Zeitdauer of(long code, @NotNull TemporalUnit unit) {
            Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
            Zeiteinheit zeiteinheit = Zeiteinheit.Companion.of(unit);
            return this.of(zeiteinheit.toNanos(code));
        }

        @JvmStatic
        @NotNull
        public final Zeitdauer of(@NotNull Zeitpunkt von, @NotNull Zeitpunkt bis) {
            Intrinsics.checkNotNullParameter((Object)von, (String)"von");
            Intrinsics.checkNotNullParameter((Object)bis, (String)"bis");
            Zeitdauer dauer = new Zeitdauer(von, bis);
            return this.of(dauer.getTimeInNanos());
        }

        @JvmStatic
        @NotNull
        public final Zeitdauer of(@NotNull BigInteger nanos) {
            Intrinsics.checkNotNullParameter((Object)nanos, (String)"nanos");
            Zeitdauer zeitdauer = WEAK_CACHE.computeIfAbsent(nanos, arg_0 -> Companion.of$lambda$1(Companion::of$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)zeitdauer, (String)"computeIfAbsent(...)");
            return zeitdauer;
        }

        @JvmStatic
        @NotNull
        public final Zeitdauer of(long millis) {
            return this.of(millis, TimeUnit.MILLISECONDS);
        }

        @JsonCreator
        @JvmStatic
        @NotNull
        public final Zeitdauer of(@JsonProperty(value="von") @NotNull BigInteger von, @JsonProperty(value="bis") @NotNull BigInteger bis) {
            Intrinsics.checkNotNullParameter((Object)von, (String)"von");
            Intrinsics.checkNotNullParameter((Object)bis, (String)"bis");
            return this.of(Zeitpunkt.Companion.of(von), Zeitpunkt.Companion.of(bis));
        }

        @JvmStatic
        @NotNull
        public final Zeitdauer start() {
            return new Zeitdauer();
        }

        private static final Zeitdauer of$lambda$0(BigInteger n) {
            Intrinsics.checkNotNullParameter((Object)n, (String)"n");
            return new Zeitdauer(n);
        }

        private static final Zeitdauer of$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Zeitdauer)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Zeiteinheit.values().length];
            try {
                nArray[Zeiteinheit.WEEKS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Zeiteinheit.MONTHS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Zeiteinheit.YEARS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Zeiteinheit.DECADES.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Zeiteinheit.CENTURIES.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Zeiteinheit.MILLENNIA.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Zeiteinheit.ERAS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

