/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.jfachwert.FachwertFactory;
import de.jfachwert.KFachwert;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import patterntesting.runtime.junit.ImmutableTester;
import patterntesting.runtime.junit.ObjectTester;
import patterntesting.runtime.junit.SerializableTester;

public class FachwertTest {
    private static final Logger LOG = Logger.getLogger(FachwertTest.class.getName());
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private KFachwert fachwert;

    protected KFachwert createFachwert() {
        return FachwertFactory.getInstance().getFachwert("Name", new Serializable[]{"Oli B."});
    }

    @BeforeEach
    public void setUpFachwert() {
        this.fachwert = this.createFachwert();
    }

    @Test
    public void testImmutable() {
        ImmutableTester.assertImmutable(this.fachwert.getClass());
    }

    @Test
    public void testSerializable() throws NotSerializableException {
        MatcherAssert.assertThat((Object)this.fachwert, (Matcher)IsInstanceOf.instanceOf(Serializable.class));
        SerializableTester.assertSerialization((Serializable)this.fachwert);
    }

    @Test
    public void testToString() {
        String s = this.fachwert.toString();
        MatcherAssert.assertThat((String)"looks like default implementation", (Object)s, (Matcher)Matchers.not((Matcher)CoreMatchers.containsString((String)(this.fachwert.getClass().getName() + "@"))));
    }

    @Test
    public void testNotFinal() {
        Class<?> clazz = this.fachwert.getClass();
        if (!clazz.isEnum()) {
            Assertions.assertFalse((boolean)Modifier.isFinal(clazz.getModifiers()), (String)(clazz + " should be not final"));
        }
    }

    @Test
    public void testEquals() {
        KFachwert one = this.createFachwert();
        KFachwert anotherOne = this.createFachwert();
        ObjectTester.assertEquals((Object)one, (Object)anotherOne);
    }

    @Test
    public void testJsonSerialization() {
        String json = FachwertTest.marshal(this.fachwert);
        KFachwert deserialized = (KFachwert)FachwertTest.unmarshal(json, this.fachwert.getClass());
        Assertions.assertEquals((Object)this.fachwert, (Object)deserialized, (String)json);
    }

    protected static <T> String marshal(T obj) {
        try {
            StringWriter writer = new StringWriter();
            OBJECT_MAPPER.writeValue((Writer)writer, obj);
            writer.close();
            return writer.toString();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("could not marshal " + obj + " to JSON string", ex);
        }
    }

    protected static <T> T unmarshal(String json, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, clazz);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("could not unmarshall '" + json + "' to " + clazz, ex);
        }
    }

    protected static boolean forceGC() {
        Object key = new Object();
        WeakReference<Object> weakKeyRef = new WeakReference<Object>(key);
        Assertions.assertNotNull(weakKeyRef.get());
        key = null;
        try {
            for (int i = 0; i < 10 && weakKeyRef.get() != null; ++i) {
                System.gc();
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException ex) {
            LOG.log(Level.WARNING, "Das Warten auf den GC wurde abgebrochen:", ex);
        }
        return weakKeyRef.get() == null;
    }
}

