/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert;

import de.jfachwert.AbstractFachwert;
import de.jfachwert.FachwertTest;
import de.jfachwert.KFachwert;
import java.io.Serializable;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractFachwertTest<T extends Serializable, S extends AbstractFachwert<T, S>>
extends FachwertTest {
    private static final Logger LOG = Logger.getLogger(AbstractFachwertTest.class.getName());

    protected abstract AbstractFachwert<T, S> createFachwert(String var1);

    protected String getCode() {
        return Double.toString(3.14);
    }

    protected String getInvalidCode() {
        return "";
    }

    @Override
    protected KFachwert createFachwert() {
        return this.createFachwert(this.getCode());
    }

    @Test
    public void testNoDuplicate() {
        String s1 = this.getCode();
        String s2 = this.getCode();
        Assertions.assertNotSame((Object)s1, (Object)s2);
        AbstractFachwert<T, S> f1 = this.createFachwert(s1);
        AbstractFachwert<T, S> f2 = this.createFachwert(s2);
        Assertions.assertSame((Object)f1.getCode(), (Object)f2.getCode());
        Assertions.assertSame(f1, f2);
    }

    @Test
    public void testOfCaching() {
        String s = this.getCode();
        AbstractFachwert<T, S> f = this.createFachwert(s);
        if (AbstractFachwertTest.forceGC()) {
            Assertions.assertNotSame(f, this.createFachwert(s));
        } else {
            LOG.info("GC wurde nicht durchgefuehrt.");
        }
    }

    @Test
    public void isValid() {
        Assertions.assertTrue((boolean)this.createFachwert().isValid());
    }

    @Test
    public void suppressInvalid() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.createFachwert(this.getInvalidCode()));
    }
}

