/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.steuer;

import de.jfachwert.PruefzifferVerfahren;
import de.jfachwert.Text;
import de.jfachwert.pruefung.LengthValidator;
import de.jfachwert.pruefung.Mod11Verfahren;
import de.jfachwert.pruefung.NoopVerfahren;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lde/jfachwert/steuer/UStIdNr;", "Lde/jfachwert/Text;", "nr", "", "pzVerfahren", "Lde/jfachwert/PruefzifferVerfahren;", "<init>", "(Ljava/lang/String;Lde/jfachwert/PruefzifferVerfahren;)V", "(Ljava/lang/String;)V", "land", "Ljava/util/Locale;", "getLand", "()Ljava/util/Locale;", "Companion", "steuer"})
public class UStIdNr
extends Text {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final HashMap<String, PruefzifferVerfahren<String>> PRUEFZIFFER_VERFAHREN = new HashMap();
    @NotNull
    private static final WeakHashMap<String, UStIdNr> WEAK_CACHE = new WeakHashMap();

    public UStIdNr(@NotNull String nr, @NotNull PruefzifferVerfahren<String> pzVerfahren) {
        Intrinsics.checkNotNullParameter((Object)nr, (String)"nr");
        Intrinsics.checkNotNullParameter(pzVerfahren, (String)"pzVerfahren");
        super(UStIdNr.Companion.verify(nr, (PruefzifferVerfahren<String>)pzVerfahren), null, 2, null);
    }

    public /* synthetic */ UStIdNr(String string, PruefzifferVerfahren pruefzifferVerfahren, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            pruefzifferVerfahren = UStIdNr.Companion.selectPruefzifferVerfahrenFor(string);
        }
        this(string, (PruefzifferVerfahren<String>)pruefzifferVerfahren);
    }

    @NotNull
    public final Locale getLand() {
        return new Locale(UStIdNr.Companion.toLaenderkuerzel((String)((Object)this.getCode())));
    }

    public UStIdNr(@NotNull String nr) {
        Intrinsics.checkNotNullParameter((Object)nr, (String)"nr");
        this(nr, (PruefzifferVerfahren<String>)UStIdNr.Companion.selectPruefzifferVerfahrenFor(nr));
    }

    @JvmStatic
    @NotNull
    public static final UStIdNr of(@NotNull String nr) {
        return Companion.of(nr);
    }

    static {
        ((Map)PRUEFZIFFER_VERFAHREN).put("DE", new Mod11Verfahren(8));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0006H\u0007J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00072\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006J\u001e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007H\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/jfachwert/steuer/UStIdNr$Companion;", "", "<init>", "()V", "PRUEFZIFFER_VERFAHREN", "Ljava/util/HashMap;", "", "Lde/jfachwert/PruefzifferVerfahren;", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "Lde/jfachwert/steuer/UStIdNr;", "of", "nr", "selectPruefzifferVerfahrenFor", "validate", "verify", "verfahren", "toLaenderkuerzel", "steuer"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final UStIdNr of(@NotNull String nr) {
            Intrinsics.checkNotNullParameter((Object)nr, (String)"nr");
            char[] cArray = nr.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            String copy = new String(cArray);
            UStIdNr uStIdNr = WEAK_CACHE.computeIfAbsent(copy, UStIdNr::new);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)uStIdNr), (String)"computeIfAbsent(...)");
            return uStIdNr;
        }

        private final PruefzifferVerfahren<String> selectPruefzifferVerfahrenFor(String nr) {
            String laenderkuerzel = this.toLaenderkuerzel(nr);
            PruefzifferVerfahren verfahren = (PruefzifferVerfahren)PRUEFZIFFER_VERFAHREN.get(laenderkuerzel);
            if (verfahren == null) {
                verfahren = (PruefzifferVerfahren)new NoopVerfahren();
            }
            return verfahren;
        }

        @NotNull
        public final String validate(@NotNull String nr) {
            Intrinsics.checkNotNullParameter((Object)nr, (String)"nr");
            return (String)((Object)this.selectPruefzifferVerfahrenFor(nr).validate((Serializable)((Object)nr)));
        }

        private final String verify(String nr, PruefzifferVerfahren<String> verfahren) {
            String unformatted = StringUtils.remove((String)nr, (char)' ');
            Intrinsics.checkNotNull((Object)unformatted);
            LengthValidator.Companion.verify(unformatted, 7, 14);
            String string = unformatted.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            verfahren.verify((Serializable)((Object)string));
            return unformatted;
        }

        private final String toLaenderkuerzel(String nr) {
            new LengthValidator(7, 0, 2, null).verify((Serializable)((Object)nr));
            String string = nr.substring(0, 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            String kuerzel = string2;
            if (!StringUtils.isAlpha((CharSequence)kuerzel)) {
                throw new InvalidValueException((Serializable)((Object)nr), "country");
            }
            return kuerzel;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

