/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.steuer;

import de.jfachwert.KSimpleValidator;
import de.jfachwert.math.PackedDecimal;
import de.jfachwert.pruefung.LengthValidator;
import de.jfachwert.pruefung.NullValidator;
import de.jfachwert.steuer.Steuernummer;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u000b2\u00020\u0001:\u0002\n\u000bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\t\u00a8\u0006\f"}, d2={"Lde/jfachwert/steuer/SteuerIdNr;", "Lde/jfachwert/steuer/Steuernummer;", "idNr", "", "validator", "Lde/jfachwert/KSimpleValidator;", "Lde/jfachwert/math/PackedDecimal;", "<init>", "(Ljava/lang/String;Lde/jfachwert/KSimpleValidator;)V", "(Ljava/lang/String;)V", "Validator", "Companion", "steuer"})
public class SteuerIdNr
extends Steuernummer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Validator VALIDATOR = new Validator();
    @NotNull
    private static final WeakHashMap<String, SteuerIdNr> WEAK_CACHE = new WeakHashMap();
    @JvmField
    @NotNull
    public static final SteuerIdNr NULL = new SteuerIdNr("", (KSimpleValidator<PackedDecimal>)((KSimpleValidator)new NullValidator()));

    public SteuerIdNr(@NotNull String idNr, @NotNull KSimpleValidator<PackedDecimal> validator) {
        Intrinsics.checkNotNullParameter((Object)idNr, (String)"idNr");
        Intrinsics.checkNotNullParameter(validator, (String)"validator");
        super(idNr, validator);
    }

    public /* synthetic */ SteuerIdNr(String string, KSimpleValidator kSimpleValidator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            kSimpleValidator = VALIDATOR;
        }
        this(string, (KSimpleValidator<PackedDecimal>)kSimpleValidator);
    }

    public SteuerIdNr(@NotNull String idNr) {
        Intrinsics.checkNotNullParameter((Object)idNr, (String)"idNr");
        this(idNr, (KSimpleValidator<PackedDecimal>)((KSimpleValidator)VALIDATOR));
    }

    @JvmStatic
    @NotNull
    public static final SteuerIdNr of(@NotNull String idNr) {
        return Companion.of(idNr);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\bH\u0007J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/jfachwert/steuer/SteuerIdNr$Companion;", "", "<init>", "()V", "VALIDATOR", "Lde/jfachwert/steuer/SteuerIdNr$Validator;", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "", "Lde/jfachwert/steuer/SteuerIdNr;", "NULL", "of", "idNr", "validate", "nr", "steuer"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SteuerIdNr of(@NotNull String idNr) {
            Intrinsics.checkNotNullParameter((Object)idNr, (String)"idNr");
            char[] cArray = idNr.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            String copy = new String(cArray);
            SteuerIdNr steuerIdNr = WEAK_CACHE.computeIfAbsent(copy, arg_0 -> Companion.of$lambda$1(Companion::of$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)((Object)steuerIdNr), (String)"computeIfAbsent(...)");
            return steuerIdNr;
        }

        @NotNull
        public final String validate(@NotNull String nr) {
            Intrinsics.checkNotNullParameter((Object)nr, (String)"nr");
            return VALIDATOR.validate(nr);
        }

        private static final SteuerIdNr of$lambda$0(String nr) {
            Intrinsics.checkNotNull((Object)nr);
            return new SteuerIdNr(nr);
        }

        private static final SteuerIdNr of$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (SteuerIdNr)((Object)$tmp0.invoke(p0));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lde/jfachwert/steuer/SteuerIdNr$Validator;", "Lde/jfachwert/steuer/Steuernummer$Validator;", "<init>", "()V", "validate", "", "nr", "steuer"})
    public static class Validator
    extends Steuernummer.Validator {
        @Override
        @NotNull
        public String validate(@NotNull String nr) {
            Intrinsics.checkNotNullParameter((Object)nr, (String)"nr");
            LengthValidator.Companion.validate(nr, 11);
            return super.validate(nr);
        }
    }
}

