/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.steuer;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import de.jfachwert.KFachwert;
import de.jfachwert.math.AbstractNumber;
import de.jfachwert.math.Prozent;
import java.math.BigDecimal;
import java.util.Map;
import java.util.WeakHashMap;
import javax.money.MonetaryAmount;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=ToStringSerializer.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0017\u0018\u0000 \u001b2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u001bB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rJ\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u0016\u001a\u00020\bH\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u0014H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lde/jfachwert/steuer/Mehrwertsteuer;", "Lde/jfachwert/KFachwert;", "", "prozent", "Lde/jfachwert/math/Prozent;", "<init>", "(Lde/jfachwert/math/Prozent;)V", "satz", "", "(Ljava/lang/String;)V", "getProzent", "()Lde/jfachwert/math/Prozent;", "nettoZuBrutto", "Ljavax/money/MonetaryAmount;", "netto", "bruttoZuNetto", "brutto", "betragVonBrutto", "betragVonNetto", "compareTo", "", "other", "toString", "equals", "", "", "hashCode", "Companion", "steuer"})
public class Mehrwertsteuer
implements KFachwert,
Comparable<Mehrwertsteuer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Prozent prozent;
    @NotNull
    private static final WeakHashMap<Prozent, Mehrwertsteuer> WEAK_CACHE = new WeakHashMap();
    @JvmField
    @NotNull
    public static final Mehrwertsteuer DE_NORMAL = Companion.of("19%");
    @JvmField
    @NotNull
    public static final Mehrwertsteuer DE_REDUZIERT = Companion.of("7%");
    @JvmField
    @NotNull
    public static final Mehrwertsteuer CH_NORMAL = Companion.of("7.7%");
    @JvmField
    @NotNull
    public static final Mehrwertsteuer CH_REDUZIERT = Companion.of("2.5%");
    @JvmField
    @NotNull
    public static final Mehrwertsteuer CH_SONDER = Companion.of("3.7%");

    public Mehrwertsteuer(@NotNull Prozent prozent) {
        Intrinsics.checkNotNullParameter((Object)prozent, (String)"prozent");
        this.prozent = prozent;
    }

    @NotNull
    public final Prozent getProzent() {
        return this.prozent;
    }

    public Mehrwertsteuer(@NotNull String satz) {
        Intrinsics.checkNotNullParameter((Object)satz, (String)"satz");
        this(Prozent.Companion.of(satz));
    }

    @NotNull
    public final MonetaryAmount nettoZuBrutto(@NotNull MonetaryAmount netto) {
        Intrinsics.checkNotNullParameter((Object)netto, (String)"netto");
        MonetaryAmount monetaryAmount = netto.add(this.betragVonNetto(netto));
        Intrinsics.checkNotNullExpressionValue((Object)monetaryAmount, (String)"add(...)");
        return monetaryAmount;
    }

    @NotNull
    public final MonetaryAmount bruttoZuNetto(@NotNull MonetaryAmount brutto) {
        Intrinsics.checkNotNullParameter((Object)brutto, (String)"brutto");
        MonetaryAmount monetaryAmount = brutto.divide((Number)BigDecimal.ONE.add(this.prozent.toBigDecimal()));
        Intrinsics.checkNotNullExpressionValue((Object)monetaryAmount, (String)"divide(...)");
        return monetaryAmount;
    }

    @NotNull
    public final MonetaryAmount betragVonBrutto(@NotNull MonetaryAmount brutto) {
        Intrinsics.checkNotNullParameter((Object)brutto, (String)"brutto");
        MonetaryAmount monetaryAmount = brutto.subtract(this.bruttoZuNetto(brutto));
        Intrinsics.checkNotNullExpressionValue((Object)monetaryAmount, (String)"subtract(...)");
        return monetaryAmount;
    }

    @NotNull
    public final MonetaryAmount betragVonNetto(@NotNull MonetaryAmount netto) {
        Intrinsics.checkNotNullParameter((Object)netto, (String)"netto");
        MonetaryAmount monetaryAmount = netto.multiply((Number)this.prozent);
        Intrinsics.checkNotNullExpressionValue((Object)monetaryAmount, (String)"multiply(...)");
        return monetaryAmount;
    }

    @Override
    public int compareTo(@NotNull Mehrwertsteuer other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.prozent.compareTo((AbstractNumber)other.prozent);
    }

    @NotNull
    public String toString() {
        return this.prozent.toString();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Mehrwertsteuer)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.prozent, (Object)((Mehrwertsteuer)other).prozent);
    }

    public int hashCode() {
        return this.prozent.hashCode();
    }

    @NotNull
    public Map<String, Object> toMap() {
        return KFachwert.DefaultImpls.toMap((KFachwert)this);
    }

    public boolean isValid() {
        return KFachwert.DefaultImpls.isValid((KFachwert)this);
    }

    @JvmStatic
    @NotNull
    public static final Mehrwertsteuer of(@NotNull String satz) {
        return Companion.of(satz);
    }

    @JvmStatic
    @NotNull
    public static final Mehrwertsteuer of(@NotNull Prozent satz) {
        return Companion.of(satz);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0006H\u0007R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/jfachwert/steuer/Mehrwertsteuer$Companion;", "", "<init>", "()V", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "Lde/jfachwert/math/Prozent;", "Lde/jfachwert/steuer/Mehrwertsteuer;", "DE_NORMAL", "DE_REDUZIERT", "CH_NORMAL", "CH_REDUZIERT", "CH_SONDER", "of", "satz", "", "steuer"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Mehrwertsteuer of(@NotNull String satz) {
            Intrinsics.checkNotNullParameter((Object)satz, (String)"satz");
            return this.of(Prozent.Companion.of(satz));
        }

        @JvmStatic
        @NotNull
        public final Mehrwertsteuer of(@NotNull Prozent satz) {
            Intrinsics.checkNotNullParameter((Object)satz, (String)"satz");
            Mehrwertsteuer mehrwertsteuer = WEAK_CACHE.computeIfAbsent(satz, Mehrwertsteuer::new);
            Intrinsics.checkNotNullExpressionValue((Object)mehrwertsteuer, (String)"computeIfAbsent(...)");
            return mehrwertsteuer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

