/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.post;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.jfachwert.KFachwert;
import de.jfachwert.post.Ort;
import de.jfachwert.post.PLZ;
import de.jfachwert.pruefung.exception.InvalidValueException;
import de.jfachwert.pruefung.exception.LocalizedIllegalArgumentException;
import de.jfachwert.pruefung.exception.ValidationException;
import de.jfachwert.util.ToFachwertSerializer;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=ToFachwertSerializer.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0017\u0018\u0000 *2\u00020\u0001:\u0001*B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0017\b\u0012\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0004\b\u0004\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\fB\u001d\b\u0017\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000e\u00a2\u0006\u0004\b\u0004\u0010\u000fB\u0019\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\u0011B\u0019\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u0012\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\u0013B\u001f\b\u0016\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\u0015J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0096\u0002J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u0003H\u0016J\u0014\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020%0\u000eH\u0016R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0019\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001b\u00a8\u0006+"}, d2={"Lde/jfachwert/post/Postfach;", "Lde/jfachwert/KFachwert;", "postfach", "", "<init>", "(Ljava/lang/String;)V", "", "([Ljava/lang/String;)V", "ort", "Lde/jfachwert/post/Ort;", "(Lde/jfachwert/post/Ort;)V", "nummer", "(Ljava/lang/String;Ljava/lang/String;)V", "map", "", "(Ljava/util/Map;)V", "", "(JLde/jfachwert/post/Ort;)V", "Ljava/math/BigInteger;", "(Ljava/math/BigInteger;Lde/jfachwert/post/Ort;)V", "Ljava/util/Optional;", "(Ljava/util/Optional;Lde/jfachwert/post/Ort;)V", "getOrt", "()Lde/jfachwert/post/Ort;", "getNummer", "nummerFormatted", "getNummerFormatted", "()Ljava/lang/String;", "pLZ", "Lde/jfachwert/post/PLZ;", "getPLZ", "()Lde/jfachwert/post/PLZ;", "ortsname", "getOrtsname", "equals", "", "other", "", "hashCode", "", "toString", "toMap", "Companion", "post"})
@SourceDebugExtension(value={"SMAP\nPostfach.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Postfach.kt\nde/jfachwert/post/Postfach\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,387:1\n1#2:388\n108#3:389\n80#3,22:390\n*S KotlinDebug\n*F\n+ 1 Postfach.kt\nde/jfachwert/post/Postfach\n*L\n166#1:389\n166#1:390,22\n*E\n"})
public class Postfach
implements KFachwert {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final BigInteger nummer;
    @NotNull
    private final Ort ort;
    @JvmField
    @NotNull
    public static final Postfach NULL = new Postfach(Ort.NULL);

    @NotNull
    public final Ort getOrt() {
        return this.ort;
    }

    public Postfach(@NotNull String postfach) {
        Intrinsics.checkNotNullParameter((Object)postfach, (String)"postfach");
        this(Postfach.Companion.split(postfach));
    }

    private Postfach(String[] postfach) {
        this(postfach[0], postfach[1]);
    }

    public Postfach(@NotNull Ort ort) {
        Intrinsics.checkNotNullParameter((Object)ort, (String)"ort");
        this.ort = ort;
        this.nummer = null;
        Companion.validate(ort);
    }

    public Postfach(@NotNull String nummer, @NotNull String ort) {
        Intrinsics.checkNotNullParameter((Object)nummer, (String)"nummer");
        Intrinsics.checkNotNullParameter((Object)ort, (String)"ort");
        this(Postfach.Companion.toNumber(nummer), Postfach.Companion.toOrt(ort));
    }

    @JsonCreator
    public Postfach(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        String string = map.get("nummer");
        Intrinsics.checkNotNull((Object)string);
        Optional optional = Postfach.Companion.toNumber(string);
        String string2 = map.get("plz");
        Intrinsics.checkNotNull((Object)string2);
        PLZ pLZ = PLZ.Companion.of(string2);
        String string3 = map.get("ortsname");
        Intrinsics.checkNotNull((Object)string3);
        this(optional, new Ort(pLZ, string3, null, 4, null));
    }

    public Postfach(long nummer, @NotNull Ort ort) {
        Intrinsics.checkNotNullParameter((Object)ort, (String)"ort");
        BigInteger bigInteger = BigInteger.valueOf(nummer);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
        this(bigInteger, ort);
    }

    public Postfach(@NotNull BigInteger nummer, @NotNull Ort ort) {
        Intrinsics.checkNotNullParameter((Object)nummer, (String)"nummer");
        Intrinsics.checkNotNullParameter((Object)ort, (String)"ort");
        this.nummer = nummer;
        this.ort = ort;
        Postfach.Companion.verify(nummer, ort);
    }

    public Postfach(@NotNull Optional<BigInteger> nummer, @NotNull Ort ort) {
        Intrinsics.checkNotNullParameter(nummer, (String)"nummer");
        Intrinsics.checkNotNullParameter((Object)ort, (String)"ort");
        this.nummer = nummer.orElse(null);
        this.ort = ort;
        if (this.nummer == null) {
            Postfach.Companion.verify(ort);
        } else {
            BigInteger bigInteger = nummer.get();
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"get(...)");
            Postfach.Companion.verify(bigInteger, ort);
        }
    }

    @NotNull
    public final Optional<BigInteger> getNummer() {
        Optional<BigInteger> optional;
        if (this.nummer == null) {
            Optional<BigInteger> optional2 = Optional.empty();
            Intrinsics.checkNotNull(optional2);
            optional = optional2;
        } else {
            Optional<BigInteger> optional3 = Optional.of(this.nummer);
            Intrinsics.checkNotNull(optional3);
            optional = optional3;
        }
        return optional;
    }

    @NotNull
    public final String getNummerFormatted() {
        if (!this.getNummer().isPresent()) {
            boolean $i$a$-check-Postfach$nummerFormatted$22 = false;
            String $i$a$-check-Postfach$nummerFormatted$22 = "no number present";
            throw new IllegalStateException($i$a$-check-Postfach$nummerFormatted$22.toString());
        }
        BigInteger hundert = BigInteger.valueOf(100L);
        StringBuilder formatted = new StringBuilder();
        BigInteger bigInteger = this.getNummer().get();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"get(...)");
        BigInteger i = bigInteger;
        while (i.compareTo(BigInteger.ONE) > 0) {
            formatted.insert(0, " " + i.remainder(hundert));
            i = i.divide(hundert);
        }
        String string = formatted.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String $this$trim$iv = string;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
    }

    @NotNull
    public final PLZ getPLZ() {
        PLZ pLZ = this.ort.getPLZ().get();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)pLZ), (String)"get(...)");
        return pLZ;
    }

    @NotNull
    public final String getOrtsname() {
        return this.ort.getName();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Postfach)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.nummer, (Object)((Postfach)other).nummer) && this.ort.equals(((Postfach)other).ort);
    }

    public int hashCode() {
        return this.ort.hashCode();
    }

    @NotNull
    public String toString() {
        if (this.getNummer().isPresent()) {
            String s = "Postfach " + this.getNummerFormatted();
            if (this.ort == Ort.NULL) {
                return s;
            }
            return s + ", " + this.ort;
        }
        return this.ort.toString();
    }

    @NotNull
    public Map<String, Object> toMap() {
        Map map = new HashMap();
        map.put("plz", this.getPLZ());
        map.put("ortsname", this.getOrtsname());
        if (this.nummer != null) {
            map.put("nummer", this.nummer);
        }
        return map;
    }

    public boolean isValid() {
        return KFachwert.DefaultImpls.isValid((KFachwert)this);
    }

    @JvmStatic
    @NotNull
    public static final Postfach of(@NotNull String postfach) {
        return Companion.of(postfach);
    }

    @JvmStatic
    @NotNull
    public static final Postfach of(long nummer, @NotNull Ort ort) {
        return Companion.of(nummer, ort);
    }

    @JvmStatic
    @NotNull
    public static final Postfach of(@NotNull BigInteger nummer, @NotNull Ort ort) {
        return Companion.of(nummer, ort);
    }

    @JvmStatic
    public static final void validate(@NotNull String postfach) {
        Companion.validate(postfach);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/jfachwert/post/Postfach$Companion;", "", "<init>", "()V", "NULL", "Lde/jfachwert/post/Postfach;", "of", "postfach", "", "nummer", "", "ort", "Lde/jfachwert/post/Ort;", "Ljava/math/BigInteger;", "validate", "", "split", "", "(Ljava/lang/String;)[Ljava/lang/String;", "toNumber", "Ljava/util/Optional;", "number", "toOrt", "verify", "post"})
    @SourceDebugExtension(value={"SMAP\nPostfach.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Postfach.kt\nde/jfachwert/post/Postfach$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,387:1\n37#2,2:388\n*S KotlinDebug\n*F\n+ 1 Postfach.kt\nde/jfachwert/post/Postfach$Companion\n*L\n312#1:388,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Postfach of(@NotNull String postfach) {
            Intrinsics.checkNotNullParameter((Object)postfach, (String)"postfach");
            return new Postfach(postfach);
        }

        @JvmStatic
        @NotNull
        public final Postfach of(long nummer, @NotNull Ort ort) {
            Intrinsics.checkNotNullParameter((Object)ort, (String)"ort");
            return new Postfach(nummer, ort);
        }

        @JvmStatic
        @NotNull
        public final Postfach of(@NotNull BigInteger nummer, @NotNull Ort ort) {
            Intrinsics.checkNotNullParameter((Object)nummer, (String)"nummer");
            Intrinsics.checkNotNullParameter((Object)ort, (String)"ort");
            return new Postfach(nummer, ort);
        }

        @JvmStatic
        public final void validate(@NotNull String postfach) {
            Ort ort;
            Intrinsics.checkNotNullParameter((Object)postfach, (String)"postfach");
            String[] lines = this.split(postfach);
            if (this.toNumber(lines[0]).isEmpty() && this.toNumber(lines[1]).isEmpty() && !(ort = new Ort(lines[1])).getPLZ().isPresent()) {
                throw new InvalidValueException((Serializable)((Object)postfach), "postal_code");
            }
        }

        private final String[] split(String postfach) {
            String string = StringUtils.trimToEmpty((String)postfach);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimToEmpty(...)");
            CharSequence charSequence = string;
            Regex regex = new Regex("[,\\n$]");
            int n = 0;
            Collection $this$toTypedArray$iv = regex.split(charSequence, n);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] lines = thisCollection$iv.toArray(new String[0]);
            String[] stringArray = new String[]{"", lines[0]};
            String[] splitted = stringArray;
            if (lines.length == 2) {
                splitted = lines;
            } else if (lines.length > 2) {
                throw new InvalidValueException((Serializable)((Object)postfach), "post_office_box");
            }
            stringArray = splitted[1];
            if (new Regex("\\s").containsMatchIn((CharSequence)stringArray)) {
                return splitted;
            }
            stringArray = new String[]{splitted[1], ""};
            return stringArray;
        }

        private final Optional<BigInteger> toNumber(String number) {
            Optional<BigInteger> optional;
            if (StringUtils.isBlank((CharSequence)number)) {
                Optional<BigInteger> optional2 = Optional.empty();
                Intrinsics.checkNotNullExpressionValue(optional2, (String)"empty(...)");
                return optional2;
            }
            String unformatted = RegExUtils.replaceAll((String)number, (String)"Postfach|\\s+", (String)"");
            try {
                optional = Optional.of(new BigInteger(unformatted));
            }
            catch (NumberFormatException nfe) {
                throw new InvalidValueException((Serializable)((Object)number), "number", (Throwable)nfe);
            }
            return optional;
        }

        private final Ort toOrt(String ort) {
            if (StringUtils.isBlank((CharSequence)ort)) {
                return Ort.NULL;
            }
            return new Ort(ort);
        }

        public final void validate(@NotNull BigInteger nummer, @NotNull Ort ort) {
            Intrinsics.checkNotNullParameter((Object)nummer, (String)"nummer");
            Intrinsics.checkNotNullParameter((Object)ort, (String)"ort");
            if (nummer.compareTo(BigInteger.ONE) < 0) {
                throw new InvalidValueException((Serializable)nummer, "number");
            }
            this.validate(ort);
        }

        private final void verify(BigInteger nummer, Ort ort) {
            try {
                this.validate(nummer, ort);
            }
            catch (ValidationException ex) {
                throw new LocalizedIllegalArgumentException((Throwable)ex);
            }
        }

        public final void validate(@NotNull Ort ort) {
            Intrinsics.checkNotNullParameter((Object)ort, (String)"ort");
            if (!ort.getPLZ().isPresent()) {
                throw new InvalidValueException((Serializable)((Object)ort), "postal_code");
            }
        }

        private final void verify(Ort ort) {
            try {
                this.validate(ort);
            }
            catch (ValidationException ex) {
                throw new LocalizedIllegalArgumentException((Throwable)ex);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

