/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.post;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import de.jfachwert.KFachwert;
import de.jfachwert.KSimpleValidator;
import de.jfachwert.Text;
import de.jfachwert.post.PLZ;
import de.jfachwert.pruefung.LengthValidator;
import de.jfachwert.pruefung.NullValidator;
import de.jfachwert.pruefung.exception.LocalizedIllegalArgumentException;
import de.jfachwert.pruefung.exception.ValidationException;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=ToStringSerializer.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0017\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB+\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\nB\u0017\b\u0012\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f\u00a2\u0006\u0004\b\b\u0010\rJ\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0005H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lde/jfachwert/post/Ort;", "Lde/jfachwert/KFachwert;", "plz", "Lde/jfachwert/post/PLZ;", "name", "", "validator", "Lde/jfachwert/KSimpleValidator;", "<init>", "(Lde/jfachwert/post/PLZ;Ljava/lang/String;Lde/jfachwert/KSimpleValidator;)V", "(Ljava/lang/String;)V", "values", "", "([Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "pLZ", "Ljava/util/Optional;", "getPLZ", "()Ljava/util/Optional;", "equals", "", "other", "", "equalsExact", "hashCode", "", "toString", "Companion", "post"})
public class Ort
implements KFachwert {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final PLZ plz;
    @NotNull
    private final String name;
    @NotNull
    private static final KSimpleValidator<String> VALIDATOR = (KSimpleValidator)new LengthValidator(1, 0, 2, null);
    private static final Logger log = Logger.getLogger(Ort.class.getName());
    @JvmField
    @NotNull
    public static final Ort NULL = new Ort(PLZ.NULL, "", (KSimpleValidator<String>)((KSimpleValidator)new NullValidator()));

    @JvmOverloads
    public Ort(@Nullable PLZ plz, @NotNull String name, @NotNull KSimpleValidator<String> validator) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(validator, (String)"validator");
        this.plz = plz;
        this.name = Ort.Companion.verify(name, (KSimpleValidator<String>)validator);
    }

    public /* synthetic */ Ort(PLZ pLZ, String string, KSimpleValidator kSimpleValidator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            kSimpleValidator = VALIDATOR;
        }
        this(pLZ, string, kSimpleValidator);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public Ort(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(Ort.Companion.split(name));
    }

    private Ort(String[] values) {
        this(((CharSequence)values[0]).length() == 0 ? null : new PLZ(values[0]), values[1], null, 4, null);
    }

    @NotNull
    public final Optional<PLZ> getPLZ() {
        Optional<PLZ> optional;
        if (this.plz == null) {
            Optional<PLZ> optional2 = Optional.empty();
            Intrinsics.checkNotNull(optional2);
            optional = optional2;
        } else {
            Optional<PLZ> optional3 = Optional.of(this.plz);
            Intrinsics.checkNotNull(optional3);
            optional = optional3;
        }
        return optional;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Ort)) {
            return false;
        }
        String thisName = Text.Companion.replaceUmlaute(this.name);
        String otherName = Text.Companion.replaceUmlaute(((Ort)other).name);
        return this.plz == null || ((Ort)other).plz == null ? StringsKt.equals((String)thisName, (String)otherName, (boolean)true) : Intrinsics.areEqual((Object)((Object)this.plz), (Object)((Object)((Ort)other).plz)) && Character.toLowerCase(thisName.charAt(0)) == Character.toLowerCase(otherName.charAt(0));
    }

    public final boolean equalsExact(@NotNull Ort other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)((Object)this.plz), (Object)((Object)other.plz)) && Intrinsics.areEqual((Object)this.name, (Object)other.name);
    }

    public int hashCode() {
        return Character.toUpperCase(Text.Companion.replaceUmlaute(this.name).charAt(0));
    }

    @NotNull
    public String toString() {
        return this.plz == null ? this.name : this.plz + " " + this.name;
    }

    @NotNull
    public Map<String, Object> toMap() {
        return KFachwert.DefaultImpls.toMap((KFachwert)this);
    }

    public boolean isValid() {
        return KFachwert.DefaultImpls.isValid((KFachwert)this);
    }

    @JvmOverloads
    public Ort(@Nullable PLZ plz, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(plz, name, null, 4, null);
    }

    @JvmStatic
    @NotNull
    public static final Ort of(@NotNull String name) {
        return Companion.of(name);
    }

    @JvmStatic
    @NotNull
    public static final Ort of(@NotNull PLZ plz, @NotNull String name) {
        return Companion.of(plz, name);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006J\u001e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u001e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u001b\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u000e\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/jfachwert/post/Ort$Companion;", "", "<init>", "()V", "VALIDATOR", "Lde/jfachwert/KSimpleValidator;", "", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "Ljava/util/logging/Logger;", "NULL", "Lde/jfachwert/post/Ort;", "of", "name", "plz", "Lde/jfachwert/post/PLZ;", "validate", "validator", "verify", "split", "", "(Ljava/lang/String;)[Ljava/lang/String;", "post"})
    @SourceDebugExtension(value={"SMAP\nOrt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Ort.kt\nde/jfachwert/post/Ort$Companion\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,227:1\n108#2:228\n80#2,22:229\n*S KotlinDebug\n*F\n+ 1 Ort.kt\nde/jfachwert/post/Ort$Companion\n*L\n217#1:228\n217#1:229,22\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Ort of(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Ort(name);
        }

        @JvmStatic
        @NotNull
        public final Ort of(@NotNull PLZ plz, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)((Object)plz), (String)"plz");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Ort(plz, name, null, 4, null);
        }

        @NotNull
        public final String validate(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.validate(name, (KSimpleValidator<String>)VALIDATOR);
        }

        private final String validate(String name, KSimpleValidator<String> validator) {
            String[] splitted = this.split(name);
            String ortsname = splitted[1];
            validator.validate((Serializable)((Object)ortsname));
            return name;
        }

        private final String verify(String name, KSimpleValidator<String> validator) {
            String string;
            try {
                string = this.validate(name, validator);
            }
            catch (ValidationException ex) {
                throw new LocalizedIllegalArgumentException((Throwable)ex);
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final String[] split(String name) {
            String input = StringUtils.trimToEmpty((String)name);
            String[] stringArray = new String[]{"", input};
            String[] splitted = stringArray;
            Intrinsics.checkNotNull((Object)input);
            if (StringsKt.contains$default((CharSequence)input, (CharSequence)" ", (boolean)false, (int)2, null)) {
                try {
                    String string;
                    void $this$trim$iv;
                    String plz;
                    PLZ.Validator validator = new PLZ.Validator();
                    String string2 = StringUtils.substringBefore((String)input, (String)" ");
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substringBefore(...)");
                    splitted[0] = plz = validator.validate(string2);
                    String string3 = StringUtils.substringAfter((String)input, (String)" ");
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substringAfter(...)");
                    String string4 = string3;
                    int n = 1;
                    String[] stringArray2 = splitted;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    stringArray2[n] = string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                }
                catch (ValidationException ex) {
                    log.log(Level.FINE, "keine PLZ in '" + name + "' gefunden.");
                    log.log(Level.FINER, "Details:", ex);
                }
            }
            return splitted;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

