/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.post;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.jfachwert.KFachwert;
import de.jfachwert.post.Adressat;
import de.jfachwert.post.Adresse;
import de.jfachwert.post.Postfach;
import de.jfachwert.pruefung.exception.InvalidValueException;
import de.jfachwert.pruefung.exception.ValidationException;
import de.jfachwert.util.ToFachwertSerializer;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=ToFachwertSerializer.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0017\u0018\u0000 $2\u00020\u0001:\u0001$B%\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fB\u0019\b\u0012\u0012\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r\u00a2\u0006\u0004\b\b\u0010\u000fB\u001d\b\u0017\u0012\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0\u0011\u00a2\u0006\u0004\b\b\u0010\u0012B\u001b\b\u0016\u0012\u0006\u0010\u0013\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\u0014B\u001b\b\u0016\u0012\u0006\u0010\u0013\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\u0015J\u0006\u0010\u001a\u001a\u00020\u0005J\u0006\u0010\u001b\u001a\u00020\u0007J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0013\u0010\u001e\u001a\u00020\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u000bH\u0016J\u0014\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006%"}, d2={"Lde/jfachwert/post/Anschrift;", "Lde/jfachwert/KFachwert;", "adressat", "Lde/jfachwert/post/Adressat;", "adresse", "Lde/jfachwert/post/Adresse;", "postfach", "Lde/jfachwert/post/Postfach;", "<init>", "(Lde/jfachwert/post/Adressat;Lde/jfachwert/post/Adresse;Lde/jfachwert/post/Postfach;)V", "anschrift", "", "(Ljava/lang/String;)V", "", "", "([Ljava/lang/Object;)V", "map", "", "(Ljava/util/Map;)V", "name", "(Lde/jfachwert/post/Adressat;Lde/jfachwert/post/Adresse;)V", "(Lde/jfachwert/post/Adressat;Lde/jfachwert/post/Postfach;)V", "getAdressat", "()Lde/jfachwert/post/Adressat;", "getName", "()Ljava/lang/String;", "getAdresse", "getPostfach", "hasPostfach", "", "equals", "other", "hashCode", "", "toString", "toMap", "Companion", "post"})
@SourceDebugExtension(value={"SMAP\nAnschrift.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Anschrift.kt\nde/jfachwert/post/Anschrift\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,272:1\n1#2:273\n*E\n"})
public class Anschrift
implements KFachwert {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Adressat adressat;
    @Nullable
    private final Adresse adresse;
    @Nullable
    private final Postfach postfach;
    private static final Logger log = Logger.getLogger(Anschrift.class.getName());
    @NotNull
    private static final String ADDRESS = "address";
    @JvmField
    @NotNull
    public static final Anschrift NULL = new Anschrift(Adressat.NULL, Adresse.NULL);

    private Anschrift(Adressat adressat, Adresse adresse, Postfach postfach) {
        this.adressat = adressat;
        this.adresse = adresse;
        this.postfach = postfach;
        if (this.adresse == null) {
            if (this.postfach == null) {
                throw new InvalidValueException("post_office_box");
            }
        } else if (this.postfach != null) {
            throw new InvalidValueException((Serializable)((Object)this.adresse), ADDRESS);
        }
    }

    @NotNull
    public final Adressat getAdressat() {
        return this.adressat;
    }

    public Anschrift(@NotNull String anschrift) {
        Intrinsics.checkNotNullParameter((Object)anschrift, (String)"anschrift");
        this(Anschrift.Companion.split(anschrift));
    }

    private Anschrift(Object[] anschrift) {
        this(new Adressat(String.valueOf(anschrift[0]), null, 2, null), (Adresse)anschrift[1], (Postfach)anschrift[2]);
    }

    @JsonCreator
    public Anschrift(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Adressat adressat = new Adressat(String.valueOf(map.get("adressat")), null, 2, null);
        Object object = map.get("adresse");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
        this(adressat, new Adresse((Map)object));
    }

    public Anschrift(@NotNull Adressat name, @Nullable Adresse adresse) {
        Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
        this(name, adresse, null);
    }

    public Anschrift(@NotNull Adressat name, @Nullable Postfach postfach) {
        Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
        this(name, null, postfach);
    }

    @NotNull
    public final String getName() {
        return this.adressat.getName();
    }

    @NotNull
    public final Adresse getAdresse() {
        if (this.adresse == null) {
            boolean bl = false;
            String string = "no address available";
            throw new IllegalStateException(string.toString());
        }
        return this.adresse;
    }

    @NotNull
    public final Postfach getPostfach() {
        if (this.postfach == null) {
            boolean bl = false;
            String string = "no post office box available";
            throw new IllegalStateException(string.toString());
        }
        return this.postfach;
    }

    public final boolean hasPostfach() {
        return this.postfach != null;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Anschrift)) {
            return false;
        }
        return StringsKt.equals((String)this.getName(), (String)((Anschrift)other).getName(), (boolean)true) && this.getAdresse().equals(((Anschrift)other).getAdresse());
    }

    public int hashCode() {
        return this.adressat.hashCode();
    }

    @NotNull
    public String toString() {
        return this.getName() + ", " + (this.hasPostfach() ? (KFachwert)this.getPostfach() : (KFachwert)this.getAdresse());
    }

    @NotNull
    public Map<String, Object> toMap() {
        Map map = new HashMap();
        map.put("adressat", this.adressat);
        map.put("adresse", this.getAdresse());
        return map;
    }

    public boolean isValid() {
        return KFachwert.DefaultImpls.isValid((KFachwert)this);
    }

    @JvmStatic
    @NotNull
    public static final Anschrift of(@NotNull String anschrift) {
        return Companion.of(anschrift);
    }

    @JvmStatic
    @NotNull
    public static final Anschrift of(@NotNull Adressat name, @NotNull Postfach postfach) {
        return Companion.of(name, postfach);
    }

    @JvmStatic
    @NotNull
    public static final Anschrift of(@NotNull Adressat name, @NotNull Adresse adresse) {
        return Companion.of(name, adresse);
    }

    @JvmStatic
    public static final void validate(@NotNull String anschrift) {
        Companion.validate(anschrift);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\tH\u0007J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\tH\u0007J\u001d\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00172\u0006\u0010\r\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0018R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/jfachwert/post/Anschrift$Companion;", "", "<init>", "()V", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "Ljava/util/logging/Logger;", "ADDRESS", "", "NULL", "Lde/jfachwert/post/Anschrift;", "of", "anschrift", "name", "Lde/jfachwert/post/Adressat;", "postfach", "Lde/jfachwert/post/Postfach;", "adresse", "Lde/jfachwert/post/Adresse;", "validate", "", "split", "", "(Ljava/lang/String;)[Ljava/lang/Object;", "post"})
    @SourceDebugExtension(value={"SMAP\nAnschrift.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Anschrift.kt\nde/jfachwert/post/Anschrift$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,272:1\n37#2,2:273\n108#3:275\n80#3,22:276\n*S KotlinDebug\n*F\n+ 1 Anschrift.kt\nde/jfachwert/post/Anschrift$Companion\n*L\n252#1:273,2\n258#1:275\n258#1:276,22\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Anschrift of(@NotNull String anschrift) {
            Intrinsics.checkNotNullParameter((Object)anschrift, (String)"anschrift");
            return new Anschrift(anschrift);
        }

        @JvmStatic
        @NotNull
        public final Anschrift of(@NotNull Adressat name, @NotNull Postfach postfach) {
            Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
            Intrinsics.checkNotNullParameter((Object)postfach, (String)"postfach");
            return new Anschrift(name, postfach);
        }

        @JvmStatic
        @NotNull
        public final Anschrift of(@NotNull Adressat name, @NotNull Adresse adresse) {
            Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
            Intrinsics.checkNotNullParameter((Object)adresse, (String)"adresse");
            return new Anschrift(name, adresse);
        }

        @JvmStatic
        public final void validate(@NotNull String anschrift) {
            Intrinsics.checkNotNullParameter((Object)anschrift, (String)"anschrift");
            this.split(anschrift);
        }

        /*
         * WARNING - void declaration
         */
        private final Object[] split(String anschrift) {
            void $this$trim$iv;
            String string = StringUtils.trimToEmpty((String)anschrift);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimToEmpty(...)");
            CharSequence charSequence = string;
            String string2 = "[,\\n$]";
            int n = 0;
            Pattern pattern = Pattern.compile(string2, n);
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)charSequence, (Pattern)pattern, (int)0, (int)2, null);
            boolean $i$f$toTypedArray = false;
            Object thisCollection$iv = $this$toTypedArray$iv;
            String[] lines = thisCollection$iv.toArray(new String[0]);
            if (lines.length < 2) {
                throw new InvalidValueException((Serializable)((Object)anschrift), Anschrift.ADDRESS);
            }
            Object[] parts = new Object[3];
            parts[0] = new Adressat(lines[0], null, 2, null);
            String string3 = anschrift.substring(lines[0].length() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            thisCollection$iv = string3;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String adresseOrPostfach = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            try {
                parts[1] = null;
                parts[2] = new Postfach(adresseOrPostfach);
            }
            catch (ValidationException ex) {
                log.log(Level.FINE, "'" + adresseOrPostfach + "' ist kein Postfach.");
                log.log(Level.FINER, "Details:", ex);
                parts[1] = new Adresse(adresseOrPostfach);
                parts[2] = null;
            }
            return parts;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

