/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.net;

import de.jfachwert.KSimpleValidator;
import de.jfachwert.Text;
import de.jfachwert.math.PackedDecimal;
import de.jfachwert.pruefung.LengthValidator;
import de.jfachwert.pruefung.NullValidator;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.util.Collection;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 $2\u00020\u0001:\u0002#$B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\u0006\u0010\u001d\u001a\u00020\u0003J\u0006\u0010\u001e\u001a\u00020\u0003J\u0006\u0010\u001f\u001a\u00020\u0003J\u0006\u0010 \u001a\u00020\tJ\u0006\u0010!\u001a\u00020\"R\u0011\u0010\u000b\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\r\u00a8\u0006%"}, d2={"Lde/jfachwert/net/Telefonnummer;", "Lde/jfachwert/Text;", "nummer", "", "validator", "Lde/jfachwert/KSimpleValidator;", "<init>", "(Ljava/lang/String;Lde/jfachwert/KSimpleValidator;)V", "uri", "Ljava/net/URI;", "(Ljava/net/URI;)V", "inlandsnummer", "getInlandsnummer", "()Lde/jfachwert/net/Telefonnummer;", "laenderkennzahl", "Ljava/util/Optional;", "getLaenderkennzahl", "()Ljava/util/Optional;", "vorwahl", "getVorwahl", "()Ljava/lang/String;", "rufnummer", "getRufnummer", "hashCode", "", "equals", "", "other", "", "toShortString", "toDinString", "toE123String", "toURI", "toPackedDecimal", "Lde/jfachwert/math/PackedDecimal;", "Validator", "Companion", "net"})
@SourceDebugExtension(value={"SMAP\nTelefonnummer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Telefonnummer.kt\nde/jfachwert/net/Telefonnummer\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,309:1\n108#2:310\n80#2,22:311\n108#2:333\n80#2,22:334\n37#3,2:356\n*S KotlinDebug\n*F\n+ 1 Telefonnummer.kt\nde/jfachwert/net/Telefonnummer\n*L\n89#1:310\n89#1:311,22\n129#1:333\n129#1:334,22\n129#1:356,2\n*E\n"})
public class Telefonnummer
extends Text {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final KSimpleValidator<String> VALIDATOR = new Validator();
    @NotNull
    private static final WeakHashMap<String, Telefonnummer> WEAK_CACHE = new WeakHashMap();
    @JvmField
    @NotNull
    public static final Telefonnummer NULL = new Telefonnummer("", (KSimpleValidator<String>)((KSimpleValidator)new NullValidator()));

    @JvmOverloads
    public Telefonnummer(@NotNull String nummer, @NotNull KSimpleValidator<String> validator) {
        Intrinsics.checkNotNullParameter((Object)nummer, (String)"nummer");
        Intrinsics.checkNotNullParameter(validator, (String)"validator");
        super(Telefonnummer.Companion.normalize(nummer), validator);
    }

    public /* synthetic */ Telefonnummer(String string, KSimpleValidator kSimpleValidator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            kSimpleValidator = VALIDATOR;
        }
        this(string, kSimpleValidator);
    }

    public Telefonnummer(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = uri.getSchemeSpecificPart();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSchemeSpecificPart(...)");
        this(string, null, 2, null);
    }

    @NotNull
    public final Telefonnummer getInlandsnummer() {
        Telefonnummer telefonnummer;
        if (this.getLaenderkennzahl().isPresent()) {
            CharSequence[] charSequenceArray;
            Object nummer;
            String string = ((String)((Object)this.getCode())).substring(3);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String $this$trim$iv = string;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (StringUtils.startsWithAny((CharSequence)((CharSequence)(nummer = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())), (CharSequence[])(charSequenceArray = new CharSequence[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"}))) {
                nummer = "0" + (String)nummer;
            }
            telefonnummer = new Telefonnummer((String)nummer, null, 2, null);
        } else {
            telefonnummer = this;
        }
        return telefonnummer;
    }

    @NotNull
    public final Optional<String> getLaenderkennzahl() {
        Optional<Object> optional;
        if (StringsKt.startsWith$default((String)((String)((Object)this.getCode())), (String)"+", (boolean)false, (int)2, null)) {
            String string = ((String)((Object)this.getCode())).substring(0, 3);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Optional<String> optional2 = Optional.of(string);
            Intrinsics.checkNotNull(optional2);
            optional = optional2;
        } else if (StringsKt.startsWith$default((String)((String)((Object)this.getCode())), (String)"00", (boolean)false, (int)2, null)) {
            String string = ((String)((Object)this.getCode())).substring(2, 4);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Optional<CallSite> optional3 = Optional.of("+" + string);
            Intrinsics.checkNotNull(optional3);
            optional = optional3;
        } else if (StringsKt.contains$default((CharSequence)((CharSequence)((Object)this.getCode())), (CharSequence)"(0)", (boolean)false, (int)2, null)) {
            String string = ((String)((Object)this.getCode())).substring(0, 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Optional<CallSite> optional4 = Optional.of("+" + string);
            Intrinsics.checkNotNull(optional4);
            optional = optional4;
        } else {
            Optional optional5 = Optional.empty();
            Intrinsics.checkNotNull(optional5);
            optional = optional5;
        }
        return optional;
    }

    @NotNull
    public final String getVorwahl() {
        CharSequence $this$trim$iv = (String)((Object)this.getCode());
        boolean $i$f$trim22 = false;
        CharSequence $this$trim$iv$iv22 = $this$trim$iv;
        boolean $i$f$trim = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv22.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv22.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        $this$trim$iv = ((Object)$this$trim$iv$iv22.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        Regex $i$f$trim22 = new Regex("[ /-]|(\\(0\\))");
        int $this$trim$iv$iv22 = 0;
        Collection $this$toTypedArray$iv = $i$f$trim22.split($this$trim$iv, $this$trim$iv$iv22);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] parts = thisCollection$iv.toArray(new String[0]);
        String vorwahl = parts[0];
        if (StringsKt.startsWith$default((String)vorwahl, (String)"+", (boolean)false, (int)2, null)) {
            vorwahl = StringUtils.isBlank((CharSequence)parts[1]) ? parts[2] : parts[1];
        }
        return StringsKt.startsWith$default((String)(vorwahl = RegExUtils.removeAll((String)vorwahl, (String)"[ \t+-/(\\(\\))]")), (String)"0", (boolean)false, (int)2, null) ? vorwahl : "0" + vorwahl;
    }

    @NotNull
    public final Telefonnummer getRufnummer() {
        String inlandsnummer = RegExUtils.replaceAll((String)this.getInlandsnummer().toString(), (String)"[ /]+", (String)" ");
        String string = StringUtils.substringAfter((String)inlandsnummer, (String)" ");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substringAfter(...)");
        CharSequence charSequence = string;
        Regex regex = new Regex(" ");
        String string2 = "";
        return new Telefonnummer(regex.replace(charSequence, string2), null, 2, null);
    }

    public int hashCode() {
        return this.toShortString().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Telefonnummer)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.toShortString(), (Object)((Telefonnummer)((Object)other)).toShortString());
    }

    @NotNull
    public final String toShortString() {
        String string = RegExUtils.removeAll((String)((String)((Object)this.getCode())), (String)"[ \t+-/]|(\\(0\\))");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"removeAll(...)");
        return string;
    }

    @NotNull
    public final String toDinString() {
        Optional<String> laenderkennzahl = this.getLaenderkennzahl();
        String string = laenderkennzahl.map(arg_0 -> Telefonnummer.toDinString$lambda$3(arg_0 -> Telefonnummer.toDinString$lambda$2(this, arg_0), arg_0)).orElseGet(() -> Telefonnummer.toDinString$lambda$4(this));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"orElseGet(...)");
        return string;
    }

    @NotNull
    public final String toE123String() {
        return this.getLaenderkennzahl().isPresent() ? StringsKt.replace$default((String)this.toDinString(), (char)'-', (char)' ', (boolean)false, (int)4, null) : "(" + this.getVorwahl() + ") " + StringsKt.replace$default((String)this.getRufnummer().toString(), (char)'-', (char)' ', (boolean)false, (int)4, null);
    }

    @NotNull
    public final URI toURI() {
        URI uRI = URI.create("tel:" + StringsKt.replace$default((String)this.toDinString(), (char)' ', (char)'-', (boolean)false, (int)4, null));
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
        return uRI;
    }

    @NotNull
    public final PackedDecimal toPackedDecimal() {
        return PackedDecimal.Companion.of((String)((Object)this.getCode()));
    }

    @JvmOverloads
    public Telefonnummer(@NotNull String nummer) {
        Intrinsics.checkNotNullParameter((Object)nummer, (String)"nummer");
        this(nummer, null, 2, null);
    }

    private static final String toDinString$lambda$2(Telefonnummer this$0, String s) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        String string = this$0.getVorwahl().substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return s + " " + string + " " + this$0.getRufnummer();
    }

    private static final String toDinString$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String toDinString$lambda$4(Telefonnummer this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.getVorwahl() + " " + this$0.getRufnummer();
    }

    @JvmStatic
    @NotNull
    public static final Telefonnummer of(@NotNull String nummer) {
        return Companion.of(nummer);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0006H\u0007J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/jfachwert/net/Telefonnummer$Companion;", "", "<init>", "()V", "VALIDATOR", "Lde/jfachwert/KSimpleValidator;", "", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "Lde/jfachwert/net/Telefonnummer;", "NULL", "of", "nummer", "normalize", "net"})
    @SourceDebugExtension(value={"SMAP\nTelefonnummer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Telefonnummer.kt\nde/jfachwert/net/Telefonnummer$Companion\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,309:1\n108#2:310\n80#2,22:311\n*S KotlinDebug\n*F\n+ 1 Telefonnummer.kt\nde/jfachwert/net/Telefonnummer$Companion\n*L\n301#1:310\n301#1:311,22\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Telefonnummer of(@NotNull String nummer) {
            Intrinsics.checkNotNullParameter((Object)nummer, (String)"nummer");
            char[] cArray = nummer.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            String copy = new String(cArray);
            Telefonnummer telefonnummer = WEAK_CACHE.computeIfAbsent(copy, arg_0 -> Companion.of$lambda$1(Companion::of$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)((Object)telefonnummer), (String)"computeIfAbsent(...)");
            return telefonnummer;
        }

        private final String normalize(String nummer) {
            Object normalized;
            String $this$trim$iv = nummer;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (StringsKt.startsWith$default((String)(normalized = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (String)"(0)", (boolean)false, (int)2, null)) {
                String string = ((String)normalized).substring(3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                normalized = "0" + string;
            }
            return normalized;
        }

        private static final Telefonnummer of$lambda$0(String n) {
            Intrinsics.checkNotNullParameter((Object)n, (String)"n");
            return new Telefonnummer(n, null, 2, null);
        }

        private static final Telefonnummer of$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Telefonnummer)((Object)$tmp0.invoke(p0));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\t\b\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0007J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/jfachwert/net/Telefonnummer$Validator;", "Lde/jfachwert/KSimpleValidator;", "", "pattern", "Ljava/util/regex/Pattern;", "<init>", "(Ljava/util/regex/Pattern;)V", "()V", "lengthValidator", "Lde/jfachwert/pruefung/LengthValidator;", "validate", "value", "net"})
    public static final class Validator
    implements KSimpleValidator<String> {
        @NotNull
        private final Pattern pattern;
        @NotNull
        private final LengthValidator<String> lengthValidator;

        public Validator(@NotNull Pattern pattern) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            this.pattern = pattern;
            this.lengthValidator = new LengthValidator(3, 15);
        }

        public Validator() {
            Pattern pattern = Pattern.compile("[0-9-+/ ()]+");
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
            this(pattern);
        }

        @NotNull
        public String validate(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Matcher matcher = this.pattern.matcher(value);
            if (matcher.matches()) {
                String normalized = RegExUtils.removeAll((String)value, (String)"[ \t+-/]|(\\(0\\))");
                Intrinsics.checkNotNull((Object)normalized);
                this.lengthValidator.validate((Serializable)((Object)normalized));
                return value;
            }
            throw new InvalidValueException((Serializable)((Object)value), "phone_number");
        }

        @Nullable
        public Object validateObject(@NotNull Object value) {
            return KSimpleValidator.DefaultImpls.validateObject((KSimpleValidator)this, (Object)value);
        }

        @NotNull
        public String verify(@NotNull String value) {
            return (String)((Object)KSimpleValidator.DefaultImpls.verify((KSimpleValidator)this, (Serializable)((Serializable)((Object)value))));
        }
    }
}

