/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.net;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.jfachwert.KFachwert;
import de.jfachwert.net.ChatDienst;
import de.jfachwert.pruefung.exception.LocalizedIllegalArgumentException;
import de.jfachwert.util.ToFachwertSerializer;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=ToFachwertSerializer.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0017\u0018\u0000 !2\u00020\u0001:\u0001!B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\nB\u0017\b\u0012\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f\u00a2\u0006\u0004\b\u0007\u0010\rB\u001d\b\u0017\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000f\u00a2\u0006\u0004\b\u0007\u0010\u0010B\u0019\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\u0012B\u0019\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\u0013J\u0006\u0010\u0018\u001a\u00020\u0005J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0005H\u0016J\u0014\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001c0\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\""}, d2={"Lde/jfachwert/net/ChatAccount;", "Lde/jfachwert/KFachwert;", "chatDienst", "Lde/jfachwert/net/ChatDienst;", "dienstName", "", "account", "<init>", "(Lde/jfachwert/net/ChatDienst;Ljava/lang/String;Ljava/lang/String;)V", "chatAccount", "(Ljava/lang/String;)V", "values", "", "([Ljava/lang/String;)V", "map", "", "(Ljava/util/Map;)V", "dienst", "(Ljava/lang/String;Ljava/lang/String;)V", "(Lde/jfachwert/net/ChatDienst;Ljava/lang/String;)V", "getChatDienst", "()Lde/jfachwert/net/ChatDienst;", "getAccount", "()Ljava/lang/String;", "getDienstName", "equals", "", "other", "", "hashCode", "", "toString", "toMap", "Companion", "net"})
public class ChatAccount
implements KFachwert {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChatDienst chatDienst;
    @Nullable
    private final String dienstName;
    @NotNull
    private final String account;
    @NotNull
    private static final WeakHashMap<String, ChatAccount> WEAK_CACHE = new WeakHashMap();
    @JvmField
    @NotNull
    public static final ChatAccount NULL = new ChatAccount(ChatDienst.SONSTIGER, "", "");

    public ChatAccount(@NotNull ChatDienst chatDienst, @Nullable String dienstName, @NotNull String account) {
        Intrinsics.checkNotNullParameter((Object)((Object)chatDienst), (String)"chatDienst");
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        this.chatDienst = chatDienst;
        this.dienstName = dienstName;
        this.account = (String)((Object)this.chatDienst.getValidator().verify((Serializable)((Object)account)));
    }

    @NotNull
    public final ChatDienst getChatDienst() {
        return this.chatDienst;
    }

    @NotNull
    public final String getAccount() {
        return this.account;
    }

    public ChatAccount(@NotNull String chatAccount) {
        Intrinsics.checkNotNullParameter((Object)chatAccount, (String)"chatAccount");
        this(ChatAccount.Companion.split(chatAccount));
    }

    private ChatAccount(String[] values) {
        this(ChatDienst.Companion.of(values[0]), values[0], values[1]);
    }

    @JsonCreator
    public ChatAccount(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        ChatDienst chatDienst = ChatDienst.Companion.of(map.get("chatDienst"));
        String string = map.get("account");
        Intrinsics.checkNotNull((Object)string);
        this(chatDienst, map.get("dienstName"), string);
    }

    public ChatAccount(@NotNull String dienst, @NotNull String account) {
        Intrinsics.checkNotNullParameter((Object)dienst, (String)"dienst");
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        this(ChatDienst.Companion.of(dienst), dienst, account);
    }

    public ChatAccount(@NotNull ChatDienst dienst, @NotNull String account) {
        Intrinsics.checkNotNullParameter((Object)((Object)dienst), (String)"dienst");
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        this(dienst, null, account);
    }

    @NotNull
    public final String getDienstName() {
        String string;
        if (this.chatDienst == ChatDienst.SONSTIGER) {
            String string2 = this.dienstName;
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        } else {
            string = this.chatDienst.toString();
        }
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ChatAccount)) {
            return false;
        }
        return StringsKt.equals((String)this.getDienstName(), (String)((ChatAccount)other).getDienstName(), (boolean)true) && StringsKt.equals((String)this.account, (String)((ChatAccount)other).account, (boolean)true);
    }

    public int hashCode() {
        return this.account.hashCode();
    }

    @NotNull
    public String toString() {
        return this.getDienstName() + ": " + this.account;
    }

    @NotNull
    public Map<String, Object> toMap() {
        Map map = new HashMap();
        map.put("chatDienst", this.chatDienst);
        map.put("dienstName", this.getDienstName());
        map.put("account", this.account);
        return map;
    }

    public boolean isValid() {
        return KFachwert.DefaultImpls.isValid((KFachwert)this);
    }

    @JvmStatic
    @NotNull
    public static final ChatAccount of(@NotNull String name) {
        return Companion.of(name);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0006H\u0007R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/jfachwert/net/ChatAccount$Companion;", "", "<init>", "()V", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "", "Lde/jfachwert/net/ChatAccount;", "NULL", "split", "", "value", "(Ljava/lang/String;)[Ljava/lang/String;", "of", "name", "net"})
    @SourceDebugExtension(value={"SMAP\nChatAccount.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatAccount.kt\nde/jfachwert/net/ChatAccount$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,181:1\n37#2,2:182\n*S KotlinDebug\n*F\n+ 1 ChatAccount.kt\nde/jfachwert/net/ChatAccount$Companion\n*L\n161#1:182,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String[] split(String value) {
            String string = StringUtils.trimToEmpty((String)value);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimToEmpty(...)");
            CharSequence charSequence = string;
            String string2 = ":\\s+";
            int n = 0;
            Pattern pattern = Pattern.compile(string2, n);
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)charSequence, (Pattern)pattern, (int)0, (int)2, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] splitted = thisCollection$iv.toArray(new String[0]);
            if (splitted.length != 2) {
                throw new LocalizedIllegalArgumentException((Serializable)((Object)value), "chat_service", null, 4, null);
            }
            return splitted;
        }

        @JvmStatic
        @NotNull
        public final ChatAccount of(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            ChatAccount chatAccount = WEAK_CACHE.computeIfAbsent(name, arg_0 -> Companion.of$lambda$1(Companion::of$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)chatAccount, (String)"computeIfAbsent(...)");
            return chatAccount;
        }

        private static final ChatAccount of$lambda$0(String chatAccount) {
            Intrinsics.checkNotNullParameter((Object)chatAccount, (String)"chatAccount");
            return new ChatAccount(chatAccount);
        }

        private static final ChatAccount of$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (ChatAccount)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

