/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.money.internal;

import de.jfachwert.money.internal.GeldbetragFormatter;
import de.jfachwert.money.internal.WaehrungsformatProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.money.MonetaryAmountFactory;
import javax.money.format.AmountFormatContext;
import javax.money.format.AmountFormatContextBuilder;
import javax.money.format.AmountFormatQuery;
import javax.money.format.MonetaryAmountFormat;
import javax.money.spi.Bootstrap;
import javax.money.spi.MonetaryAmountFormatProviderSpi;
import javax.money.spi.MonetaryFormatsSingletonSpi;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0005H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lde/jfachwert/money/internal/WaehrungsformatSingleton;", "Ljavax/money/spi/MonetaryFormatsSingletonSpi;", "<init>", "()V", "getAvailableLocales", "", "Ljava/util/Locale;", "providers", "", "", "([Ljava/lang/String;)Ljava/util/Set;", "getAmountFormats", "", "Ljavax/money/format/MonetaryAmountFormat;", "formatQuery", "Ljavax/money/format/AmountFormatQuery;", "getProviderNames", "getDefaultProviderChain", "", "Companion", "money"})
public final class WaehrungsformatSingleton
implements MonetaryFormatsSingletonSpi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Collection<MonetaryFormatsSingletonSpi> MONETARY_FORMATS_SINGLETON_SPIS = new ArrayList();

    @NotNull
    public Set<Locale> getAvailableLocales(String ... providers) {
        Intrinsics.checkNotNullParameter((Object)providers, (String)"providers");
        return WaehrungsformatProvider.INSTANCE.getAvailableLocales();
    }

    @NotNull
    public Collection<MonetaryAmountFormat> getAmountFormats(@NotNull AmountFormatQuery formatQuery) {
        Intrinsics.checkNotNullParameter((Object)formatQuery, (String)"formatQuery");
        Collection result = new ArrayList();
        Locale locale = formatQuery.getLocale();
        MonetaryAmountFactory amountFactory = formatQuery.getMonetaryAmountFactory();
        String formatName = formatQuery.getFormatName();
        AmountFormatContextBuilder amountFormatContextBuilder = AmountFormatContextBuilder.of((String)formatName).setMonetaryAmountFactory(amountFactory);
        Locale locale2 = locale;
        if (locale2 == null) {
            locale2 = Locale.getDefault();
        }
        AmountFormatContext context = amountFormatContextBuilder.setLocale(locale2).build();
        Intrinsics.checkNotNull((Object)context);
        result.add(GeldbetragFormatter.Companion.of(context));
        for (MonetaryAmountFormatProviderSpi spi : Bootstrap.getServices(MonetaryAmountFormatProviderSpi.class)) {
            Collection collection = spi.getAmountFormats(formatQuery);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAmountFormats(...)");
            result.addAll(collection);
        }
        return result;
    }

    @NotNull
    public Set<String> getProviderNames() {
        Set providerNames = new HashSet();
        for (MonetaryFormatsSingletonSpi spi : MONETARY_FORMATS_SINGLETON_SPIS) {
            Set set = spi.getProviderNames();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getProviderNames(...)");
            providerNames.addAll(set);
        }
        return providerNames;
    }

    @NotNull
    public List<String> getDefaultProviderChain() {
        List defaultProviderChain = new ArrayList();
        for (MonetaryFormatsSingletonSpi spi : MONETARY_FORMATS_SINGLETON_SPIS) {
            List list = spi.getDefaultProviderChain();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDefaultProviderChain(...)");
            defaultProviderChain.addAll(list);
        }
        return defaultProviderChain;
    }

    static {
        for (MonetaryFormatsSingletonSpi spi : Bootstrap.getServices(MonetaryFormatsSingletonSpi.class)) {
            if (spi instanceof WaehrungsformatSingleton) continue;
            Intrinsics.checkNotNull((Object)spi);
            MONETARY_FORMATS_SINGLETON_SPIS.add(spi);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lde/jfachwert/money/internal/WaehrungsformatSingleton$Companion;", "", "<init>", "()V", "MONETARY_FORMATS_SINGLETON_SPIS", "", "Ljavax/money/spi/MonetaryFormatsSingletonSpi;", "money"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

