/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.money.internal;

import de.jfachwert.money.Waehrung;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyQuery;
import javax.money.CurrencyUnit;
import javax.money.spi.CurrencyProviderSpi;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lde/jfachwert/money/internal/WaehrungenProvider;", "Ljavax/money/spi/CurrencyProviderSpi;", "<init>", "()V", "getCurrencies", "", "Ljavax/money/CurrencyUnit;", "query", "Ljavax/money/CurrencyQuery;", "addCountryTo", "", "currencies", "", "country", "Ljava/util/Locale;", "getProviderName", "", "Companion", "money"})
public final class WaehrungenProvider
implements CurrencyProviderSpi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = Logger.getLogger(WaehrungenProvider.class.getName());
    @NotNull
    private static final Map<String, CurrencyUnit> AVAILABLE_CURRENCIES;

    @NotNull
    public Set<CurrencyUnit> getCurrencies(@NotNull CurrencyQuery query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Set currencies = new HashSet();
        for (String code : query.getCurrencyCodes()) {
            CurrencyUnit cu = AVAILABLE_CURRENCIES.get(code);
            if (cu == null) continue;
            currencies.add(cu);
        }
        for (Locale country : query.getCountries()) {
            Intrinsics.checkNotNull((Object)country);
            this.addCountryTo(currencies, country);
        }
        for (Integer numCode : query.getNumericCodes()) {
            for (Currency c : Currency.getAvailableCurrencies()) {
                Integer n = numCode;
                if (n == null || c.getNumericCode() != n.intValue()) continue;
                CurrencyUnit currencyUnit = AVAILABLE_CURRENCIES.get(c.getCurrencyCode());
                Intrinsics.checkNotNull((Object)currencyUnit);
                currencies.add(currencyUnit);
            }
        }
        return currencies;
    }

    private final void addCountryTo(Set<CurrencyUnit> currencies, Locale country) {
        try {
            Currency c = Currency.getInstance(country);
            CurrencyUnit cu = AVAILABLE_CURRENCIES.get(c.getCurrencyCode());
            if (cu != null) {
                currencies.add(cu);
            }
        }
        catch (IllegalArgumentException ex) {
            log.log(Level.FINE, "Kann Waehrung fuer '" + country + "' nicht hinzufuegen.");
            log.log(Level.FINER, "Details:", ex);
        }
    }

    @NotNull
    public String getProviderName() {
        return "jfachwert";
    }

    static {
        Set<Currency> availableCurrencies = Currency.getAvailableCurrencies();
        Map currencyUnits = new HashMap(availableCurrencies.size());
        for (Currency currency : availableCurrencies) {
            Intrinsics.checkNotNull((Object)currency);
            CurrencyUnit cu = new Waehrung(currency);
            currencyUnits.put(cu.getCurrencyCode(), cu);
        }
        AVAILABLE_CURRENCIES = Collections.unmodifiableMap(currencyUnits);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/jfachwert/money/internal/WaehrungenProvider$Companion;", "", "<init>", "()V", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "Ljava/util/logging/Logger;", "AVAILABLE_CURRENCIES", "", "", "Ljavax/money/CurrencyUnit;", "money"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

