/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.money;

import de.jfachwert.money.Geldbetrag;
import de.jfachwert.money.Waehrung;
import de.jfachwert.money.pruefung.exception.LocalizedMonetaryException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryContext;
import javax.money.MonetaryContextBuilder;
import javax.money.NumberValue;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f0\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0014H\u0016J\u0010\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0015H\u0016J\u0010\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0016\u001a\u00020\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\nH\u0016J\b\u0010\u001c\u001a\u00020\u0002H\u0016J\b\u0010\u001d\u001a\u00020\nH\u0016J\b\u0010\u001e\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006 "}, d2={"Lde/jfachwert/money/GeldbetragFactory;", "Ljavax/money/MonetaryAmountFactory;", "Lde/jfachwert/money/Geldbetrag;", "<init>", "()V", "number", "", "currency", "Ljavax/money/CurrencyUnit;", "context", "Ljavax/money/MonetaryContext;", "kotlin.jvm.PlatformType", "Ljavax/money/MonetaryContext;", "getAmountType", "Ljava/lang/Class;", "Ljavax/money/MonetaryAmount;", "setCurrency", "currencyCode", "", "setNumber", "", "", "getMonetaryContextOf", "getMaxNumber", "Ljavax/money/NumberValue;", "getMinNumber", "setContext", "monetaryContext", "create", "getDefaultMonetaryContext", "getMaximalMonetaryContext", "Companion", "money"})
public class GeldbetragFactory
implements MonetaryAmountFactory<Geldbetrag> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Number number;
    @Nullable
    private CurrencyUnit currency;
    private MonetaryContext context;
    @JvmField
    public static final MonetaryContext MAX_CONTEXT = ((MonetaryContextBuilder)MonetaryContextBuilder.of(Geldbetrag.class).setAmountType(Geldbetrag.class).setPrecision(0).setMaxScale(-1).set((Object)RoundingMode.HALF_UP)).build();

    public GeldbetragFactory() {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
        this.number = bigDecimal;
        this.context = ((MonetaryContextBuilder)MonetaryContextBuilder.of(Geldbetrag.class).setAmountType(Geldbetrag.class).setPrecision(41).setMaxScale(4).set((Object)RoundingMode.HALF_UP)).build();
    }

    @NotNull
    public Class<? extends MonetaryAmount> getAmountType() {
        return Geldbetrag.class;
    }

    @NotNull
    public GeldbetragFactory setCurrency(@NotNull CurrencyUnit currency) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        this.currency = currency;
        return this;
    }

    @NotNull
    public GeldbetragFactory setCurrency(@NotNull String currencyCode) {
        Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"currencyCode");
        return this.setCurrency(Waehrung.Companion.of(currencyCode));
    }

    @NotNull
    public GeldbetragFactory setNumber(double number) {
        BigDecimal bigDecimal = BigDecimal.valueOf(number);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        return this.setNumber(bigDecimal);
    }

    @NotNull
    public GeldbetragFactory setNumber(long number) {
        BigDecimal bigDecimal = BigDecimal.valueOf(number);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        return this.setNumber(bigDecimal);
    }

    @NotNull
    public GeldbetragFactory setNumber(@NotNull Number number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        this.number = number;
        this.context = this.getMonetaryContextOf(number);
        return this;
    }

    @NotNull
    public final MonetaryContext getMonetaryContextOf(@Nullable Number number) {
        Number value;
        if (number instanceof BigDecimal && ((BigDecimal)(value = number)).scale() > this.context.getMaxScale()) {
            MonetaryContext monetaryContext = ((MonetaryContextBuilder)MonetaryContextBuilder.of(Geldbetrag.class).setAmountType(Geldbetrag.class).setPrecision(this.context.getPrecision()).setMaxScale(((BigDecimal)value).scale()).set((Object)RoundingMode.HALF_UP)).build();
            Intrinsics.checkNotNullExpressionValue((Object)monetaryContext, (String)"build(...)");
            return monetaryContext;
        }
        MonetaryContext monetaryContext = this.context;
        Intrinsics.checkNotNullExpressionValue((Object)monetaryContext, (String)"context");
        return monetaryContext;
    }

    @NotNull
    public NumberValue getMaxNumber() {
        return Geldbetrag.MAX_VALUE.getNumber();
    }

    @NotNull
    public NumberValue getMinNumber() {
        return Geldbetrag.MIN_VALUE.getNumber();
    }

    @NotNull
    public GeldbetragFactory setContext(@NotNull MonetaryContext monetaryContext) {
        Intrinsics.checkNotNullParameter((Object)monetaryContext, (String)"monetaryContext");
        this.context = monetaryContext;
        return this;
    }

    @NotNull
    public Geldbetrag create() {
        if (this.currency == null) {
            Object[] objectArray = new Object[]{this.number};
            throw new LocalizedMonetaryException("currency missing", objectArray);
        }
        CurrencyUnit currencyUnit = this.currency;
        Intrinsics.checkNotNull((Object)currencyUnit);
        MonetaryContext monetaryContext = this.context;
        Intrinsics.checkNotNullExpressionValue((Object)monetaryContext, (String)"context");
        return Geldbetrag.Companion.valueOf(this.number, currencyUnit, monetaryContext);
    }

    @NotNull
    public MonetaryContext getDefaultMonetaryContext() {
        MonetaryContext monetaryContext = this.context;
        Intrinsics.checkNotNullExpressionValue((Object)monetaryContext, (String)"context");
        return monetaryContext;
    }

    @NotNull
    public MonetaryContext getMaximalMonetaryContext() {
        MonetaryContext monetaryContext = MAX_CONTEXT;
        Intrinsics.checkNotNullExpressionValue((Object)monetaryContext, (String)"MAX_CONTEXT");
        return monetaryContext;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lde/jfachwert/money/GeldbetragFactory$Companion;", "", "<init>", "()V", "MAX_CONTEXT", "Ljavax/money/MonetaryContext;", "kotlin.jvm.PlatformType", "Ljavax/money/MonetaryContext;", "money"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

