/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.money.internal;

import de.jfachwert.money.Geldbetrag;
import de.jfachwert.money.Waehrung;
import de.jfachwert.money.pruefung.exception.LocalizedMonetaryParseException;
import de.jfachwert.pruefung.NullValidator;
import de.jfachwert.pruefung.NumberValidator;
import de.jfachwert.pruefung.exception.InvalidValueException;
import de.jfachwert.pruefung.exception.ValidationException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.format.AmountFormatContext;
import javax.money.format.AmountFormatContextBuilder;
import javax.money.format.MonetaryAmountFormat;
import javax.money.format.MonetaryParseException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0001 B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006B\u0011\b\u0012\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0004\u0010\tJ\b\u0010\n\u001a\u00020\u0003H\u0016J!\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000fj\u0002`\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u001f\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lde/jfachwert/money/internal/GeldbetragFormatter;", "Ljavax/money/format/MonetaryAmountFormat;", "context", "Ljavax/money/format/AmountFormatContext;", "<init>", "(Ljavax/money/format/AmountFormatContext;)V", "()V", "locale", "Ljava/util/Locale;", "(Ljava/util/Locale;)V", "getContext", "print", "", "appendable", "Lkotlin/text/Appendable;", "Ljava/lang/Appendable;", "amount", "Ljavax/money/MonetaryAmount;", "(Ljava/lang/Appendable;Ljavax/money/MonetaryAmount;)V", "getFormatter", "Ljava/text/NumberFormat;", "parse", "text", "", "", "getMonetaryAmount", "cry", "Ljava/util/Currency;", "n", "Ljava/math/BigDecimal;", "queryFrom", "toString", "Companion", "money"})
@SourceDebugExtension(value={"SMAP\nGeldbetragFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeldbetragFormatter.kt\nde/jfachwert/money/internal/GeldbetragFormatter\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,186:1\n108#2:187\n80#2,22:188\n108#2:210\n80#2,22:211\n*S KotlinDebug\n*F\n+ 1 GeldbetragFormatter.kt\nde/jfachwert/money/internal/GeldbetragFormatter\n*L\n141#1:187\n141#1:188,22\n149#1:210\n149#1:211,22\n*E\n"})
public final class GeldbetragFormatter
implements MonetaryAmountFormat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AmountFormatContext context;
    @NotNull
    private static final Map<Locale, Locale> MAPPED_LOCALES = new HashMap();

    private GeldbetragFormatter(AmountFormatContext context) {
        this.context = context;
    }

    public GeldbetragFormatter() {
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        this(locale);
    }

    private GeldbetragFormatter(Locale locale) {
        AmountFormatContext amountFormatContext = AmountFormatContextBuilder.of((String)"jfachwert").setLocale(locale).build();
        Intrinsics.checkNotNullExpressionValue((Object)amountFormatContext, (String)"build(...)");
        this(amountFormatContext);
    }

    @NotNull
    public AmountFormatContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(@NotNull Appendable appendable, @NotNull MonetaryAmount amount) throws IOException {
        Intrinsics.checkNotNullParameter((Object)appendable, (String)"appendable");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        CurrencyUnit currency = amount.getCurrency();
        int fractionDigits = currency.getDefaultFractionDigits();
        AmountFormatContext amountFormatContext = this.context;
        synchronized (amountFormatContext) {
            boolean bl = false;
            Locale locale = this.context.getLocale();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getLocale(...)");
            NumberFormat formatter = this.getFormatter(locale);
            formatter.setMinimumFractionDigits(fractionDigits);
            formatter.setMaximumFractionDigits(fractionDigits);
            String s = formatter.format(amount.getNumber()) + " " + currency;
            Appendable appendable2 = appendable.append(s);
        }
    }

    private final NumberFormat getFormatter(Locale locale) {
        NumberFormat formatter = NumberFormat.getInstance(locale);
        String s = formatter.format(0L);
        if (!Intrinsics.areEqual((Object)"0", (Object)s)) {
            formatter = NumberFormat.getInstance();
        }
        NumberFormat numberFormat = formatter;
        Intrinsics.checkNotNull((Object)numberFormat);
        return numberFormat;
    }

    @NotNull
    public MonetaryAmount parse(@NotNull CharSequence text) throws MonetaryParseException {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = Objects.toString(text);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return this.parse(string);
    }

    private final MonetaryAmount parse(String text) throws MonetaryParseException {
        MonetaryAmount monetaryAmount;
        String trimmed;
        String[] parts;
        String $this$trim$iv = (String)((Object)new NullValidator().validate((Serializable)((Object)text)));
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if ((parts = StringUtils.splitByCharacterType((String)StringUtils.upperCase((String)(trimmed = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())))).length == 0) {
            throw new InvalidValueException((Serializable)((Object)text), "money amount");
        }
        Currency cry = Waehrung.DEFAULT_CURRENCY;
        Intrinsics.checkNotNull((Object)parts);
        String currencyString = GeldbetragFormatter.Companion.findCurrencyString(parts);
        try {
            String string = StringUtils.remove((String)trimmed, (String)currencyString);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"remove(...)");
            String $this$trim$iv2 = string;
            boolean $i$f$trim3 = false;
            CharSequence $this$trim$iv$iv2 = $this$trim$iv2;
            boolean $i$f$trim4 = false;
            int startIndex$iv$iv2 = 0;
            int endIndex$iv$iv2 = $this$trim$iv$iv2.length() - 1;
            boolean startFound$iv$iv2 = false;
            while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                char it = $this$trim$iv$iv2.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv2) {
                    if (!match$iv$iv) {
                        startFound$iv$iv2 = true;
                        continue;
                    }
                    ++startIndex$iv$iv2;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv2;
            }
            trimmed = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString();
            BigDecimal n = new BigDecimal(new NumberValidator(null, null, 3, null).validate(trimmed));
            if (StringUtils.isNotEmpty((CharSequence)currencyString)) {
                cry = Waehrung.Companion.toCurrency(currencyString);
            }
            monetaryAmount = this.getMonetaryAmount(cry, n);
        }
        catch (IllegalArgumentException ex) {
            throw new LocalizedMonetaryParseException(text, ex);
        }
        catch (ValidationException ex) {
            throw new LocalizedMonetaryParseException(text, ex);
        }
        return monetaryAmount;
    }

    private final MonetaryAmount getMonetaryAmount(Currency cry, BigDecimal n) {
        MonetaryAmount monetaryAmount;
        MonetaryAmountFactory amountFactory = (MonetaryAmountFactory)this.context.get(MonetaryAmountFactory.class);
        if (amountFactory == null) {
            monetaryAmount = Geldbetrag.Companion.of((Number)n, cry);
        } else {
            MonetaryAmount monetaryAmount2 = amountFactory.setNumber((Number)n).setCurrency(cry.toString()).create();
            Intrinsics.checkNotNull((Object)monetaryAmount2);
            monetaryAmount = monetaryAmount2;
        }
        return monetaryAmount;
    }

    @NotNull
    public String queryFrom(@NotNull MonetaryAmount amount) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        String string = Objects.toString(amount);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.context.getLocale() + ")";
    }

    @JvmStatic
    @NotNull
    public static final GeldbetragFormatter of(@NotNull Locale locale) {
        return Companion.of(locale);
    }

    @JvmStatic
    @NotNull
    public static final GeldbetragFormatter of(@NotNull AmountFormatContext context) {
        return Companion.of(context);
    }

    public /* synthetic */ GeldbetragFormatter(AmountFormatContext context, DefaultConstructorMarker $constructor_marker) {
        this(context);
    }

    static {
        MAPPED_LOCALES.put(new Locale("de_DE"), Locale.GERMANY);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001b\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/jfachwert/money/internal/GeldbetragFormatter$Companion;", "", "<init>", "()V", "MAPPED_LOCALES", "", "Ljava/util/Locale;", "of", "Lde/jfachwert/money/internal/GeldbetragFormatter;", "locale", "context", "Ljavax/money/format/AmountFormatContext;", "findCurrencyString", "", "parts", "", "([Ljava/lang/String;)Ljava/lang/String;", "money"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GeldbetragFormatter of(@NotNull Locale locale) {
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            Locale mapped = MAPPED_LOCALES.getOrDefault(locale, locale);
            AmountFormatContext amountFormatContext = AmountFormatContextBuilder.of((String)"jfachwert").setLocale(mapped).build();
            Intrinsics.checkNotNullExpressionValue((Object)amountFormatContext, (String)"build(...)");
            return new GeldbetragFormatter(amountFormatContext, null);
        }

        @JvmStatic
        @NotNull
        public final GeldbetragFormatter of(@NotNull AmountFormatContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new GeldbetragFormatter(context, null);
        }

        private final String findCurrencyString(String[] parts) {
            CharSequence charSequence = parts[0];
            new Regex("[0-9]+").matches(charSequence);
            if (!StringUtils.isNumericSpace((CharSequence)parts[0]) && !new Regex("[+-]+").matches(charSequence = (CharSequence)parts[0])) {
                return parts[0];
            }
            return !StringUtils.isNumericSpace((CharSequence)parts[parts.length - 1]) ? parts[parts.length - 1] : "";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

