/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.bank;

import de.jfachwert.KSimpleValidator;
import de.jfachwert.money.Waehrung;
import de.jfachwert.money.pruefung.exception.LocalizedUnknownCurrencyException;
import java.io.Serializable;
import java.util.Currency;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lde/jfachwert/bank/Waehrung;", "Lde/jfachwert/money/Waehrung;", "code", "Ljava/util/Currency;", "validator", "Lde/jfachwert/KSimpleValidator;", "<init>", "(Ljava/util/Currency;Lde/jfachwert/KSimpleValidator;)V", "Companion", "money"})
public final class Waehrung
extends de.jfachwert.money.Waehrung {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = Logger.getLogger(de.jfachwert.money.Waehrung.class.getName());
    @NotNull
    private static final KSimpleValidator<String> VALIDATOR = new Waehrung.Validator();
    @JvmField
    @NotNull
    public static final Currency DEFAULT_CURRENCY = de.jfachwert.bank.Waehrung$Companion.access$getDefaultCurrency(Companion);
    @JvmField
    @NotNull
    public static final de.jfachwert.money.Waehrung DEFAULT = new de.jfachwert.money.Waehrung(DEFAULT_CURRENCY);
    @JvmField
    @NotNull
    public static final de.jfachwert.money.Waehrung EUR = Companion.of("EUR");
    @JvmField
    @NotNull
    public static final de.jfachwert.money.Waehrung NULL = new de.jfachwert.money.Waehrung("XXX");

    public Waehrung(@NotNull Currency code, @NotNull KSimpleValidator<Currency> validator) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter(validator, (String)"validator");
        super(code, validator);
    }

    @JvmStatic
    @NotNull
    public static final de.jfachwert.money.Waehrung of(@NotNull Currency currency) {
        return Companion.of(currency);
    }

    @JvmStatic
    @NotNull
    public static final de.jfachwert.money.Waehrung of(@NotNull CurrencyUnit currencyUnit) {
        return Companion.of(currencyUnit);
    }

    @JvmStatic
    @NotNull
    public static final de.jfachwert.money.Waehrung of(@NotNull String currency) {
        return Companion.of(currency);
    }

    @JvmStatic
    @NotNull
    public static final Currency toCurrency(@NotNull String name) {
        return Companion.toCurrency(name);
    }

    @JvmStatic
    @NotNull
    public static final String validate(@NotNull String code) {
        return Companion.validate(code);
    }

    @JvmStatic
    @NotNull
    public static final String getSymbol(@NotNull CurrencyUnit cu) {
        return Companion.getSymbol(cu);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\fH\u0007J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\nH\u0007J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\nH\u0007J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\fH\u0002J!\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\n2\n\u0010\u001b\u001a\u00060\u001dj\u0002`\u001cH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\nH\u0007J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u0014H\u0007R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lde/jfachwert/bank/Waehrung$Companion;", "", "<init>", "()V", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "Ljava/util/logging/Logger;", "VALIDATOR", "Lde/jfachwert/KSimpleValidator;", "", "DEFAULT_CURRENCY", "Ljava/util/Currency;", "DEFAULT", "Lde/jfachwert/money/Waehrung;", "EUR", "NULL", "of", "currency", "currencyUnit", "Ljavax/money/CurrencyUnit;", "toCurrency", "name", "matchesCurrency", "", "c", "toFallbackCurrency", "iae", "Lkotlin/IllegalArgumentException;", "Ljava/lang/IllegalArgumentException;", "(Ljava/lang/String;Ljava/lang/IllegalArgumentException;)Ljava/util/Currency;", "validate", "code", "getSymbol", "cu", "defaultCurrency", "getDefaultCurrency", "()Ljava/util/Currency;", "money"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final de.jfachwert.money.Waehrung of(@NotNull Currency currency) {
            Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
            return new de.jfachwert.money.Waehrung(currency);
        }

        @JvmStatic
        @NotNull
        public final de.jfachwert.money.Waehrung of(@NotNull CurrencyUnit currencyUnit) {
            de.jfachwert.money.Waehrung waehrung;
            Intrinsics.checkNotNullParameter((Object)currencyUnit, (String)"currencyUnit");
            if (currencyUnit instanceof de.jfachwert.money.Waehrung) {
                waehrung = (de.jfachwert.money.Waehrung)currencyUnit;
            } else {
                String string = currencyUnit.getCurrencyCode();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCurrencyCode(...)");
                waehrung = this.of(string);
            }
            return waehrung;
        }

        @JvmStatic
        @NotNull
        public final de.jfachwert.money.Waehrung of(@NotNull String currency) {
            Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
            return this.of(this.toCurrency(currency));
        }

        @JvmStatic
        @NotNull
        public final Currency toCurrency(@NotNull String name) {
            Currency currency;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            try {
                currency = Currency.getInstance(name);
            }
            catch (IllegalArgumentException iae) {
                Object object;
                if (name.length() <= 3) {
                    for (Currency c : Currency.getAvailableCurrencies()) {
                        Intrinsics.checkNotNull((Object)c);
                        if (!this.matchesCurrency(name, c)) continue;
                        return c;
                    }
                    object = this.toFallbackCurrency(name, iae);
                } else {
                    Currency currency2;
                    try {
                        String string = name.substring(0, 3);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        currency2 = this.toCurrency(string);
                    }
                    catch (LocalizedUnknownCurrencyException ex) {
                        throw new LocalizedUnknownCurrencyException(name, (Throwable)((Object)ex));
                    }
                    object = currency2;
                }
                currency = object;
            }
            return currency;
        }

        private final boolean matchesCurrency(String name, Currency c) {
            return StringsKt.equals((String)name, (String)c.getCurrencyCode(), (boolean)true) || StringsKt.equals((String)name, (String)c.getSymbol(), (boolean)true);
        }

        private final Currency toFallbackCurrency(String name, IllegalArgumentException iae) {
            if (!Intrinsics.areEqual((Object)name, (Object)"\u20ac")) {
                throw new LocalizedUnknownCurrencyException(name, iae);
            }
            Currency currency = Currency.getInstance("EUR");
            Intrinsics.checkNotNull((Object)currency);
            return currency;
        }

        @JvmStatic
        @NotNull
        public final String validate(@NotNull String code) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            return (String)((Object)VALIDATOR.validate((Serializable)((Object)code)));
        }

        @JvmStatic
        @NotNull
        public final String getSymbol(@NotNull CurrencyUnit cu) {
            String string;
            Intrinsics.checkNotNullParameter((Object)cu, (String)"cu");
            try {
                string = this.of(cu).getSymbol();
            }
            catch (IllegalArgumentException ex) {
                log.log(Level.FINE, "Kann das Symbol fuer '" + cu + "' nicht ermitteln:", ex);
                string = cu.getCurrencyCode();
            }
            return string;
        }

        private final Currency getDefaultCurrency() {
            Locale[] localeArray = new Locale[]{Locale.getDefault(), Locale.GERMANY, Locale.GERMAN};
            for (Locale loc : localeArray) {
                try {
                    Currency currency = Currency.getInstance(loc);
                    Intrinsics.checkNotNullExpressionValue((Object)currency, (String)"getInstance(...)");
                    return currency;
                }
                catch (IllegalArgumentException iae) {
                    log.log(Level.FINE, "Keine Waehrung fuer Locale '" + loc + "' verhanden - versuche es mit einer anderen.");
                    log.log(Level.FINER, "Details:", iae);
                }
            }
            Currency currency = Currency.getAvailableCurrencies().iterator().next();
            Intrinsics.checkNotNullExpressionValue((Object)currency, (String)"next(...)");
            return currency;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ Currency access$getDefaultCurrency(Companion $this) {
            return $this.getDefaultCurrency();
        }
    }
}

